/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketException;

class BufferWrapper
implements Packet {
    private ByteBuffer buffer;
    private long sequence;
    private boolean closed;
    private boolean shared;

    public BufferWrapper(ByteBuffer buffer, long sequence) {
        this(buffer, sequence, true);
    }

    public BufferWrapper(ByteBuffer buffer, long sequence, boolean shared) {
        this.sequence = sequence;
        this.buffer = buffer;
        this.shared = shared;
    }

    public long sequence() {
        return this.sequence;
    }

    public int space() {
        return 0;
    }

    public int capacity() {
        return this.length();
    }

    public int length() {
        int offset = this.buffer.position();
        int limit = this.buffer.limit();
        if (this.closed) {
            return 0;
        }
        return limit - offset;
    }

    public int compareTo(Packet packet) {
        long other = packet.sequence();
        if (other > this.sequence) {
            return -1;
        }
        if (this.sequence > other) {
            return 1;
        }
        return 0;
    }

    public Packet extract() throws IOException {
        int length = this.length();
        if (this.closed) {
            throw new PacketException("Packet is closed");
        }
        if (length <= 0) {
            return this.extract(0);
        }
        if (!this.shared) {
            return this;
        }
        return this.extract(length);
    }

    private Packet extract(int size) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(size);
        if (size > 0) {
            data.put(this.buffer);
            data.position(0);
        }
        return new BufferWrapper(data, this.sequence, false);
    }

    public String encode() throws IOException {
        return this.encode("UTF-8");
    }

    public String encode(String encoding) throws IOException {
        ByteBuffer segment = this.buffer.duplicate();
        if (segment == null) {
            return new String();
        }
        return this.encode(encoding, segment);
    }

    private String encode(String encoding, ByteBuffer buffer) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharBuffer text = charset.decode(buffer);
        return text.toString();
    }

    public int append(ByteBuffer buffer) throws IOException {
        return this.append(buffer, 0);
    }

    public int append(ByteBuffer buffer, int count) throws IOException {
        if (this.closed) {
            throw new PacketException("Packet is closed");
        }
        return 0;
    }

    public int write(ByteChannel channel) throws IOException {
        int size = this.length();
        if (this.closed) {
            throw new PacketException("Packet is closed");
        }
        if (size <= 0) {
            return 0;
        }
        return this.write(channel, size);
    }

    public int write(ByteChannel channel, int count) throws IOException {
        if (this.closed) {
            throw new PacketException("Packet is closed");
        }
        return this.write(channel, this.buffer);
    }

    private int write(ByteChannel channel, ByteBuffer segment) throws IOException {
        int count;
        int size;
        int require = segment.remaining();
        for (count = 0; count < require && (size = channel.write(segment)) > 0; count += size) {
        }
        return count;
    }

    public boolean isReference() {
        return this.shared;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public String toString() {
        return String.format("%s %s", this.sequence, this.buffer);
    }
}

