/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Negotiator;
import org.simpleframework.transport.OperationFactory;
import org.simpleframework.transport.Processor;
import org.simpleframework.transport.SecureNegotiator;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.Terminator;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.util.thread.Daemon;

public class ProcessorServer
implements Server {
    private final OperationFactory factory;
    private final Negotiator negotiator;
    private final Daemon terminator;

    public ProcessorServer(Processor processor) throws IOException {
        this(processor, 8);
    }

    public ProcessorServer(Processor processor, int threads) throws IOException {
        this(processor, threads, 20480);
    }

    public ProcessorServer(Processor processor, int threads, int threshold) throws IOException {
        this(processor, threads, threshold, 4096);
    }

    public ProcessorServer(Processor processor, int threads, int threshold, int buffer) throws IOException {
        this(processor, threads, threshold, buffer, 3);
    }

    public ProcessorServer(Processor processor, int threads, int threshold, int buffer, int queue) throws IOException {
        this(processor, threads, threshold, buffer, queue, false);
    }

    public ProcessorServer(Processor processor, int threads, int threshold, int buffer, int queue, boolean client) throws IOException {
        this.negotiator = new SecureNegotiator(processor, threads);
        this.factory = new OperationFactory(this.negotiator, threshold, buffer, queue, client);
        this.terminator = new Terminator(processor, this.negotiator);
    }

    public void process(Socket socket) throws IOException {
        Operation task = this.factory.getInstance(socket);
        if (task != null) {
            this.negotiator.process(task);
        }
    }

    public void stop() throws IOException {
        this.terminator.start();
    }
}

