/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Dimension;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.engine.header.ContentType;
import org.restlet.engine.header.DimensionWriter;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.jaxrs.internal.core.UnmodifiableMultivaluedMap;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.exceptions.JaxRsRuntimeException;
import org.restlet.ext.jaxrs.internal.exceptions.MethodInvokeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.EncodeOrCheck;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class Util {
    public static final CharacterSet JAX_RS_DEFAULT_CHARACTER_SET = CharacterSet.UTF_8;
    public static final String JAX_RS_DEFAULT_CHARACTER_SET_AS_STRING = JAX_RS_DEFAULT_CHARACTER_SET.toString();
    public static final Comparator<MediaType> MEDIA_TYPE_COMP = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType mediaType1, MediaType mediaType2) {
            int specNess2;
            if (mediaType1 == null) {
                return mediaType2 == null ? 0 : 1;
            }
            if (mediaType2 == null) {
                return -1;
            }
            if (mediaType1.equals((Object)mediaType2, false)) {
                return 0;
            }
            int specNess1 = Util.specificness(mediaType1);
            int rt = specNess1 - (specNess2 = Util.specificness(mediaType2));
            if (rt != 0) {
                return rt;
            }
            return mediaType1.toString().compareToIgnoreCase(mediaType2.toString());
        }
    };
    private static final byte NAME_READ = 2;
    private static final byte NAME_READ_READY = 3;
    private static final byte NAME_READ_START = 1;
    public static final String ORG_RESTLET_EXT_JAXRS_HTTP_HEADERS = "org.restlet.ext.jaxrs.http.headers";

    public static void append(Appendable stb, CharSequence string, boolean convertBraces) throws IOException {
        Util.append(stb, string, convertBraces, 0, string.length());
    }

    public static void append(Appendable stb, CharSequence string, boolean convertBraces, int startIndex) throws IOException {
        Util.append(stb, string, convertBraces, startIndex, string.length());
    }

    public static void append(Appendable stb, CharSequence string, boolean convertBraces, int startIndex, int endIndex) throws IOException {
        if (!convertBraces) {
            stb.append(string, startIndex, endIndex);
            return;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                stb.append("%7B");
                continue;
            }
            if (c == '}') {
                stb.append("%7D");
                continue;
            }
            stb.append(c);
        }
    }

    public static void append(StringBuilder stb, Object[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        stb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            stb.append(", ");
            stb.append(array[i]);
        }
    }

    private static boolean checkClassAndInterfacesForAnnotation(Class<?> jaxRsClass, Class<? extends Annotation> annotationClass) {
        boolean found = jaxRsClass.isAnnotationPresent(annotationClass);
        if (!found) {
            Class<?>[] interfaces = jaxRsClass.getInterfaces();
            for (int i = 0; !found && i < interfaces.length; ++i) {
                found = interfaces[i].isAnnotationPresent(annotationClass);
            }
        }
        return found;
    }

    public static void checkClassConcrete(Class<?> jaxRsClass, String typeName) throws IllegalArgumentException {
        int modifiers = jaxRsClass.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new IllegalArgumentException("The " + typeName + " " + jaxRsClass.getName() + " is not concrete");
        }
    }

    public static void copyResponseHeaders(MultivaluedMap<String, Object> jaxRsHeaders, Response restletResponse) {
        Series headers = new Series(Header.class);
        for (Map.Entry m : jaxRsHeaders.entrySet()) {
            String headerName = (String)m.getKey();
            for (Object headerValue : (List)m.getValue()) {
                String hValue = headerValue == null ? null : (headerValue instanceof Date ? Util.formatDate((Date)headerValue, false) : headerValue.toString());
                headers.add(headerName, hValue);
            }
        }
        if (restletResponse.getEntity() == null) {
            restletResponse.setEntity((Representation)new EmptyRepresentation());
        }
        HeaderUtils.copyResponseTransportHeaders((Series)headers, (Response)restletResponse);
        HeaderUtils.extractEntityHeaders((Iterable)headers, (Representation)restletResponse.getEntity());
        Series extensionHeaders = (Series)jaxRsHeaders.getFirst((Object)"org.restlet.http.headers");
        if (extensionHeaders != null) {
            HashMap<String, Series> attributes = new HashMap<String, Series>();
            attributes.put("org.restlet.http.headers", extensionHeaders);
            restletResponse.setAttributes(attributes);
        }
        HeaderUtils.copyExtensionHeaders((Series)headers, (Response)restletResponse);
    }

    public static Series<Header> copyResponseHeaders(Response restletResponse) {
        Series headers = new Series(Header.class);
        HeaderUtils.addResponseHeaders((Response)restletResponse, (Series)headers);
        HeaderUtils.addEntityHeaders((Representation)restletResponse.getEntity(), (Series)headers);
        return headers;
    }

    public static <A> Collection<A> createColl(A ... objects) {
        return Util.createList(objects);
    }

    public static <A> List<A> createList(A ... objects) {
        ArrayList<A> list = new ArrayList<A>();
        for (A o : objects) {
            if (o == null) continue;
            list.add(o);
        }
        return list;
    }

    public static Map<String, String> createMap(String ... keysAndValues) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    public static <A> Set<A> createSet(A ... objects) {
        HashSet<A> set = new HashSet<A>();
        for (A o : objects) {
            if (o == null) continue;
            set.add(o);
        }
        return set;
    }

    public static boolean doesImplement(Class<?> clazz, Class<?> interfaze) {
        if (clazz == null || interfaze == null) {
            return false;
        }
        if (Util.doesImplement(clazz.getSuperclass(), interfaze)) {
            return true;
        }
        for (Class<?> interf : clazz.getInterfaces()) {
            if (interf.equals(interfaze)) {
                return true;
            }
            if (!Util.doesImplement(interf, interfaze)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence charSequence, char character) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) {
            return false;
        }
        return charSequence.charAt(charSequence.length() - 1) == character;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    public static String formatDate(Date date, boolean cookie) {
        if (cookie) {
            return DateUtils.format((Date)date, (String)((String)DateUtils.FORMAT_RFC_1036.get(0)));
        }
        return DateUtils.format((Date)date, (String)((String)DateUtils.FORMAT_RFC_1123.get(0)));
    }

    public static String formatDimensions(Set<Dimension> dimensions) {
        return DimensionWriter.write(dimensions);
    }

    private static Class<?> getArrayClass(Type genCompType, Type forMessage) throws NegativeArraySizeException, ImplementationException {
        if (genCompType.equals(Byte.TYPE)) {
            return new byte[0].getClass();
        }
        if (genCompType.equals(Short.TYPE)) {
            return new short[0].getClass();
        }
        if (genCompType.equals(Integer.TYPE)) {
            return new int[0].getClass();
        }
        if (genCompType.equals(Long.TYPE)) {
            return new long[0].getClass();
        }
        if (genCompType.equals(Float.TYPE)) {
            return new float[0].getClass();
        }
        if (genCompType.equals(Double.TYPE)) {
            return new double[0].getClass();
        }
        if (genCompType.equals(Character.TYPE)) {
            return new char[0].getClass();
        }
        if (genCompType.equals(Boolean.TYPE)) {
            return new boolean[0].getClass();
        }
        if (genCompType instanceof Class) {
            return Array.newInstance((Class)genCompType, 0).getClass();
        }
        throw new ImplementationException("Sorry, could not handle a " + forMessage.getClass());
    }

    public static String getCharsetName(MultivaluedMap<String, Object> httpHeaders, CharacterSet defaultCs) {
        String result = null;
        CharacterSet charSet = null;
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (contentType == null) {
            charSet = defaultCs;
        } else {
            charSet = ContentType.readCharacterSet((String)contentType.toString());
            if (charSet == null) {
                charSet = defaultCs;
            }
        }
        if (charSet != null) {
            result = charSet.getName();
        }
        return result;
    }

    public static <A> A getFirstElement(Collection<A> coll) throws NoSuchElementException {
        if (coll.isEmpty()) {
            throw new NoSuchElementException("The Collection is empty; you can't get the first element of it.");
        }
        if (coll instanceof LinkedList) {
            return (A)((LinkedList)coll).getFirst();
        }
        if (coll instanceof List) {
            return (A)((List)coll).get(0);
        }
        return coll.iterator().next();
    }

    public static <A> A getFirstElement(Iterable<A> coll) throws NoSuchElementException {
        if (coll instanceof LinkedList) {
            return (A)((LinkedList)coll).getFirst();
        }
        if (coll instanceof List) {
            return (A)((List)coll).get(0);
        }
        return coll.iterator().next();
    }

    public static <A> A getFirstElement(List<A> list) throws IndexOutOfBoundsException {
        if (list.isEmpty()) {
            throw new IndexOutOfBoundsException("The Collection is empty; you can't get the first element of it.");
        }
        if (list instanceof LinkedList) {
            return (A)((LinkedList)list).getFirst();
        }
        return list.get(0);
    }

    public static <A> A getFirstElementOrNull(Iterable<A> coll) {
        if (coll instanceof LinkedList) {
            LinkedList linkedList = (LinkedList)coll;
            if (linkedList.isEmpty()) {
                return null;
            }
            return (A)linkedList.getFirst();
        }
        if (coll instanceof List) {
            List list = (List)coll;
            if (list.isEmpty()) {
                return null;
            }
            return (A)list.get(0);
        }
        if (coll instanceof Collection && ((Collection)coll).isEmpty()) {
            return null;
        }
        return coll.iterator().next();
    }

    public static <K, V> Map.Entry<K, V> getFirstEntry(Map<K, V> map) throws NoSuchElementException {
        return map.entrySet().iterator().next();
    }

    public static <K, V> K getFirstKey(Map<K, V> map) throws NoSuchElementException {
        return map.keySet().iterator().next();
    }

    public static <K, V> V getFirstValue(Map<K, V> map) throws NoSuchElementException {
        return map.values().iterator().next();
    }

    public static Class<?> getGenericClass(Class<?> clazz, Class<?> implInterface) {
        if (clazz == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (implInterface == null) {
            throw new IllegalArgumentException("The interface to b eimplemented must not be null");
        }
        return Util.getGenericClass(clazz, implInterface, null);
    }

    private static Class<?> getGenericClass(Class<?> clazz, Class<?> implInterface, Type[] gsatp) {
        for (Type ifGenericType : clazz.getGenericInterfaces()) {
            TypeVariable tv;
            String name;
            Type rawType;
            Type[] atps;
            ParameterizedType pt;
            Type ptRawType;
            if (!(ifGenericType instanceof ParameterizedType) || (ptRawType = (pt = (ParameterizedType)ifGenericType).getRawType()) == null || !ptRawType.equals(implInterface) || (atps = pt.getActualTypeArguments()) == null || atps.length == 0) continue;
            Type atp = atps[0];
            if (atp instanceof Class) {
                return (Class)atp;
            }
            if (atp instanceof ParameterizedType && (rawType = ((ParameterizedType)atp).getRawType()) instanceof Class) {
                return (Class)rawType;
            }
            if (!(atp instanceof TypeVariable) || (name = (tv = (TypeVariable)atp).getName()) == null) continue;
            for (int i = 0; i < atps.length; ++i) {
                TypeVariable tv2 = (TypeVariable)atps[i];
                String tv2Name = tv2.getName();
                if (tv2Name == null || !tv2Name.equals(name)) continue;
                Type gsatpn = gsatp[i];
                if (gsatpn instanceof Class) {
                    return (Class)gsatpn;
                }
                if (gsatpn instanceof ParameterizedType) {
                    Type rawType2 = ((ParameterizedType)gsatpn).getRawType();
                    if (rawType2 instanceof Class) {
                        return (Class)rawType2;
                    }
                    throw new ImplementationException("Sorry, don't know how to return the class here");
                }
                if (!(gsatpn instanceof GenericArrayType)) continue;
                Type genCompType = ((GenericArrayType)gsatpn).getGenericComponentType();
                return Util.getArrayClass(genCompType, gsatpn);
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        Type genericSuperClass = clazz.getGenericSuperclass();
        if (genericSuperClass instanceof Class && !implInterface.isAssignableFrom((Class)genericSuperClass)) {
            return null;
        }
        if (gsatp == null && genericSuperClass instanceof ParameterizedType) {
            gsatp = ((ParameterizedType)genericSuperClass).getActualTypeArguments();
        }
        if (superClass != null) {
            return Util.getGenericClass(superClass, implInterface, gsatp);
        }
        return null;
    }

    public static Class<?> getGenericClass(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            return null;
        }
        Type atp = actualTypeArguments[0];
        if (atp instanceof Class) {
            return (Class)atp;
        }
        if (atp instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)atp).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            return null;
        }
        return null;
    }

    public static Series<Header> getHttpHeaders(Request request) {
        Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            request.getAttributes().put("org.restlet.http.headers", headers);
        }
        return headers;
    }

    public static Series<Header> getHttpHeaders(Response response) {
        Series headers = (Series)response.getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            response.getAttributes().put("org.restlet.http.headers", headers);
        }
        return headers;
    }

    public static MultivaluedMap<String, String> getJaxRsHttpHeaders(Request request) {
        ConcurrentMap attrsOfRequ = request.getAttributes();
        UnmodifiableMultivaluedMap<String, String> headers = (UnmodifiableMultivaluedMap<String, String>)attrsOfRequ.get(ORG_RESTLET_EXT_JAXRS_HTTP_HEADERS);
        if (headers == null) {
            headers = UnmodifiableMultivaluedMap.getFromSeries(Util.getHttpHeaders(request), false);
            attrsOfRequ.put(ORG_RESTLET_EXT_JAXRS_HTTP_HEADERS, headers);
        }
        return headers;
    }

    public static <A> A getLastElement(Iterable<A> iterable) throws IndexOutOfBoundsException, NoSuchElementException {
        if (iterable instanceof LinkedList) {
            return (A)((LinkedList)iterable).getLast();
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            return (A)list.get(list.size() - 1);
        }
        return Util.getLastElement(iterable.iterator());
    }

    public static <A> A getLastElement(Iterator<A> iter) throws NoSuchElementException {
        A e = iter.next();
        while (iter.hasNext()) {
            e = iter.next();
        }
        return e;
    }

    public static <A> A getLastElement(List<A> list) throws IndexOutOfBoundsException {
        if (list instanceof LinkedList) {
            return (A)((LinkedList)list).getLast();
        }
        return list.get(list.size() - 1);
    }

    public static <A> A getLastElementOrNull(Iterable<A> iterable) {
        if (iterable instanceof LinkedList) {
            LinkedList linkedList = (LinkedList)iterable;
            if (linkedList.isEmpty()) {
                return null;
            }
            return (A)linkedList.getLast();
        }
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                return null;
            }
            return (A)list.get(list.size() - 1);
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return null;
        }
        return Util.getLastElementOrNull(iterable.iterator());
    }

    public static <A> A getLastElementOrNull(Iterator<A> iter) {
        A e = null;
        while (iter.hasNext()) {
            e = iter.next();
        }
        return e;
    }

    public static MediaType getMediaType(MultivaluedMap<String, Object> httpHeaders) {
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (contentType == null) {
            return null;
        }
        if (contentType instanceof MediaType) {
            return (MediaType)contentType;
        }
        if (contentType instanceof javax.ws.rs.core.MediaType) {
            return Converter.toRestletMediaType((javax.ws.rs.core.MediaType)contentType);
        }
        return ContentType.readMediaType((String)contentType.toString());
    }

    public static Collection<Method> getMethodsByName(Class<?> clazz, String methodName) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        ArrayList<Method> methods = new ArrayList<Method>(2);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static <A> A getOnlyElement(Collection<A> list) throws IllegalArgumentException {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("The list must have exactly one element");
        }
        if (list instanceof List) {
            return (A)((List)list).get(0);
        }
        return list.iterator().next();
    }

    public static String getOnlyMetadataName(List<? extends Metadata> metadatas) {
        Metadata metadata = Util.getOnlyElement(metadatas);
        if (metadata == null) {
            return null;
        }
        return metadata.getName();
    }

    public static Path getPathAnnotation(Class<?> jaxRsClass) throws MissingAnnotationException, IllegalArgumentException {
        if (jaxRsClass == null) {
            throw new IllegalArgumentException("The jaxRsClass must not be null");
        }
        Path path = jaxRsClass.getAnnotation(Path.class);
        if (path == null) {
            Class<?>[] interfaces = jaxRsClass.getInterfaces();
            for (int i = 0; path == null && i < interfaces.length; ++i) {
                path = interfaces[i].getAnnotation(Path.class);
            }
        }
        if (path == null) {
            throw new MissingAnnotationException("The root resource class does not have a @Path annotation");
        }
        return path;
    }

    public static Path getPathAnnotation(Method method) throws IllegalArgumentException, MissingAnnotationException {
        if (method == null) {
            throw new IllegalArgumentException("The root resource class must not be null");
        }
        Path path = method.getAnnotation(Path.class);
        if (path == null) {
            throw new MissingAnnotationException("The method " + method.getName() + " does not have an annotation @Path");
        }
        return path;
    }

    public static Path getPathAnnotationOrNull(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("The root resource class must not be null");
        }
        return method.getAnnotation(Path.class);
    }

    public static String getPathTemplateWithoutRegExps(Class<?> resource) throws IllegalPathOnClassException, MissingAnnotationException, IllegalArgumentException {
        try {
            return Util.getPathTemplateWithoutRegExps(Util.getPathAnnotation(resource));
        }
        catch (IllegalPathException e) {
            throw new IllegalPathOnClassException(e);
        }
    }

    public static String getPathTemplateWithoutRegExps(Method method) throws IllegalArgumentException, IllegalPathOnMethodException, MissingAnnotationException {
        Path path = Util.getPathAnnotation(method);
        try {
            return Util.getPathTemplateWithoutRegExps(path);
        }
        catch (IllegalPathException e) {
            throw new IllegalPathOnMethodException(e);
        }
    }

    public static String getPathTemplateWithoutRegExps(Path path) throws IllegalPathException {
        return Util.getPathTemplateWithoutRegExps(path.value(), path);
    }

    public static String getPathTemplateWithoutRegExps(String pathTemplate, Path pathForExcMess) throws IllegalPathException {
        StringBuilder stb = new StringBuilder();
        int l = pathTemplate.length();
        for (int i = 0; i < l; ++i) {
            char c = pathTemplate.charAt(i);
            if (c == '{') {
                i = Util.processTemplVarname(pathTemplate, i, stb, pathForExcMess);
                continue;
            }
            if (c == '%') {
                try {
                    EncodeOrCheck.processPercent(i, true, pathTemplate, stb);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalPathException(pathForExcMess, e);
                }
            }
            if (c == '}') {
                throw new IllegalPathException(pathForExcMess, "'}' is only allowed as end of a variable name in \"" + pathTemplate + "\"");
            }
            if (c == ';') {
                throw new IllegalPathException(pathForExcMess, "A semicolon is not allowed in a path");
            }
            if (c == '/') {
                stb.append(c);
                continue;
            }
            EncodeOrCheck.encode(c, stb);
        }
        return stb.toString();
    }

    public static CharacterSet getSupportedCharSet(CharacterSet characterSet) {
        if (characterSet == null) {
            return JAX_RS_DEFAULT_CHARACTER_SET;
        }
        if (Charset.isSupported(characterSet.toString())) {
            return characterSet;
        }
        return Util.logUnsupportedCharSet(characterSet.toString());
    }

    public static CharacterSet getSupportedCharSet(MultivaluedMap<String, Object> httpResponseHeaders) {
        String csn = Util.getCharsetName(httpResponseHeaders, JAX_RS_DEFAULT_CHARACTER_SET);
        if (Charset.isSupported(csn)) {
            return CharacterSet.valueOf((String)csn);
        }
        return Util.logUnsupportedCharSet(csn);
    }

    public static int indexBeginMatrixOfLastSegment(CharSequence path) {
        String pathStr = ((Object)path).toString();
        return pathStr.indexOf(59, pathStr.lastIndexOf(47));
    }

    public static int indexOfBetween(CharSequence charSequence, char c, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            char csc = charSequence.charAt(i);
            if (csc != c) continue;
            return i;
        }
        return -1;
    }

    public static void inject(Object resource, AccessibleObject fieldOrBeanSetter, Object toInject) throws InvocationTargetException, IllegalArgumentException, InjectException {
        if (fieldOrBeanSetter instanceof Field) {
            Util.inject(resource, (Field)fieldOrBeanSetter, toInject);
        } else if (fieldOrBeanSetter instanceof Method) {
            Util.inject(resource, (Method)fieldOrBeanSetter, toInject);
        } else {
            throw new IllegalArgumentException("The fieldOrBeanSetter must be a java.lang.reflect.Field or a java.lang.reflect.Method");
        }
    }

    public static void inject(final Object resource, final Field field, final Object toInject) throws InjectException {
        try {
            IllegalAccessException iae = AccessController.doPrivileged(new PrivilegedAction<IllegalAccessException>(){

                @Override
                public IllegalAccessException run() {
                    try {
                        field.set(resource, toInject);
                        return null;
                    }
                    catch (IllegalAccessException e) {
                        return e;
                    }
                }
            });
            if (iae != null) {
                throw new InjectException("Could not inject the " + toInject.getClass() + " into field " + field + " of object " + resource, iae);
            }
        }
        catch (RuntimeException e) {
            throw new InjectException("Could not inject the " + toInject.getClass() + " into field " + field + " of object " + resource, e);
        }
    }

    public static void inject(Object resource, Method beanSetter, Object toInject) throws InvocationTargetException, IllegalArgumentException, InjectException {
        try {
            Util.invokeMethod(resource, beanSetter, toInject);
        }
        catch (MethodInvokeException mie) {
            throw new InjectException(mie);
        }
    }

    public static void invokeMethod(final Object object, final Method javaMethod, final Object ... args) throws MethodInvokeException, InvocationTargetException, IllegalArgumentException {
        if (javaMethod == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    javaMethod.invoke(object, args);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalAccessException) {
                throw new MethodInvokeException("Not allowed to invoke post construct method " + javaMethod, cause);
            }
            if (cause instanceof InvocationTargetException) {
                throw (InvocationTargetException)cause;
            }
            if (cause instanceof ExceptionInInitializerError) {
                throw new MethodInvokeException("Could not invoke post construct method " + javaMethod, cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new JaxRsRuntimeException("Error while invoking post construct method " + javaMethod, cause);
        }
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmptyOrSlash(String string) {
        return string == null || string.length() == 0 || string.equals("/");
    }

    public static boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    public static boolean isProvider(Class<?> jaxRsClass) {
        return Util.checkClassAndInterfacesForAnnotation(jaxRsClass, Provider.class);
    }

    public static boolean isRootResourceClass(Class<?> jaxRsClass) {
        return Util.checkClassAndInterfacesForAnnotation(jaxRsClass, Path.class);
    }

    private static CharacterSet logUnsupportedCharSet(String charsetName) {
        Context.getCurrentLogger().warning("The character set " + charsetName + " is not " + "available. Will use " + JAX_RS_DEFAULT_CHARACTER_SET_AS_STRING);
        return JAX_RS_DEFAULT_CHARACTER_SET;
    }

    public static boolean notEndsWith(CharSequence charSequence, char character) {
        if (charSequence == null) {
            return true;
        }
        if (charSequence.length() == 0) {
            return true;
        }
        return charSequence.charAt(charSequence.length() - 1) != character;
    }

    public static boolean notStartsWith(CharSequence charSequence, char character) {
        if (charSequence == null) {
            return true;
        }
        if (charSequence.length() == 0) {
            return true;
        }
        return charSequence.charAt(0) != character;
    }

    private static int processTemplVarname(String pathTemplate, int braceIndex, StringBuilder stb, Path pathForExcMess) throws IllegalPathException {
        int l = pathTemplate.length();
        stb.append('{');
        int state = 1;
        for (int i = braceIndex + 1; i < l; ++i) {
            char c = pathTemplate.charAt(i);
            if (c == '{') {
                throw new IllegalPathException(pathForExcMess, "A variable must not contain an extra '{' in \"" + pathTemplate + "\"");
            }
            if (c == ' ' || c == '\t') {
                if (state != 2) continue;
                state = 3;
                continue;
            }
            if (c == ':') {
                if (state == 1) {
                    throw new IllegalPathException(pathForExcMess, "The variable name at position must not be null at " + braceIndex + " of \"" + pathTemplate + "\"");
                }
                if (state == 2 || state == 3) {
                    for (int j = i; j < l; ++j) {
                        if (pathTemplate.charAt(j) != '}') continue;
                        stb.append('}');
                        return j;
                    }
                    throw new IllegalPathException(pathForExcMess, "No '}' found after '{' at position " + braceIndex + " of \"" + pathTemplate + "\"");
                }
            } else if (c == '}') {
                if (state == 1) {
                    throw new IllegalPathException(pathForExcMess, "The template variable name '{}' is not allowed in \"" + pathTemplate + "\"");
                }
                stb.append('}');
                return i;
            }
            if (state == 1) {
                state = 2;
                stb.append(c);
                continue;
            }
            if (state == 2) {
                stb.append(c);
                continue;
            }
            throw new IllegalPathException(pathForExcMess, "Invalid character found at position " + i + " of \"" + pathTemplate + "\"");
        }
        throw new IllegalPathException(pathForExcMess, "No '}' found after '{' at position " + braceIndex + " of \"" + pathTemplate + "\"");
    }

    public static List<MediaType> sortByConcreteness(Collection<MediaType> mediaTypes) {
        ArrayList<MediaType> newList = new ArrayList<MediaType>(mediaTypes.size());
        for (MediaType mediaType : mediaTypes) {
            if (Util.specificness(mediaType) <= 0) continue;
            newList.add(mediaType);
        }
        for (MediaType mediaType : mediaTypes) {
            if (Util.specificness(mediaType) != 0) continue;
            newList.add(mediaType);
        }
        for (MediaType mediaType : mediaTypes) {
            if (Util.specificness(mediaType) >= 0) continue;
            newList.add(mediaType);
        }
        return newList;
    }

    public static int specificness(MediaType mediaType) {
        if (mediaType.equals((Object)MediaType.ALL, true)) {
            return -1;
        }
        if (mediaType.getSubType().equals("*")) {
            return 0;
        }
        return 1;
    }

    public static boolean startsWith(CharSequence charSequence, char character) {
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) {
            return false;
        }
        return charSequence.charAt(0) == character;
    }

    public static Object[] toArray(Collection<?> coll, Class<?> arrayType) {
        int collSize = coll.size();
        Object[] array = (Object[])Array.newInstance(arrayType, collSize);
        return coll.toArray(array);
    }

    public static String toString(Collection<?> collection, String delimiter) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        Iterator<?> iterator = collection.iterator();
        if (collection.size() == 1) {
            return String.valueOf(iterator.next());
        }
        StringBuilder stb = new StringBuilder();
        stb.append(iterator.next());
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stb.append(delimiter);
            stb.append(object);
        }
        return stb.toString();
    }
}

