/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.basic;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.InputByteStream;
import java.util.HashMap;

public class CommHeader {
    private static final int COMM_HEADER_SIZE = 18;
    private static final int COMM_HEADER_DEFAULT_TYPE = 2;
    private int HeaderType = 2;
    private int SeqNum = 0;
    private int PackCount = 0;
    private int CommandId = 0;
    private int DestAddr = 0;
    private int PackLen = 0;
    private int ActionCode = 0;
    private int ErrorCode = 0;
    private int HostIP = 0;
    private int HostPort = 0;
    private long transaction_id = -1L;
    private int ExpectedSeqNumber = 0;

    public CommHeader() {
    }

    public CommHeader(byte[] byArray) {
        this.parse(byArray);
    }

    public boolean parse(byte[] byArray) {
        this.HeaderType = -1;
        if (byArray.length >= CommHeader.getHeaderSize()) {
            InputByteStream inputByteStream = new InputByteStream(byArray);
            this.HeaderType = inputByteStream.get8bit();
            this.SeqNum = inputByteStream.get8bit();
            this.PackCount = inputByteStream.get8bit();
            this.CommandId = inputByteStream.get8bit();
            this.ActionCode = inputByteStream.get8bit();
            this.DestAddr = (int)inputByteStream.get32bit();
            this.PackLen = inputByteStream.get16bit();
            this.ErrorCode = inputByteStream.get8bit();
            this.HostIP = (int)inputByteStream.get32bit();
            this.HostPort = inputByteStream.get16bit();
            this.ExpectedSeqNumber = WizePanelExceptions.getHardwareErrorCodesNameByNum((int)this.ErrorCode) == WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_WRONG_PACKET_NUMBER && byArray.length >= CommHeader.getHeaderSize() + 1 ? byArray[18] & 0xFF : this.SeqNum;
            this.transaction_id = this.HostIP;
            return true;
        }
        return false;
    }

    public static int getHeaderSize() {
        return 18;
    }

    public void buildHeader(byte[] byArray) {
        byArray[0] = (byte)(this.HeaderType & 0xFF);
        byArray[1] = (byte)(this.SeqNum & 0xFF);
        byArray[2] = (byte)(this.PackCount & 0xFF);
        byArray[3] = (byte)(this.CommandId & 0xFF);
        byArray[4] = (byte)(this.ActionCode & 0xFF);
        byArray[5] = (byte)(this.DestAddr & 0xFF);
        byArray[6] = (byte)(this.DestAddr >> 8 & 0xFF);
        byArray[7] = (byte)(this.DestAddr >> 16 & 0xFF);
        byArray[8] = (byte)(this.DestAddr >> 24 & 0xFF);
        byArray[9] = (byte)(this.PackLen & 0xFF);
        byArray[10] = (byte)(this.PackLen >> 8 & 0xFF);
        byArray[11] = (byte)(this.ErrorCode & 0xFF);
        if (this.transaction_id != -1L) {
            byArray[12] = (byte)(this.transaction_id >> 0 & 0xFFL);
            byArray[13] = (byte)(this.transaction_id >> 8 & 0xFFL);
            byArray[14] = (byte)(this.transaction_id >> 16 & 0xFFL);
            byArray[15] = (byte)(this.transaction_id >> 24 & 0xFFL);
        }
        byArray[16] = (byte)(this.HostPort >> 0 & 0xFF);
        byArray[17] = (byte)(this.HostPort >> 8 & 0xFF);
    }

    public String toString() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("HeaderType", this.HeaderType);
        hashMap.put("SeqNum", this.SeqNum);
        hashMap.put("PackCount", this.PackCount);
        hashMap.put("CommandId", this.CommandId);
        hashMap.put("ActionCode", this.ActionCode);
        hashMap.put("DestAddr", String.format("%h", this.DestAddr));
        hashMap.put("PackLen", this.PackLen);
        hashMap.put("ErrorCode", this.ErrorCode);
        hashMap.put("HostIP", String.format("%h", this.HostIP));
        hashMap.put("HostPort", this.HostPort);
        return PrettyPrinter.block(hashMap);
    }

    public int getCommandId() {
        return this.CommandId;
    }

    public CommHeader setCommandId(int n) {
        this.CommandId = n;
        return this;
    }

    public int getDestAddr() {
        return this.DestAddr;
    }

    public CommHeader setDestAddr(int n) {
        this.DestAddr = n;
        return this;
    }

    public int getPackCount() {
        return this.PackCount;
    }

    public CommHeader setPackCount(int n) {
        this.PackCount = n;
        return this;
    }

    public int getPackLen() {
        return this.PackLen;
    }

    public CommHeader setPackLen(int n) {
        this.PackLen = n;
        return this;
    }

    public int getSeqNum() {
        return this.SeqNum;
    }

    public int getExpectedSeqNumber() {
        return this.ExpectedSeqNumber;
    }

    public CommHeader setSeqNum(int n) {
        this.SeqNum = n;
        return this;
    }

    public int getActionCode() {
        return this.ActionCode;
    }

    public CommHeader setActionCode(int n) {
        this.ActionCode = n;
        return this;
    }

    public int getErrorCode() {
        return this.ErrorCode;
    }

    public CommHeader setErrorCode(int n) {
        this.ErrorCode = n;
        return this;
    }

    public int getHeaderType() {
        return this.HeaderType;
    }

    public CommHeader setHeaderType(int n) {
        this.HeaderType = n;
        return this;
    }

    public int getHostIP() {
        return this.HostIP;
    }

    public CommHeader setHostIP(int n) {
        this.HostIP = n;
        this.transaction_id = n;
        return this;
    }

    public CommHeader setTransactionID(long l) {
        this.HostIP = (int)l;
        this.transaction_id = l;
        return this;
    }

    public long getTransactionId() {
        return this.transaction_id;
    }

    public String getFormattedTransactionId() {
        if (this.transaction_id == -1L) {
            return "";
        }
        return "Transaction ID: " + String.format("0x%08x", this.transaction_id) + "\n";
    }

    public int getHostPort() {
        return this.HostPort;
    }

    public CommHeader setHostPort(int n) {
        this.HostPort = n;
        return this;
    }

    public boolean isValid() {
        return this.HeaderType == 2;
    }
}

