/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.basic;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommHeader;

public class CommPacket {
    private static final int ID = 81;
    private byte[] raw_bytes = null;
    private CommHeader command_header = null;
    private byte[] command_payload = null;
    private boolean is_valid = false;
    private long crc = 0L;

    public CommPacket() {
    }

    public CommPacket(byte[] byArray) {
        this.is_valid = true;
        this.command_header = null;
        this.command_payload = null;
        this.crc = this.calc_crc(0, byArray, byArray.length);
        this.raw_bytes = new byte[3 + byArray.length + 2];
        this.raw_bytes[0] = 81;
        this.raw_bytes[1] = (byte)(byArray.length & 0xFF);
        this.raw_bytes[2] = (byte)(byArray.length >> 8 & 0xFF);
        System.arraycopy(byArray, 0, this.raw_bytes, 3, byArray.length);
        this.update();
    }

    public CommPacket createAck(byte[] byArray) {
        CommHeader commHeader = this.commandHeader();
        if (commHeader == null) {
            return null;
        }
        byte[] byArray2 = new byte[CommHeader.getHeaderSize() + (byArray == null ? 0 : byArray.length)];
        commHeader.buildHeader(byArray2);
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, CommHeader.getHeaderSize(), byArray.length);
        }
        return new CommPacket(byArray2);
    }

    public boolean parse(byte[] byArray, int n) throws WizePanelExceptions {
        this.is_valid = false;
        if (byArray == null || n < 5) {
            return false;
        }
        if ((byArray[0] & 0xFF) != 81) {
            return false;
        }
        int n2 = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
        if (n2 + 5 > n) {
            return false;
        }
        int n3 = n2 + 5;
        this.crc = byArray[n3 - 2] & 0xFF | (byArray[n3 - 1] & 0xFF) << 8;
        if (this.calc_crc(3, byArray, n2) != this.crc) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_WRONG_CRC);
        }
        this.raw_bytes = new byte[n3];
        System.arraycopy(byArray, 0, this.raw_bytes, 0, n3);
        this.is_valid = true;
        this.command_header = null;
        this.command_payload = null;
        return this.is_valid;
    }

    public boolean isValid() {
        return this.is_valid;
    }

    public int length() {
        return this.raw_bytes.length;
    }

    public byte[] raw() {
        return this.raw_bytes;
    }

    public CommHeader commandHeader() {
        if (this.is_valid) {
            if (this.command_header == null && this.raw_bytes.length - 5 >= CommHeader.getHeaderSize()) {
                byte[] byArray = new byte[CommHeader.getHeaderSize()];
                System.arraycopy(this.raw_bytes, 3, byArray, 0, byArray.length);
                this.command_header = new CommHeader();
                this.command_header.parse(byArray);
            }
            return this.command_header;
        }
        return null;
    }

    public byte[] commandPayload() {
        if (this.is_valid) {
            if (this.command_payload == null) {
                this.command_payload = new byte[this.raw_bytes.length - 5 - CommHeader.getHeaderSize()];
                System.arraycopy(this.raw_bytes, 3 + CommHeader.getHeaderSize(), this.command_payload, 0, this.command_payload.length);
            }
            return this.command_payload;
        }
        return null;
    }

    public String toHex() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HEX:");
        for (int i = 0; i < this.raw_bytes.length; ++i) {
            stringBuilder.append(String.format("%02x", this.raw_bytes[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    private long calc_crc(int n, byte[] byArray, int n2) {
        long l = 133L;
        int n3 = 6;
        long l2 = 0L;
        for (int i = n; i < n2 + n; ++i) {
            short s = (short)(byArray[i] & 0xFF);
            l2 += (long)s * l;
            l = l + (long)n3 & 0xFFFFFFFFFFFFFFFFL;
        }
        return l2 & 0xFFFFL ^ 0xAC5BL;
    }

    public void update() {
        this.raw_bytes[this.raw_bytes.length - 2] = (byte)(this.crc & 0xFFL);
        this.raw_bytes[this.raw_bytes.length - 1] = (byte)(this.crc >> 8 & 0xFFL);
    }

    public long crc() {
        return this.crc;
    }
}

