/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommBaseDispVerRetriever;
import de.wilke.wizepanel.prot.basic.CommCommandDescr;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.basic.ICommDispVerRetriever;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public abstract class ACommCommand {
    public static final String COMMAND_RESULT_LIST_ENTRY_SEP = ":";
    public static final String COMMAND_RESULT_LIST_SEP = "\n";
    private CommHeader responseHeader;
    protected final CommCommandDescr commandDescr;
    private ICommDispVerRetriever dispVersionRetriever = null;
    private final int id;
    private boolean admin_command = false;
    private boolean is_udp_allowed = false;
    private boolean require_ip_and_port = true;
    public PrintStream out = null;
    private int repeat_packet_on_error = 4;
    private int read_timeout = 5000;
    public static final int PACKET_PAYLOAD_SIZE = Integer.parseInt(System.getProperty("PACKET_PAYLOAD_SIZE", "5000"));

    public ACommCommand(int n, String string, String string2, String string3) {
        this.id = n;
        this.dispVersionRetriever = null;
        this.commandDescr = new CommCommandDescr(string, string2, string3);
    }

    public abstract ACommCommand initializeCommandParams() throws WizePanelExceptions;

    public abstract void prepareCommandHeader(CommHeader var1);

    public abstract void prepareCommandParams(byte[] var1, int var2) throws WizePanelExceptions;

    public int getCommandParamsSize() {
        return 0;
    }

    public final void parseResponse(CommHeader commHeader, byte[] byArray) throws WizePanelExceptions {
        this.responseHeader = commHeader;
        this.parseResponse(byArray);
    }

    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
    }

    public boolean beforeExecute(String string, int n) throws WizePanelExceptions {
        return true;
    }

    public boolean beforeExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return true;
    }

    public boolean afterExecute(String string, int n) throws WizePanelExceptions {
        return true;
    }

    public boolean afterExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return true;
    }

    public boolean hasResponse() {
        return true;
    }

    public boolean mustForceTcpWindowCorrection() {
        return false;
    }

    public abstract String getResults();

    public String getCompactResults() {
        return this.getResults();
    }

    public String getCommandConfiguration() {
        return "";
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.commandDescr.getName();
    }

    public CommHeader getResponseHeader() {
        return this.responseHeader;
    }

    public String getCommandName() {
        return this.commandDescr.getName();
    }

    public String getDescription() {
        return this.commandDescr.getDesc();
    }

    public String getHelp() {
        return this.commandDescr.getHelp();
    }

    public List<CommCommandParams> getParamList() {
        return this.commandDescr.getParamList();
    }

    public void setNamedParamValue(String string, int n) {
        CommCommandParams commCommandParams = this.getNamedParam(string);
        if (commCommandParams != null) {
            commCommandParams.setValue(n);
        }
    }

    public void setNamedParamValue(String string, String string2) {
        CommCommandParams commCommandParams = this.getNamedParam(string);
        if (commCommandParams != null) {
            commCommandParams.setValue(string2);
        }
    }

    public void setNamedParamValue(String string, boolean bl) {
        CommCommandParams commCommandParams = this.getNamedParam(string);
        if (commCommandParams != null) {
            commCommandParams.setValue(bl);
        }
    }

    public CommCommandParams.CommCommandParamValue getNamedParamValue(String string) {
        CommCommandParams commCommandParams = this.getNamedParam(string);
        if (commCommandParams != null && commCommandParams.isSet()) {
            return commCommandParams.getValue();
        }
        return null;
    }

    private CommCommandParams getNamedParam(String string) {
        List<CommCommandParams> list = this.commandDescr.getParamList();
        if (list != null) {
            for (CommCommandParams commCommandParams : list) {
                if (!string.equals(commCommandParams.getName())) continue;
                return commCommandParams;
            }
        }
        return null;
    }

    public ACommCommand setDispVersionRetriever(ICommDispVerRetriever iCommDispVerRetriever) {
        this.dispVersionRetriever = iCommDispVerRetriever;
        return this;
    }

    public ICommDispVerRetriever getDispVersionRetriever() {
        if (null == this.dispVersionRetriever) {
            this.dispVersionRetriever = new CommBaseDispVerRetriever("1.07");
        }
        return this.dispVersionRetriever;
    }

    public int getFirstSequenceNumber() {
        return 1;
    }

    protected void setAdminCommand(boolean bl) {
        this.admin_command = bl;
    }

    public boolean isAdminCommand() {
        return this.admin_command;
    }

    protected void setUDPAllowed(boolean bl) {
        this.is_udp_allowed = bl;
    }

    public boolean isUDPAllowed() {
        return this.is_udp_allowed;
    }

    protected void setRequireIpAndPort(boolean bl) {
        this.require_ip_and_port = bl;
    }

    public boolean requireIpAndPort() {
        return this.require_ip_and_port;
    }

    public int preferredPayloadPacketSize(boolean bl) {
        return PACKET_PAYLOAD_SIZE;
    }

    public final int readTimeout() {
        return this.read_timeout;
    }

    public final void setReadTimeout(int n) {
        this.read_timeout = n;
    }

    public final List<CommPacket> buildPackets(boolean bl) throws WizePanelExceptions {
        int n = this.preferredPayloadPacketSize(bl);
        CommHeader commHeader = new CommHeader();
        this.prepareCommandHeader(commHeader);
        int n2 = this.getNumberOfPackets(this.getCommandParamsSize(), n);
        if (n2 > 255) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_TOO_MANY_PACKETS, String.valueOf(n2));
        }
        byte[] byArray = new byte[this.getCommandParamsSize()];
        this.prepareCommandParams(byArray, 0);
        LinkedList<CommPacket> linkedList = new LinkedList<CommPacket>();
        int n3 = this.getCommandParamsSize();
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 > n ? n : n3;
            byte[] byArray2 = new byte[CommHeader.getHeaderSize() + n4];
            commHeader.setSeqNum(i + this.getFirstSequenceNumber());
            commHeader.setPackCount(this.getFirstSequenceNumber() == 0 ? 4 : n2);
            commHeader.setPackLen(n4);
            commHeader.buildHeader(byArray2);
            System.arraycopy(byArray, i * n, byArray2, CommHeader.getHeaderSize(), n4);
            linkedList.add(new CommPacket(byArray2));
            n3 -= n;
        }
        return linkedList;
    }

    public final void importPackets(List<CommPacket> list) {
        int n = 0;
        for (CommPacket commPacket : list) {
            n += commPacket.commandHeader().getPackLen();
        }
        Object object = new byte[n];
        int n2 = 0;
        for (CommPacket commPacket : list) {
            System.arraycopy(commPacket.commandPayload(), 0, object, n2, commPacket.commandHeader().getPackLen());
            n2 += commPacket.commandHeader().getPackLen();
        }
        this.importPayload((byte[])object);
    }

    protected void importPayload(byte[] byArray) {
    }

    protected int getNumberOfPackets(int n, int n2) {
        if (n != 0 && n % n2 == 0) {
            return n / n2;
        }
        return n / n2 + 1;
    }

    public final int repeatPacket() {
        return this.repeat_packet_on_error;
    }

    public final void setRepeatPacket(int n) {
        this.repeat_packet_on_error = n;
    }
}

