/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.types.ErrorEntry;
import java.util.LinkedList;
import java.util.List;

public class CommCmDispGetErrors
extends ACommCommand {
    private static final int COMMAND_ID = 64;
    private static final String COMMAND_NAME = "disp-errors";
    private static final String COMMAND_DESC = "Get dispatcher errors - version 2.0+";
    private static final String COMMAND_HELP = "--command disp-errors --ip 192.168.1.209 --port 8000";
    private final List<ErrorEntry> errors = new LinkedList<ErrorEntry>();
    private static final String PARAM_CLEANUP = "cleanup";
    private static final int ACTION_CODE_READ_CLEANUP = 0;
    private static final int ACTION_CODE_DO_CLEANUP = 255;
    private int action_code = 0;

    public CommCmDispGetErrors() {
        super(64, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_CLEANUP, CommCommandParams.Types.BOOLEAN, PARAM_CLEANUP, "Do cleanup", false);
        this.setReadTimeout(30000);
    }

    @Override
    public ACommCommand initializeCommandParams() {
        this.errors.clear();
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_CLEANUP);
        if (commCommandParamValue != null) {
            this.action_code = commCommandParamValue.getBooleanParam() ? 255 : 0;
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(64).setActionCode(this.action_code).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        try {
            InputByteStream inputByteStream = new InputByteStream(byArray);
            while (inputByteStream.bytesAvailable() > 0) {
                short s = inputByteStream.get8bit();
                short s2 = inputByteStream.get8bit();
                long l = inputByteStream.get32bit();
                short s3 = inputByteStream.get8bit();
                String string = inputByteStream.getString(s - 7);
                this.errors.add(new ErrorEntry(s2, l, s3, string));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.errors.clear();
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.action_code == 255) {
            stringBuilder.append("Error log cleared.");
        } else {
            stringBuilder.append("Errors: ").append(this.errors.size()).append("\n\n");
            if (this.errors.size() != 0) {
                stringBuilder.append("Task\tTime\tLevel\tMessage\n");
                for (ErrorEntry errorEntry : this.errors) {
                    stringBuilder.append(String.format("%d\t", errorEntry.getTaskNr()));
                    stringBuilder.append(String.format("%d\t", errorEntry.getRuntimeSecs()));
                    stringBuilder.append(String.format("%d\t", errorEntry.getLevel()));
                    stringBuilder.append(errorEntry.getMsg());
                    stringBuilder.append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    public List<ErrorEntry> getErrors() {
        return this.errors;
    }

    public void doCleanup(boolean bl) {
        this.action_code = bl ? 255 : 0;
    }

    @Override
    public String getCommandConfiguration() {
        return this.action_code == 255 ? PARAM_CLEANUP : "";
    }
}

