/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.WpNumberUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.types.TransactionStatus;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;

public class CommCmDispGetTransactions
extends ACommCommand {
    private static final int COMMAND_ID = 41;
    public static final String COMMAND_NAME = "trans-list";
    private static final String COMMAND_DESC = "Get status of running commands(s) - version 2.0+";
    private static final String COMMAND_HELP = "--command trans-list --ip 192.168.1.209 --port 8000 [--trans 0x12345678] [--cleanup]\n";
    public static final String PARAM_TRANS_ID = "trans";
    private static final String PARAM_CLEANUP = "cleanup";
    private final Map<Long, TransactionStatus> transactions = new HashMap<Long, TransactionStatus>();
    private final List<Long> request_trans_ids = new LinkedList<Long>();
    private static final int ACTION_CODE_DO_CLEANUP = 255;
    private int action_code = 0;

    public CommCmDispGetTransactions() {
        super(41, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_TRANS_ID, CommCommandParams.Types.STRING, PARAM_TRANS_ID, "List of transaction ID (comma separated)", false);
        this.commandDescr.addParam(PARAM_CLEANUP, CommCommandParams.Types.BOOLEAN, PARAM_CLEANUP, "Do cleanup", false);
        this.setReadTimeout(30000);
    }

    @Override
    public ACommCommand initializeCommandParams() {
        String[] stringArray;
        this.transactions.clear();
        this.request_trans_ids.clear();
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_TRANS_ID);
        if (commCommandParamValue != null && !commCommandParamValue.getStringParam().isEmpty() && (stringArray = commCommandParamValue.getStringParam().split(",")) != null && stringArray.length != 0) {
            for (String string : stringArray) {
                try {
                    this.request_trans_ids.add(WpNumberUtils.str2long(string));
                }
                catch (NumberFormatException numberFormatException) {
                    LogManager.getLogger(CommCmDispGetTransactions.class).error("BadFormat: {}", (Object)string);
                }
            }
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_CLEANUP)) != null) {
            this.action_code = commCommandParamValue.getBooleanParam() ? 255 : 0;
        }
        return this;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(41).setActionCode(this.action_code).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public int getCommandParamsSize() {
        if (this.request_trans_ids == null) {
            return 0;
        }
        return this.request_trans_ids.size() * 4;
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        if (this.getCommandParamsSize() != 0) {
            OutputByteStream outputByteStream = new OutputByteStream(this.getCommandParamsSize());
            for (long l : this.request_trans_ids) {
                outputByteStream.put32bit(l);
            }
            for (int i = 0; i < outputByteStream.length(); ++i) {
                byArray[n + i] = outputByteStream.getData()[i];
            }
        }
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        this.transactions.clear();
        if (byArray.length % 17 != 0) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
        for (int i = 0; i < byArray.length; i += 17) {
            byte[] byArray2 = new byte[17];
            for (int j = 0; j < 17; ++j) {
                byArray2[j] = byArray[i + j];
            }
            TransactionStatus transactionStatus = new TransactionStatus(byArray2);
            this.transactions.put(transactionStatus.getId(), transactionStatus);
        }
    }

    public Map<Long, TransactionStatus> getTransactions() {
        return this.transactions;
    }

    public void addTransaction(long l, TransactionStatus transactionStatus) {
        this.transactions.put(l, transactionStatus);
    }

    public void setCleanUp() {
        this.action_code = 255;
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.action_code == 255) {
            stringBuilder.append("\nCleaned up.");
        } else {
            if (this.transactions.size() > 0) {
                TreeMap<Long, TransactionStatus> treeMap = new TreeMap<Long, TransactionStatus>(this.transactions);
                for (TransactionStatus transactionStatus : treeMap.values()) {
                    stringBuilder.append(transactionStatus.toStringPretty()).append("\n");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append("\nTransactions: ").append(this.transactions.size()).append("\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCompactResults() {
        if (this.action_code == 255) {
            return "Cleaned up.";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n#Entries: ").append(this.transactions.size()).append("\n\n");
        stringBuilder.append(String.format("%1$-10s", "id"));
        stringBuilder.append(String.format(" | %1$10s", "wpid"));
        stringBuilder.append(String.format(" | %1$13s", "cmd"));
        stringBuilder.append(String.format(" | %1$10s", "action"));
        stringBuilder.append(String.format(" | %1$10s", "retrans"));
        stringBuilder.append(String.format(" | %1$10s", "lifetime"));
        stringBuilder.append(String.format(" | %1$10s", "finished"));
        stringBuilder.append(String.format(" | %1$10s", "error"));
        stringBuilder.append("\n");
        stringBuilder.append("-----------+------------+---------------+------------+------------+------------+------------+------------\n");
        TreeMap<Long, TransactionStatus> treeMap = new TreeMap<Long, TransactionStatus>(this.transactions);
        for (TransactionStatus transactionStatus : treeMap.values()) {
            Object object = "";
            if (transactionStatus.errorCode() != 0) {
                object = " (" + WizePanelExceptions.getHardwareErrorCodesNameByNum((int)transactionStatus.errorCode()) + ")";
            }
            stringBuilder.append(String.format("%1$-10s", transactionStatus.getId()));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.wpid()));
            stringBuilder.append(String.format(" | %1$-13s", transactionStatus.command()));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.actionCode()));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.retransmissions()));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.lifetime()));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.isFinished() ? "Yes" : "No"));
            stringBuilder.append(String.format(" | %1$-10s", transactionStatus.errorCode())).append((String)object);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCommandConfiguration() {
        if (this.action_code == 255) {
            return PARAM_CLEANUP;
        }
        if (this.request_trans_ids.size() != 0) {
            return "[" + WpUtils.implode((String)", ", this.request_trans_ids) + "]";
        }
        return "all";
    }
}

