/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommCmDispGetWizepanelsBase
extends ACommCommand {
    private static final byte RESP_DATA_BLOCK_SIZE = 19;
    private static final byte RESP_DATA_BLOCK_SIZE_EXTENDED = 21;
    private static final String PARAM_EXTENDED = "extended";
    private final List<WizePanelItemType> wizePanelList = new LinkedList<WizePanelItemType>();
    private static final int ACK_EXTENDED = 1;
    private int ack = 0;

    public CommCmDispGetWizepanelsBase(int n, String string, String string2, String string3) {
        super(n, string, string2, string3);
        this.commandDescr.addParam(PARAM_EXTENDED, CommCommandParams.Types.BOOLEAN, PARAM_EXTENDED, "Extended", false);
        this.setReadTimeout(30000);
    }

    public void setExtended(boolean bl) {
        this.ack = bl ? 1 : 0;
    }

    @Override
    public CommCmDispGetWizepanelsBase initializeCommandParams() {
        this.wizePanelList.clear();
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_EXTENDED);
        this.setExtended(commCommandParamValue != null && commCommandParamValue.getBooleanParam());
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return this.wizePanelList.size() * this.minPacketLength();
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(this.getId()).setActionCode(this.ack).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        OutputByteStream outputByteStream = new OutputByteStream(byArray, n);
        for (WizePanelItemType wizePanelItemType : this.wizePanelList) {
            outputByteStream.put32bit((long)wizePanelItemType.getSerialNo());
            outputByteStream.put8bit((short)0);
            outputByteStream.put16bit(wizePanelItemType.params().getGoodTransmissions());
            outputByteStream.put16bit(wizePanelItemType.params().getBadTransmissions());
            outputByteStream.put32bit((long)wizePanelItemType.getLastSeen());
            outputByteStream.put16bit(wizePanelItemType.params().getWakeup() / 60);
            outputByteStream.put16bit(0);
            outputByteStream.put16bit(0);
            if (this.ack != 1) continue;
            outputByteStream.put8bit((short)wizePanelItemType.params().getType());
            outputByteStream.put8bit((short)0);
        }
    }

    private int minPacketLength() {
        return this.ack == 1 ? 21 : 19;
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        if (byArray.length % this.minPacketLength() != 0) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        Date date = new Date();
        for (int i = 0; i < byArray.length; i += this.minPacketLength()) {
            WizePanelItemType wizePanelItemType = new WizePanelItemType();
            wizePanelItemType.setSerialNo((int)inputByteStream.get32bit());
            wizePanelItemType.params().setField(this.convert_fs(inputByteStream.get8bit()));
            wizePanelItemType.params().setGoodTransmissions(inputByteStream.get16bit());
            wizePanelItemType.params().setBadTransmissions(inputByteStream.get16bit());
            wizePanelItemType.setLastUpdate(date);
            wizePanelItemType.params().setLastSeen((int)inputByteStream.get32bit());
            wizePanelItemType.params().setWakeup(inputByteStream.get16bit() * 60);
            wizePanelItemType.params().setBatteryPassive(inputByteStream.get16bit());
            wizePanelItemType.params().setBatteryActive(inputByteStream.get16bit());
            if (this.ack == 1) {
                wizePanelItemType.setType(inputByteStream.get8bit());
                wizePanelItemType.setDispatcherFieldStrength(this.convert_fs(inputByteStream.get8bit()));
            }
            this.wizePanelList.add(wizePanelItemType);
        }
    }

    public List<WizePanelItemType> getWizePanelList() {
        return this.wizePanelList;
    }

    public void addWizePanel(WizePanelItemType wizePanelItemType) {
        this.wizePanelList.add(wizePanelItemType);
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(this.wizePanelList);
        for (WizePanelItemType wizePanelItemType : this.wizePanelList) {
            Map<WizePanelItemType.WizePanelDescrTags, String> map = wizePanelItemType.toMap();
            if (this.ack != 1) {
                map.remove((Object)WizePanelItemType.WizePanelDescrTags.WPF_TYPE);
                map.remove((Object)WizePanelItemType.WizePanelDescrTags.WPF_DISPATCHER_FIELD_STRENGTH);
            }
            stringBuilder.append(WpUtils.implode((String)"", map.values())).append("\n");
        }
        stringBuilder.append("\nResult(s): ").append(this.wizePanelList.size());
        return stringBuilder.toString();
    }

    @Override
    public String getCompactResults() {
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(this.wizePanelList);
        stringBuilder.append("\n#Entries: ").append(this.wizePanelList.size()).append("\n\n");
        stringBuilder.append(String.format("%1$-10s", "wpid"));
        if (this.ack == 1) {
            stringBuilder.append(String.format(" | %1$9s", "type"));
        }
        stringBuilder.append(String.format(" | %1$10s", "lastseen"));
        stringBuilder.append(String.format(" | %1$10s", "wakeup"));
        stringBuilder.append(String.format(" | %1$10s", "field"));
        stringBuilder.append(String.format(" | %1$10s", "good ta"));
        stringBuilder.append(String.format(" | %1$10s", "bad ta"));
        stringBuilder.append(String.format(" | %1$10s", "bat pas"));
        stringBuilder.append(String.format(" | %1$10s", "bat act"));
        stringBuilder.append(" |\n");
        if (this.ack == 1) {
            stringBuilder.append("-----------+");
        }
        stringBuilder.append("-----------+------------+------------+------------+------------+------------+------------+------------|\n");
        for (WizePanelItemType wizePanelItemType : this.wizePanelList) {
            stringBuilder.append(String.format("%1$-10s", wizePanelItemType.getSerialNo()));
            if (this.ack == 1) {
                stringBuilder.append(String.format(" | %1$9s", wizePanelItemType.getType()));
            }
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.getLastSeen()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getWakeup()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getField() + "|" + wizePanelItemType.getDispatcherFieldStrength()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getGoodTransmissions()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getBadTransmissions()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getBatteryPassive()));
            stringBuilder.append(String.format(" | %1$10s", wizePanelItemType.params().getBatteryActive()));
            stringBuilder.append(" |\n");
        }
        return stringBuilder.toString();
    }

    private int convert_fs(int n) {
        n = n < 128 ? n / 2 - 74 : (n - 256) / 2 - 74;
        return n;
    }

    @Override
    public String getCommandConfiguration() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ack == 1) {
            stringBuilder.append(PARAM_EXTENDED);
        }
        return stringBuilder.toString();
    }
}

