/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.WpNumberUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

public class CommCmDispSubscribeList
extends ACommCommand {
    private static final int COMMAND_ID = 43;
    private static final String COMMAND_NAME = "subscribe-list";
    private static final String COMMAND_DESC = "Clears the list of subscribed panels";
    private static final String COMMAND_HELP = "--command subscribe-list --ip 192.168.1.209 --port 8000 --wpid 135023666,135023555";
    private final Set<Long> wpids = new HashSet<Long>();
    private static final String PARAM_WPID = "wpid";

    public CommCmDispSubscribeList() {
        super(43, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_WPID, CommCommandParams.Types.STRING, PARAM_WPID, "Comma separated list of WPIDs");
    }

    @Override
    public int getCommandParamsSize() {
        return this.wpids.size() * 4;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(43).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        OutputByteStream outputByteStream = new OutputByteStream(byArray);
        for (long l : this.wpids) {
            outputByteStream.put32bit(l);
        }
    }

    @Override
    public String getResults() {
        if (this.wpids.size() == 0) {
            return "Removed all subscribed panels.\n";
        }
        return "Panel(s) registered: " + this.wpids.size();
    }

    @Override
    public ACommCommand initializeCommandParams() throws WizePanelExceptions {
        String[] stringArray;
        this.wpids.clear();
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_WPID);
        if (commCommandParamValue != null && commCommandParamValue.getStringParam().length() != 0 && (stringArray = commCommandParamValue.getStringParam().split(",")) != null && stringArray.length != 0) {
            for (String string : stringArray) {
                try {
                    this.wpids.add(WpNumberUtils.str2long(string));
                }
                catch (NumberFormatException numberFormatException) {
                    LogManager.getLogger(CommCmDispSubscribeList.class).error("BadFormat: {}", (Object)string);
                }
            }
        }
        return this;
    }

    public void add(long l) {
        this.wpids.add(l);
    }
}

