/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcherBase;

public class CommCmUpdateDispatcherInitialPacket
extends CommCmUpdateDispatcherBase {
    private final int file_length;
    private final int packet_len;

    public CommCmUpdateDispatcherInitialPacket(int n, int n2) {
        this.file_length = n;
        this.packet_len = n2;
        this.setReadTimeout(30000);
    }

    @Override
    public ACommCommand initializeCommandParams() {
        return null;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        int n = this.getNumberOfPackets(4 + this.file_length, this.packet_len);
        commHeader.setSeqNum(0).setPackCount(n).setCommandId(75).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public int getCommandParamsSize() {
        return 4;
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        OutputByteStream outputByteStream = new OutputByteStream(4);
        outputByteStream.put32bit((long)this.file_length);
        for (int i = 0; i < outputByteStream.length(); ++i) {
            byArray[n + i] = outputByteStream.getData()[i];
        }
    }

    @Override
    public int getFirstSequenceNumber() {
        return 0;
    }

    @Override
    public String getResults() {
        return "";
    }
}

