/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.basic.ICommDispVerRetriever;
import de.wilke.wizepanel.prot.basic.WpOsValidator;
import de.wilke.wizepanel.prot.basic.WpVersionUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;

public class CommCmWizePanelSendBmp
extends ACommCommand {
    private static final int COMMAND_ID = 9;
    public static final boolean WP_RETRIEVE_VER_BEFORE_SEND = true;
    public static final int WP_RETRIEVE_VER_BEFORE_SEND_PAUSE = 5000;
    private static final String WP_FIRST_LINUX_FIX_VERSION = "1.08";
    private static final String WP_LAST_LINUX_FIX_VERSION = "1.09";
    private static final String COMMAND_NAME = "wp-image";
    private static final String COMMAND_DESC = "Send Image to WizePanel";
    private static final String COMMAND_HELP = "--command wp-image --ip 192.168.1.209 --port 8000 --wpid 23020 --image 320x240_sw.bmp\n            Send the Image 320x240_sw.bmp to the WizePanel with the ID 23020\n              via the Dispatcher identified by the IP 192.168.1.209 and the port 8000.";
    private static final String PARAM_NAME_WPID = "wpid";
    private static final String PARAM_NAME_IMAGE = "image";
    private static final byte PARAMS_SIZE = 0;
    private int wizePanelID;
    private String PathToBmpFile;
    private File BmpFile;
    private byte[] FileBuf;
    private boolean forceTcpWindowCorrection = false;

    public CommCmWizePanelSendBmp() {
        super(9, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_NAME_WPID, CommCommandParams.Types.STRING, PARAM_NAME_WPID, "ID (serial number) of WizePanel.");
        this.commandDescr.addFileParam(PARAM_NAME_IMAGE, CommCommandParams.Types.STRING, PARAM_NAME_IMAGE, "Name of a BMP file to send to WizePanel.", true);
        this.FileBuf = null;
        this.setReadTimeout(30000);
    }

    public CommCmWizePanelSendBmp(int n, String string) {
        this();
        this.wizePanelID = n;
        this.PathToBmpFile = string;
        this.FileBuf = null;
        this.BmpFile = new File(this.PathToBmpFile);
    }

    public CommCmWizePanelSendBmp(int n, byte[] byArray) {
        this();
        this.wizePanelID = n;
        this.FileBuf = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.FileBuf, 0, byArray.length);
    }

    @Override
    public CommCmWizePanelSendBmp initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_NAME_WPID);
        if (commCommandParamValue != null) {
            this.wizePanelID = Integer.parseInt(commCommandParamValue.getStringParam());
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_IMAGE)) != null) {
            this.PathToBmpFile = commCommandParamValue.getStringParam();
        }
        this.BmpFile = new File(this.PathToBmpFile);
        this.FileBuf = null;
        return this;
    }

    public boolean beforeExecuteComposite(String string, int n, CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        ICommDispVerRetriever iCommDispVerRetriever;
        if (!WpOsValidator.isWindows() && null != (iCommDispVerRetriever = this.getDispVersionRetriever())) {
            if (null == commSocketsOperations) {
                iCommDispVerRetriever.retrieve(string, n);
            } else {
                iCommDispVerRetriever.retrieve(commSocketsOperations);
            }
            this.checkLinuxFixVersion(iCommDispVerRetriever.getVersion());
        }
        return true;
    }

    @Override
    public boolean beforeExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return this.beforeExecuteComposite(null, 0, commSocketsOperations);
    }

    @Override
    public boolean beforeExecute(String string, int n) throws WizePanelExceptions {
        return this.beforeExecuteComposite(string, n, null);
    }

    @Override
    public boolean afterExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return true;
    }

    @Override
    public boolean afterExecute(String string, int n) throws WizePanelExceptions {
        return true;
    }

    @Override
    public boolean mustForceTcpWindowCorrection() {
        return this.forceTcpWindowCorrection;
    }

    @Override
    public int getCommandParamsSize() {
        if (this.FileBuf == null) {
            return this.getBmpFileLength();
        }
        return this.FileBuf.length;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(9).setDestAddr(this.wizePanelID).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        if (this.FileBuf != null) {
            this.copyCommandParamsFromFileBuf(byArray, n);
        } else if (this.BmpFile != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.PathToBmpFile);){
                this.FileBuf = new byte[(int)this.BmpFile.length()];
                fileInputStream.read(this.FileBuf);
                this.copyCommandParamsFromFileBuf(byArray, n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_FILE_NOT_FOUND_EXCEPTION, this.PathToBmpFile);
            }
            catch (IOException iOException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
            }
        }
    }

    @Override
    public String getResults() {
        Object object = "";
        object = (String)object + "Image is sent to Dispatcher\n";
        object = (String)object + this.getResponseHeader().getFormattedTransactionId() + "\n";
        return object;
    }

    public int getWizePanelID() {
        return this.wizePanelID;
    }

    public CommCmWizePanelSendBmp setWizePanelID(int n) {
        this.wizePanelID = n;
        return this;
    }

    public String getPathToBmpFile() {
        return this.PathToBmpFile;
    }

    public CommCmWizePanelSendBmp setPathToBmpFile(String string) {
        this.PathToBmpFile = string;
        return this;
    }

    private int getBmpFileLength() {
        if (this.BmpFile == null) {
            return 0;
        }
        if (!this.BmpFile.exists() | this.BmpFile.isDirectory()) {
            return 0;
        }
        return (int)this.BmpFile.length();
    }

    private void copyCommandParamsFromFileBuf(byte[] byArray, int n) {
        for (int i = 0; i < this.FileBuf.length; ++i) {
            byArray[n + i] = (byte)(this.FileBuf[i] & 0xFF);
        }
        long l = (long)byArray[n + 34] + (((long)byArray[n + 35] & 0xFFL) << 8);
        long l2 = ((long)byArray[n + 22] & 0xFFL) + (((long)byArray[n + 23] & 0xFFL) << 8) + (((long)byArray[n + 24] & 0xFFL) << 16) + (((long)byArray[n + 25] & 0xFFL) << 24);
        long l3 = (long)byArray[n + 18] + (((long)byArray[n + 19] & 0xFFL) << 8) + (((long)byArray[n + 20] & 0xFFL) << 16) + (((long)byArray[n + 21] & 0xFFL) << 24);
        if (l != l2 * l3 / 8L) {
            l = l2 * l3 / 8L;
            byArray[n + 34] = (byte)(l & 0xFFL);
            byArray[n + 35] = (byte)(l >> 8 & 0xFFL);
        }
    }

    public void checkLinuxFixVersion(String string) throws WizePanelExceptions {
        if (WpVersionUtils.compare(string, WP_FIRST_LINUX_FIX_VERSION) >= 0 && WpVersionUtils.compare(string, WP_LAST_LINUX_FIX_VERSION) <= 0) {
            this.forceTcpWindowCorrection = true;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, interruptedException.getMessage());
            }
        }
    }

    @Override
    public int preferredPayloadPacketSize(boolean bl) {
        return 10000;
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(PARAM_NAME_WPID, this.wizePanelID);
        linkedHashMap.put("len", this.getCommandParamsSize());
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

