/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm.types;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import java.util.LinkedHashMap;

public class StatsEntry {
    private static final int LEN = 25;
    public long max_data_memory = 0L;
    public long free_data_memory = 0L;
    public int max_number_commands = 0;
    public int free_number_commands = 0;
    public int max_number_targets = 0;
    public int free_number_targets = 0;
    public int max_number_target_data = 0;
    public int free_number_target_data = 0;
    public long uptime_secs = 0L;
    public int runtime_errors = 0;

    public String toString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("Data memory", this.max_data_memory);
        linkedHashMap.put("Free data memory", this.free_data_memory);
        linkedHashMap.put("Max. number of command", this.max_number_commands);
        linkedHashMap.put("Free number of commands", this.free_number_commands);
        linkedHashMap.put("Max. number of WizePanels", this.max_number_targets);
        linkedHashMap.put("Free number of WizePanels", this.free_number_targets);
        linkedHashMap.put("Max. number of WizePanel data", this.max_number_target_data);
        linkedHashMap.put("Free number of WizePanel data", this.free_number_target_data);
        linkedHashMap.put("Up time (secs)", this.uptime_secs);
        linkedHashMap.put("Run-time errors exist", this.runtime_errors == 0 ? "No" : "YES");
        return PrettyPrinter.block(linkedHashMap);
    }

    public String toCondensedString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("max_data_memory", this.max_data_memory);
        linkedHashMap.put("free_data_memory", this.free_data_memory);
        linkedHashMap.put("max_number_commands", this.max_number_commands);
        linkedHashMap.put("free_number_commands", this.free_number_commands);
        linkedHashMap.put("max_number_targets", this.max_number_targets);
        linkedHashMap.put("free_number_targets", this.free_number_targets);
        linkedHashMap.put("max_number_target_data", this.max_number_target_data);
        linkedHashMap.put("free_number_target_data", this.free_number_target_data);
        linkedHashMap.put("uptime_secs", this.uptime_secs);
        linkedHashMap.put("runtime_errors", this.runtime_errors == 0 ? "No" : "YES");
        return PrettyPrinter.condensed(linkedHashMap);
    }

    public void from(byte[] byArray) throws WizePanelExceptions {
        if (byArray.length != 25) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        this.max_data_memory = inputByteStream.get32bit();
        this.free_data_memory = inputByteStream.get32bit();
        this.max_number_commands = inputByteStream.get16bit();
        this.free_number_commands = inputByteStream.get16bit();
        this.max_number_targets = inputByteStream.get16bit();
        this.free_number_targets = inputByteStream.get16bit();
        this.max_number_target_data = inputByteStream.get16bit();
        this.free_number_target_data = inputByteStream.get16bit();
        this.uptime_secs = inputByteStream.get32bit();
        this.runtime_errors = inputByteStream.get8bit();
    }

    public byte[] getBytes() {
        OutputByteStream outputByteStream = new OutputByteStream(25);
        outputByteStream.put32bit(this.max_data_memory);
        outputByteStream.put32bit(this.free_data_memory);
        outputByteStream.put16bit(this.max_number_commands);
        outputByteStream.put16bit(this.free_number_commands);
        outputByteStream.put16bit(this.max_number_targets);
        outputByteStream.put16bit(this.free_number_targets);
        outputByteStream.put16bit(this.max_number_target_data);
        outputByteStream.put16bit(this.free_number_target_data);
        outputByteStream.put32bit(this.uptime_secs);
        outputByteStream.put8bit((short)this.runtime_errors);
        return outputByteStream.getData();
    }
}

