/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.launch;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmSysGetDispatchers;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.launch.ConsoleProgressBarTraditional;
import java.net.DatagramPacket;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DispatcherListener {
    private static final int port = 8000;
    private static final int duration = 15000;

    public static void main(String[] stringArray) throws Exception {
        Object wizePanelExceptions;
        ConsoleProgressBarTraditional consoleProgressBarTraditional = new ConsoleProgressBarTraditional(15, true);
        consoleProgressBarTraditional.setPreText("Listening on UDP-Port 8000 ");
        consoleProgressBarTraditional.start();
        List<DatagramPacket> list = new CommSocketsOperations().receiveUdpDatagrams(8000, 15000);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CommPacket commPacket = new CommPacket();
        for (DatagramPacket object2 : list) {
            if (object2.getLength() <= 0) continue;
            Object object = new CommCmSysGetDispatchers();
            ((CommCmSysGetDispatchers)object).initializeCommandParams();
            try {
                if (commPacket.parse(object2.getData(), object2.getLength())) {
                    ((ACommCommand)object).parseResponse(commPacket.commandHeader(), commPacket.commandPayload());
                    wizePanelExceptions = ((CommCmSysGetDispatchers)object).getDispatcher();
                    ((DispatcherItemType)wizePanelExceptions).params().setIp(object2.getAddress().getHostAddress());
                    hashMap.put(((DispatcherItemType)wizePanelExceptions).getId(), wizePanelExceptions);
                    continue;
                }
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
            }
            catch (WizePanelExceptions exception) {
                exception.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : hashMap.values()) {
            wizePanelExceptions = new LinkedHashMap<String, Object>();
            wizePanelExceptions.put("Address", ((DispatcherItemType)object).params().getIp());
            wizePanelExceptions.put("Port", ((DispatcherItemType)object).params().getPort());
            wizePanelExceptions.put("Netmask", ((DispatcherItemType)object).params().getSubnet());
            wizePanelExceptions.put("MAC", ((DispatcherItemType)object).params().getMac());
            wizePanelExceptions.put("Gateway", ((DispatcherItemType)object).params().getGateway());
            wizePanelExceptions.put("Dispatcher ID", ((DispatcherItemType)object).getId());
            wizePanelExceptions.put("Dispatcher Version", ((DispatcherItemType)object).params().getVersion());
            stringBuilder.append("\n").append(PrettyPrinter.block((Map)wizePanelExceptions));
        }
        stringBuilder.append("\n\nDispatcher(s) found: ").append(hashMap.size());
        System.out.println(stringBuilder.toString());
    }
}

