/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.launch;

import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmCancelTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispDebug;
import de.wilke.wizepanel.prot.comm.CommCmDispGetCommandResponse;
import de.wilke.wizepanel.prot.comm.CommCmDispGetErrors;
import de.wilke.wizepanel.prot.comm.CommCmDispGetFirmwareVer;
import de.wilke.wizepanel.prot.comm.CommCmDispGetSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispGetStats;
import de.wilke.wizepanel.prot.comm.CommCmDispGetTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsAll;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsSubscribed;
import de.wilke.wizepanel.prot.comm.CommCmDispRestart;
import de.wilke.wizepanel.prot.comm.CommCmDispSetAudioVisualIdentify;
import de.wilke.wizepanel.prot.comm.CommCmDispSetIpSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispSetMaxWp;
import de.wilke.wizepanel.prot.comm.CommCmDispSubscribeList;
import de.wilke.wizepanel.prot.comm.CommCmDispSubscribeWp;
import de.wilke.wizepanel.prot.comm.CommCmDispUDPInfoSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispUnSubscribeWp;
import de.wilke.wizepanel.prot.comm.CommCmSysGetVersion;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcher;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelElectricErase;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelGetVersion;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendBmp;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendData;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSetWakeUpInterval;
import de.wilke.wizepanel.prot.comm.WpCmdDHCP;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;

public class WizePanelTools {
    public static final String PARAM_MAC = "mac";
    private static final List<ACommCommand> commands = new LinkedList<ACommCommand>();
    private static boolean initialized = false;

    private WizePanelTools() {
    }

    public static void init() throws Exception {
        WizePanelTools.initCommandList();
        initialized = true;
    }

    private static synchronized void initCommandList() {
        initialized = true;
        commands.add(new CommCmSysGetVersion());
        commands.add(new CommCmWizePanelSendBmp());
        commands.add(new CommCmWizePanelSendData());
        commands.add(new CommCmWizePanelSetWakeUpInterval());
        commands.add(new CommCmWizePanelElectricErase());
        commands.add(new CommCmWizePanelGetVersion());
        commands.add(new CommCmDispSetIpSettings());
        commands.add(new CommCmDispSetAudioVisualIdentify());
        commands.add(new CommCmDispGetFirmwareVer());
        commands.add(new CommCmDispRestart());
        commands.add(new CommCmDispGetWizepanelsAll());
        commands.add(new CommCmDispGetWizepanelsSubscribed());
        commands.add(new CommCmDispGetStats());
        commands.add(new CommCmDispGetSettings());
        commands.add(new CommCmDispSetMaxWp());
        commands.add(new CommCmDispGetErrors());
        commands.add(new CommCmDispDebug());
        commands.add(new CommCmDispUDPInfoSettings());
        commands.add(new CommCmUpdateDispatcher());
        commands.add(new WpCmdDHCP());
        commands.add(new CommCmDispSubscribeWp());
        commands.add(new CommCmDispSubscribeList());
        commands.add(new CommCmDispUnSubscribeWp());
        commands.add(new CommCmDispGetTransactions());
        commands.add(new CommCmCancelTransactions());
        commands.add(new CommCmDispGetCommandResponse());
    }

    public static ACommCommand getCommandById(int n) {
        if (!initialized) {
            WizePanelTools.initCommandList();
        }
        for (ACommCommand aCommCommand : commands) {
            if (aCommCommand.getId() != n) continue;
            return aCommCommand;
        }
        return null;
    }

    public static ACommCommand createCommandById(int n) {
        ACommCommand aCommCommand = WizePanelTools.getCommandById(n);
        if (aCommCommand == null) {
            return null;
        }
        try {
            Class<?> clazz = aCommCommand.getClass();
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (ACommCommand)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List<ACommCommand> getCommands() {
        if (!initialized) {
            WizePanelTools.initCommandList();
        }
        return commands;
    }
}

