#!/bin/sh

if [ ! -d WPServer ]; then
	echo "Installation source directory WPServer does not exist."
	exit 1
fi

if [ "$1" = "" ]; then
	echo "Need the path to the WizePanel-Server directory."
	exit 2
fi
if [ ! -d "$1" ]; then
	echo "WizePanel-Server directory does not exist."
	exit 3
fi

DEST=$1


# Overwrite
cp -rv WPServer/doc "$DEST"
cp -rv WPServer/lib "$DEST"

# Overwrite
cp -v WPServer/start.sh "$DEST"
cp -v WPServer/start_headless.sh "$DEST"
cp -v WPServer/VERSION.txt "$DEST"
cp -v WPServer/wp_server.jar "$DEST"

# Update (do not overwrite)
cp -rv -n WPServer/conf "$DEST"
cp -rv -n WPServer/wpserver "$DEST"
cp -rv -n WPServer/logs "$DEST"
cp -rv -n WPServer/system "$DEST"
# These must be overwritten
cp -v WPServer/system/displays.xml "$DEST/system/displays.xml"
cp -v WPServer/conf/hibernate.cfg.xml "$DEST/conf/hibernate.cfg.xml"
cp -v WPServer/wpserver/conf/hibernate.cfg.xml "$DEST/wpserver/conf/hibernate.cfg.xml"

# Remove
rm -rf "$DEST/admin_tools"
rm -rf "$DEST/bin"
rm -f  "$DEST/start_launcher.bat"
rm -f  "$DEST/start_launcher.exe"
