/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorRenderer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ColorLabel _color = new ColorLabel();
    private final JLabel _text = new JLabel();

    public ColorRenderer() {
        this._color.setOpaque(true);
        this._text.setHorizontalAlignment(2);
        this._text.setFont(this.getFont().deriveFont(0));
        this._text.setOpaque(false);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this._color, "West");
        this.add((Component)this._text, "Center");
    }

    public void setText(String string) {
        this._color.setVisible(!string.equals(" ... "));
        this._text.setText(string);
    }

    public void setColor(Color color) {
        this._color.setBackground(color);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._text.setEnabled(bl);
    }

    private class ColorLabel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ColorLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, 20);
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = this.getWidth() > this.getHeight() ? this.getHeight() : this.getWidth();
            graphics.setColor(this.getBackground());
            graphics.fillRect((this.getWidth() - (n -= 4)) / 2, (this.getHeight() - n) / 2, n, n);
            graphics.setColor(this.getForeground());
            graphics.drawRect((this.getWidth() - n) / 2, (this.getHeight() - n) / 2, n, n);
        }
    }
}

