/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable.attributes;

import de.wilke.misc.treetable.attributes.BooleanProperty;
import de.wilke.misc.treetable.attributes.IntegerProperty;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.templateeditor.properties.PropertiesPanel;
import javax.swing.JComboBox;

public abstract class AbstractAttribute {
    private AbstractAttribute parent = null;
    private String name;
    private PropertiesPanel props = null;
    private AbstractAttribute disable_if_prop = null;
    private Object disable_has_value = null;

    public AbstractAttribute(String string) {
        this.name = string;
    }

    public AbstractAttribute(AbstractAttribute abstractAttribute, String string) {
        this.name = string;
        this.parent = abstractAttribute;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isProperty();

    public abstract String getValue();

    public String getFormattedValue() {
        return this.getValue();
    }

    public final void setValue(String string) {
        this.setInternalValue(string);
        this.fireAttributeChanged(this);
        if (this.parent != null) {
            this.parent.fireAttributeChanged(this.parent);
        }
    }

    protected abstract void setInternalValue(String var1);

    public AbstractAttribute[] getChildren() {
        return null;
    }

    public EditorType getEditorType() {
        return EditorType.NONE;
    }

    public JComboBox<String> getStringComboBox() {
        return null;
    }

    public RendererType getRendererType() {
        return RendererType.STRING;
    }

    public final String getToolTip() {
        return "FIXME:getToolTip()";
    }

    public final void setGUI(PropertiesPanel propertiesPanel) {
        this.props = propertiesPanel;
        AbstractAttribute[] abstractAttributeArray = this.getChildren();
        if (abstractAttributeArray != null) {
            for (int i = 0; i < abstractAttributeArray.length; ++i) {
                abstractAttributeArray[i].setGUI(propertiesPanel);
            }
        }
    }

    protected final void fireAttributeChanged(AbstractAttribute abstractAttribute) {
        if (this.props != null) {
            this.props.propertyModified(abstractAttribute, false);
        }
    }

    public boolean isEnabled() {
        if (this.disable_if_prop == null || this.disable_has_value == null) {
            return true;
        }
        if (this.disable_if_prop instanceof BooleanProperty) {
            return WpUtils.str2bool((String)this.disable_if_prop.getValue()) != (Boolean)this.disable_has_value;
        }
        if (this.disable_if_prop instanceof IntegerProperty) {
            return !this.disable_if_prop.getValue().equals(this.disable_has_value.toString());
        }
        return true;
    }

    public void disableIf(BooleanProperty booleanProperty, boolean bl) {
        this.disable_if_prop = booleanProperty;
        this.disable_has_value = bl;
    }

    public void disableIf(IntegerProperty integerProperty, int n) {
        this.disable_if_prop = integerProperty;
        this.disable_has_value = n;
    }

    public static enum RendererType {
        STRING,
        BOOLEAN,
        COLOR;

    }

    public static enum EditorType {
        NONE,
        LIST,
        FONT,
        IMAGE,
        BOOLEAN,
        NUMBER,
        DASHLINE,
        COLOR;

    }
}

