/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable.attributes;

import de.wilke.misc.treetable.ColorRenderer;
import de.wilke.misc.treetable.attributes.AbstractAttribute;
import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.WPTemplates;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ColorAttribute
extends AbstractAttribute {
    private Color color;
    private JComboBox<String> editor;
    private final WPTemplates app;

    public ColorAttribute(WPTemplates wPTemplates, String string, Color color) {
        super(string);
        this.color = color;
        this.app = wPTemplates;
        this.create_editor();
    }

    public ColorAttribute(WPTemplates wPTemplates, AbstractAttribute abstractAttribute, String string, Color color) {
        super(abstractAttribute, string);
        this.color = color;
        this.app = wPTemplates;
        this.create_editor();
    }

    private void create_editor() {
        this.editor = new JComboBox(this.app.template.getCommonColors(WpTemplateUtils.color2str((Color)this.color)));
        this.editor.setEditable(false);
        this.editor.setRenderer(new ComboBoxRenderer());
        this.editor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (itemEvent.getItem().toString().equals(" ... ")) {
                        Color color = JColorChooser.showDialog(ColorAttribute.this.app.frame(), WPApp.tr((String)"color_chooser"), ColorAttribute.this.color);
                        if (color != null) {
                            ColorAttribute.this.color = color;
                        }
                    } else {
                        ColorAttribute.this.color = WpTemplateUtils.str2color((String)itemEvent.getItem().toString());
                    }
                }
            }
        });
    }

    @Override
    public String getValue() {
        return WpTemplateUtils.color2str((Color)this.color);
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    protected void setInternalValue(String string) {
        Color color = WpTemplateUtils.str2color((String)string);
        if (color != null) {
            this.color = color;
        }
    }

    @Override
    public AbstractAttribute.EditorType getEditorType() {
        return AbstractAttribute.EditorType.COLOR;
    }

    @Override
    public JComboBox<String> getStringComboBox() {
        this.editor.setSelectedItem(WpTemplateUtils.color2str((Color)this.color));
        return this.editor;
    }

    @Override
    public AbstractAttribute.RendererType getRendererType() {
        return AbstractAttribute.RendererType.COLOR;
    }

    private class ComboBoxRenderer
    extends ColorRenderer
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = 1L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (string != null) {
                this.setColor(WpTemplateUtils.str2color((String)string));
                this.setText(string);
            }
            return this;
        }
    }
}

