/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.misc.treetable.attributes;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.MyDialog;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DashLineChooser
extends MyDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private int return_value;
    private final JComboBox<String> m_list_of_dashes;
    private final JTextField m_pattern;
    private final DashPreview m_preview;

    public DashLineChooser(Frame frame) {
        super(frame);
        this.setTitle(WPApp.tr((String)"dashline_chooser"));
        this.setSize(640, 380);
        this.setMinimumSize(new Dimension(640, 380));
        this.setLocationRelativeTo(frame);
        String[] stringArray = new String[]{"", "10 10", "5 5", "20 5 1 5"};
        this.m_list_of_dashes = new JComboBox<String>(stringArray);
        this.m_list_of_dashes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DashLineChooser.this.setPattern(DashLineChooser.this.m_list_of_dashes.getSelectedItem().toString(), true);
            }
        });
        this.m_preview = new DashPreview();
        this.m_preview.setBorder(BorderFactory.createTitledBorder(WPApp.tr((String)"view.preview")));
        this.m_pattern = new JTextField();
        this.m_pattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DashLineChooser.this.setPattern(DashLineChooser.this.m_pattern.getText(), false);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)new JLabel(WPApp.tr((String)"pattern")), "West");
        jPanel.add((Component)this.m_pattern, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add(this.m_list_of_dashes, "North");
        jPanel2.add((Component)this.m_preview, "Center");
        jPanel2.add((Component)jPanel, "South");
        JButton jButton = new JButton(WPApp.tr((String)"button.ok"));
        jButton.setActionCommand("button.ok");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(WPApp.tr((String)"button.cancel"));
        jButton2.setActionCommand("button.cancel");
        jButton2.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.setContentPane(jPanel4);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                DashLineChooser.this.m_pattern.requestFocus();
            }
        });
    }

    public void setDashLine(String string, int n) {
        this.m_preview.setLineWidth(n);
        this.setPattern(string, true);
    }

    public String dashLineString() {
        float[] fArray = WpTemplateUtils.str2linedashes((String)this.m_pattern.getText());
        return WpTemplateUtils.linedashes2str((float[])fArray);
    }

    public int exec() {
        this.return_value = 1;
        this.setVisible(true);
        return this.return_value;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.return_value = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("button.ok") ? 0 : 1;
        this.setVisible(false);
    }

    private void setPattern(String string, boolean bl) {
        float[] fArray = WpTemplateUtils.str2linedashes((String)string);
        this.m_preview.setDashLine(fArray);
        if (bl) {
            if (fArray == null) {
                this.m_pattern.setText("");
            } else {
                String[] stringArray = new String[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    stringArray[i] = String.valueOf((int)fArray[i]);
                }
                this.m_pattern.setText(WpUtils.implode((String)" ", (String[])stringArray));
            }
        }
    }

    class DashPreview
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final Line2D.Double m_line = new Line2D.Double(25.0, 25.0, 100.0, 25.0);
        private int m_line_width = 1;
        private int m_line_close = 0;
        private float[] m_line_dashes = null;

        DashPreview() {
        }

        public void setDashLine(float[] fArray) {
            this.m_line_dashes = fArray;
            this.repaint();
        }

        public void setLineWidth(int n) {
            this.m_line_width = n;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.m_line.x2 = this.getWidth() - 50;
            if (this.m_line_dashes != null) {
                graphics2D.setStroke(new BasicStroke(this.m_line_width, this.m_line_close, 0, 1.0f, this.m_line_dashes, 0.0f));
            } else {
                graphics2D.setStroke(new BasicStroke(this.m_line_width, this.m_line_close, 0));
            }
            graphics2D.draw(this.m_line);
        }
    }
}

