/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor;

import de.wilke.wizepanel.core.WpDisplayUtils;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.templateeditor.ITemplateSettings;
import de.wilke.wizepanel.templateeditor.MyDialog;
import de.wilke.wizepanel.templates.Template;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;

public class NewTemplateDialog
extends MyDialog
implements ActionListener,
ITemplateSettings {
    private static final long serialVersionUID = 0L;
    private int return_value;
    private final JTextField m_title;
    private final JComboBox<Display> m_type;
    private final JTextArea m_type_desc;
    private final JTextArea m_desc;
    private JCheckBox custom_panel_checkbox;
    private final JPanel custom_panel;
    private JSpinner custom_width;
    private JSpinner custom_height;
    private JComboBox<String> custom_color_depth;
    private final JCheckBox bg_transparent;
    private final JButton ok;

    public NewTemplateDialog(Frame frame) {
        super(frame);
        this.setSize(640, 480);
        this.setMinimumSize(new Dimension(640, 480));
        this.setLocationRelativeTo(frame);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(WPApp.tr((String)"title")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_title = new JTextField();
        jPanel.add((Component)this.m_title, "Center");
        List list = WpDisplayUtils.getDisplays();
        this.m_type = new JComboBox(new Vector(list));
        this.m_type.setRenderer(new MyTypeRenderer());
        this.m_type_desc = new JTextArea();
        this.m_type_desc.setPreferredSize(new Dimension(0, 50));
        this.m_type_desc.setEditable(false);
        this.bg_transparent = new JCheckBox(WPApp.tr((String)"transparent"), false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(WPApp.tr((String)"desc")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_desc = new JTextArea();
        this.m_desc.setWrapStyleWord(true);
        this.m_desc.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.m_desc);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(this.m_type, "North");
        jPanel3.add((Component)new JScrollPane(this.m_type_desc), "Center");
        this.custom_panel = this.create_custom_panel();
        this.custom_panel_checkbox.setSelected(false);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(WPApp.tr((String)"type")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel4.add(jPanel3);
        jPanel4.add(this.custom_panel);
        Dimension dimension = jPanel.getPreferredSize();
        Dimension dimension2 = jPanel.getMaximumSize();
        jPanel.setMaximumSize(new Dimension((int)dimension2.getWidth(), (int)dimension.getHeight()));
        dimension = jPanel4.getPreferredSize();
        dimension2 = jPanel4.getMaximumSize();
        jPanel4.setMaximumSize(new Dimension((int)dimension2.getWidth(), (int)dimension.getHeight()));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel);
        jPanel5.add(jPanel4);
        jPanel5.add(jPanel2);
        jPanel5.add(this.bg_transparent);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.ok = new JButton(WPApp.tr((String)"button.ok"));
        this.ok.setActionCommand("button.ok");
        this.ok.addActionListener(this);
        JButton jButton = new JButton(WPApp.tr((String)"button.cancel"));
        jButton.setActionCommand("button.cancel");
        jButton.addActionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(this.ok);
        jPanel6.add(jButton);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel5, "Center");
        this.add((Component)jPanel6, "South");
    }

    private JPanel create_custom_panel() {
        this.custom_panel_checkbox = new JCheckBox(WPApp.tr((String)"custom"));
        this.custom_panel_checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NewTemplateDialog.this.m_type.setEnabled(!NewTemplateDialog.this.custom_panel_checkbox.isSelected());
                for (Component component : NewTemplateDialog.this.custom_panel.getComponents()) {
                    if (component == NewTemplateDialog.this.custom_panel_checkbox) continue;
                    component.setEnabled(NewTemplateDialog.this.custom_panel_checkbox.isSelected());
                }
            }
        });
        this.custom_width = new JSpinner(new SpinnerNumberModel(320, 0, 65535, 1));
        this.custom_height = new JSpinner(new SpinnerNumberModel(240, 0, 65535, 1));
        this.custom_color_depth = new JComboBox<String>(new String[]{"1", "4", "8", "32"});
        JPanel jPanel = new JPanel(new GridLayout(4, 2, 5, 5));
        jPanel.add(this.custom_panel_checkbox);
        jPanel.add(new JLabel());
        JLabel jLabel = new JLabel(WPApp.tr((String)"attr.w") + ":");
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        jPanel.add(this.custom_width);
        JLabel jLabel2 = new JLabel(WPApp.tr((String)"attr.h") + ":");
        jLabel2.setHorizontalAlignment(4);
        jPanel.add(jLabel2);
        jPanel.add(this.custom_height);
        JLabel jLabel3 = new JLabel(WPApp.tr((String)"color_depth") + ":");
        jLabel3.setHorizontalAlignment(4);
        jPanel.add(jLabel3);
        jPanel.add(this.custom_color_depth);
        return jPanel;
    }

    public int showNewDialog() {
        this.return_value = 1;
        this.m_title.setText("");
        this.m_type.setEnabled(true);
        this.setTitle(WPApp.tr((String)"new_template"));
        this.setVisible(true);
        return this.return_value;
    }

    @Override
    public boolean open(Template template) {
        this.m_title.setText(template.title());
        this.custom_panel_checkbox.setSelected(true);
        Display display = WpDisplayUtils.getDisplay((String)template.type());
        for (int i = 0; i < this.m_type.getItemCount(); ++i) {
            Display display2 = this.m_type.getItemAt(i);
            if (display.toString().equals(display2.toString())) {
                System.err.println(display2.equals((Object)display));
            }
            if (!display2.equals((Object)display)) continue;
            this.m_type.setSelectedIndex(i);
            this.custom_panel_checkbox.setSelected(false);
            break;
        }
        this.m_desc.setText(template.description());
        this.bg_transparent.setSelected(template.backgroundColor() == null);
        this.custom_width.setValue(template.getWidth());
        this.custom_height.setValue(template.getHeight());
        this.custom_color_depth.setSelectedItem(String.valueOf(template.getDisplay().getColorDepth()));
        this.setTitle(WPApp.tr((String)"template_info"));
        this.return_value = 1;
        this.setVisible(true);
        return this.return_value == 0;
    }

    public String templateTitle() {
        return this.m_title.getText();
    }

    public Display templateDisplay() {
        if (this.custom_panel_checkbox.isSelected()) {
            return new Display("custom", Integer.parseInt(this.custom_width.getValue().toString()), Integer.parseInt(this.custom_height.getValue().toString()), Integer.parseInt(this.custom_color_depth.getSelectedItem().toString()));
        }
        return (Display)this.m_type.getSelectedItem();
    }

    public boolean templateTransparentBackground() {
        return this.bg_transparent.isSelected();
    }

    public String templateDescription() {
        return this.m_desc.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string != null && string.equals("button.ok")) {
            this.return_value = 0;
        }
        this.setVisible(false);
    }

    class MyTypeRenderer
    extends JLabel
    implements ListCellRenderer<Display> {
        private static final long serialVersionUID = 1L;

        public MyTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Display> jList, Display display, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (display == null) {
                this.setText("");
            } else if (display.getType() == Display.Type.TYPE_CUSTOM) {
                this.setText(WPApp.tr((String)"custom+++"));
            } else {
                this.setText("[" + display.toString() + "] " + display.getTitle());
            }
            return this;
        }
    }
}

