/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor;

import de.wilke.wizepanel.core.app.WP;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.templateeditor.AllImageFilter;
import de.wilke.wizepanel.templateeditor.IQuitListener;
import de.wilke.wizepanel.templateeditor.ISaveListener;
import de.wilke.wizepanel.templateeditor.ITemplateSettings;
import de.wilke.wizepanel.templateeditor.MyFileChooser;
import de.wilke.wizepanel.templateeditor.NewTemplateDialog;
import de.wilke.wizepanel.templateeditor.OneFileFilter;
import de.wilke.wizepanel.templateeditor.StatusBar;
import de.wilke.wizepanel.templateeditor.TemplatePreviewDialog;
import de.wilke.wizepanel.templateeditor.ToolListener;
import de.wilke.wizepanel.templateeditor.Txt;
import de.wilke.wizepanel.templateeditor.canvas.Canvas;
import de.wilke.wizepanel.templateeditor.canvas.CanvasPreviewPanel;
import de.wilke.wizepanel.templateeditor.properties.PropertiesPanel;
import de.wilke.wizepanel.templateeditor.undo.AddCommand;
import de.wilke.wizepanel.templateeditor.undo.DeleteCommand;
import de.wilke.wizepanel.templateeditor.undo.LayerCommand;
import de.wilke.wizepanel.templateeditor.undo.ModifyCommand;
import de.wilke.wizepanel.templateeditor.undo.MoveResizeCommand;
import de.wilke.wizepanel.templateeditor.undo.ResizeCommand;
import de.wilke.wizepanel.templateeditor.undo.UndoStack;
import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.TemplateListener;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import de.wilke.wizepanel.templates.elements.TemplateElementsListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;

public class WPTemplates
extends WPApp
implements ActionListener,
ToolListener,
TemplateListener,
TemplateElementsListener {
    private static final long serialVersionUID = 0L;
    private static final String APP = "templates";
    private static final String APP_NAME = "WizePanel Template Editor";
    private static final String APP_VER = "0.2.0";
    private static final String ERR_FILE_OPEN = "err.tpl.open";
    public final Template template = new Template();
    private final LinkedList<TemplateElement> m_elements_clipboard = new LinkedList();
    private Canvas _canvas;
    private PropertiesPanel m_properties;
    private CanvasPreviewPanel _preview;
    private JSplitPane h_split;
    private JSplitPane v_split;
    private final float[] m_zoom_level = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 8.0f};
    private final String[] m_zoom_command = new String[]{"FIXME", "view.zoom.50", "view.zoom.75", "view.zoom.100", "view.zoom.150", "view.zoom.200", "view.zoom.300", "view.zoom.400", "view.zoom.800"};
    private JComboBox<String> m_zoom;
    private JRadioButton[] m_zoom_menu = null;
    private JSpinner m_grid_size;
    private MyToggleAction m_tool_select;
    private JMenu m_alignment_menu;
    private JMenu m_layer_menu;
    private MyAction m_file_save;
    private MyAction m_edit_undo;
    private MyAction m_edit_redo;
    private MyAction m_edit_cut;
    private MyAction m_edit_copy;
    private MyAction m_edit_paste;
    private MyToggleAction m_edit_copy_format;
    private MyAction m_edit_delete;
    private final LinkedList<MyToggleAction> _tools = new LinkedList();
    private JMenuItem m_selectall_menu;
    private MyToggleAction m_lock_all;
    private MyToolButton m_zoom_in;
    private MyToolButton m_zoom_out;
    private MyToolButton m_zoom_orig;
    private MyAction m_view_preview;
    private MyToggleAction m_view_grid;
    private MyToggleAction m_view_snap_to_grid;
    private MyToggleAction m_view_rulers;
    private MyToggleAction m_view_crop_outside;
    private MyToggleAction m_view_layers;
    private MyToggleAction m_view_placeholders;
    private MyToggleAction m_view_helpers;
    private final StatusBar m_status;
    private final Set<ToolListener> m_tool_listeners = new HashSet<ToolListener>();
    private final Set<ISaveListener> m_save_listeners = new HashSet<ISaveListener>();
    private final Set<ISaveListener> should_save_listeners = new HashSet<ISaveListener>();
    private final Set<IQuitListener> on_exit_listeners = new HashSet<IQuitListener>();
    private String[] fonts = Txt.getFontList();
    private final UndoStack m_undo_stack;
    private Preferences m_app_prefs = Preferences.userNodeForPackage(this.getClass());
    private JDialog m_elem_props = null;
    private TemplatePreviewDialog m_preview_dlg = null;
    private final NewTemplateDialog _tpl_dlg;
    private ITemplateSettings _tpl_settings = null;
    private MyFileChooser m_export_dlg = null;
    private MyFileChooser m_open_dlg = null;
    private TemplateElement copy_format_source = null;
    private MyFileChooser m_img_dlg;

    public WPTemplates(Frame frame, boolean bl, String string) {
        super(frame, APP, string, bl);
        this.m_undo_stack = new UndoStack(this.template);
        this.template.setElementsListener((TemplateElementsListener)this);
        this.addToolListener(this);
        WP.loadPreferences((WPApp)this);
        int n = Math.max(this.m_app_prefs.getInt("app.x", 0), 0);
        int n2 = Math.max(this.m_app_prefs.getInt("app.y", 0), 0);
        int n3 = Math.max(this.m_app_prefs.getInt("app.width", 800), 640);
        int n4 = Math.max(this.m_app_prefs.getInt("app.height", 600), 480);
        this.create_actions();
        this.m_status = new StatusBar();
        this._tpl_dlg = new NewTemplateDialog(this.frame());
        this._tpl_settings = this._tpl_dlg;
        if (frame instanceof JFrame) {
            ((JFrame)frame).setDefaultCloseOperation(0);
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WPTemplates.this.do_file_quit();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                WPTemplates.this.informOnExitListener();
            }
        });
        this.template.addTemplateListener((TemplateListener)this);
        this.setLayout(new BorderLayout());
        if (!this.isEmbedded()) {
            this.add(this.create_menubar(), "North");
        }
        this.add(this.create_content(), "Center");
        this.add(this.m_status, "South");
        this.template.informTemplateListeners(TemplateListener.TemplateEvent.NEW_TEMPLATE);
        this.update_zoom_buttons();
        this.templateModified(this.template, TemplateListener.TemplateEvent.MODIFIED);
        frame.setSize(n3, n4);
        frame.setMinimumSize(new Dimension(640, 480));
        frame.setLocation(n, n2);
    }

    public boolean canvasHasFocus() {
        return this._canvas.canvas().hasFocus();
    }

    public void copyPaste(String string) {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            if (string.equals("copy")) {
                jTextField.copy();
            } else if (string.equals("paste")) {
                jTextField.paste();
            } else if (string.equals("select-all")) {
                jTextField.selectAll();
            } else if (string.equals("cut")) {
                jTextField.cut();
            } else if (string.equals("delete")) {
                try {
                    jTextField.getDocument().remove(jTextField.getCaretPosition(), 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear_status_message")) {
            this.showStatusMessage(null, -1);
            return;
        }
        if (actionEvent.getSource() == this.m_zoom) {
            int n = this.m_zoom.getSelectedIndex();
            this._canvas.setScale(this.m_zoom_level[n]);
            if (this.m_zoom_menu != null) {
                this.m_zoom_menu[n].setSelected(true);
            }
            this.update_zoom_buttons();
            return;
        }
        if (actionEvent.getSource() == this.m_zoom_in) {
            int n = this.m_zoom.getSelectedIndex() + 1;
            if (n < this.m_zoom_level.length) {
                this.m_zoom.setSelectedIndex(n);
            }
            return;
        }
        if (actionEvent.getSource() == this.m_zoom_out) {
            int n = this.m_zoom.getSelectedIndex() - 1;
            if (n >= 0) {
                this.m_zoom.setSelectedIndex(n);
            }
            return;
        }
        if (string.equals("tool.select") || string.equals("tool.rect") || string.equals("tool.line") || string.equals("tool.text") || string.equals("tool.graphics") || string.equals("tool.ellipse") || string.equals("tool.qr") || string.equals("tool.timetable")) {
            this.informToolListeners(string);
        } else if (string.equals("file.new")) {
            this.do_file_new(false);
        } else if (string.equals("file.open")) {
            this.do_file_open();
        } else if (string.equals("file.saveas")) {
            this.informShouldSave(true);
        } else if (string.equals("file.save")) {
            this.informShouldSave(false);
        } else if (string.equals("file.saveas_image")) {
            this.do_file_saveas_image();
        } else if (string.equals("file.properties")) {
            this.do_file_info();
        } else if (string.equals("file.print")) {
            this.do_file_print();
        } else if (string.equals("file.quit")) {
            this.do_file_quit();
        } else if (string.equals("edit.undo")) {
            this.do_edit_undo();
        } else if (string.equals("edit.redo")) {
            this.do_edit_redo();
        } else if (string.equals("edit.cut")) {
            this.do_edit_cut();
        } else if (string.equals("edit.copy")) {
            this.do_edit_copy();
        } else if (string.equals("edit.paste")) {
            this.do_edit_paste(!this.m_edit_paste.equals(actionEvent.getSource()));
        } else if (string.equals("edit.copy_format")) {
            this.do_edit_copy_format();
            this.informToolListeners(string);
        } else if (string.equals("edit.delete")) {
            this.do_edit_delete();
        } else if (string.equals("edit.select_all")) {
            this.do_edit_select_all();
        } else if (string.equals("edit.lock-all")) {
            this.do_edit_lock();
        } else if (string.equals("edit.properties")) {
            this.do_edit_props();
        } else if (string.equals("edit.align.left") || string.equals("edit.align.hcenter") || string.equals("edit.align.right") || string.equals("edit.align.top") || string.equals("edit.align.vcenter") || string.equals("edit.align.bottom")) {
            this.do_edit_alignment(string);
        } else if (string.equals("edit.layer.bottom") || string.equals("edit.layer.down") || string.equals("edit.layer.top") || string.equals("edit.layer.up")) {
            this.do_edit_layer(string);
        } else if (string.equals("view.preview")) {
            this.do_view_preview();
        } else if (string.equals("view.grid")) {
            this._canvas.canvas().setGrid(this.m_view_grid.isSelected());
        } else if (!string.equals("view.snap-to-grid")) {
            if (string.equals("view.rulers")) {
                this._canvas.setRulers(this.m_view_rulers.isSelected());
            } else if (string.equals("view.layers")) {
                this._canvas.canvas().showLayers(this.m_view_layers.isSelected());
            } else if (string.equals("view.placeholders")) {
                this._canvas.canvas().showPlaceholders(this.m_view_placeholders.isSelected());
            } else if (string.equals("view.helpers")) {
                this._canvas.canvas().showHelpers(this.m_view_helpers.isSelected());
            } else if (string.equals("view.crop-outside")) {
                this._canvas.canvas().cropOutside(this.m_view_crop_outside.isSelected());
            } else if (string.equals("help.about")) {
                JOptionPane.showMessageDialog((Component)((Object)this), "WizePanel Template Editor\n\nVersion 0.2.0\n\n", WPTemplates.tr((String)"help.about"), 1);
            } else {
                for (int i = 0; i < this.m_zoom_command.length; ++i) {
                    if (!string.equals(this.m_zoom_command[i])) continue;
                    this._canvas.setScale(this.m_zoom_level[i]);
                    this.m_zoom.setSelectedIndex(i);
                    this.update_zoom_buttons();
                    return;
                }
            }
        }
    }

    private void do_file_print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable((Printable)this.template);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog((Component)((Object)this), WPTemplates.tr((String)"err_print", (String[])new String[]{printerException.getMessage()}), WPTemplates.tr((String)"Error"), 0);
            }
        }
    }

    private void do_file_new(boolean bl) {
        Display display;
        if (!bl) {
            if (this.keepChanges()) {
                return;
            }
            if (this._tpl_dlg.showNewDialog() != 0) {
                return;
            }
        }
        if ((display = this._tpl_dlg.templateDisplay()) != null && this.template.createNew(this._tpl_dlg.templateTitle(), this._tpl_dlg.templateDescription(), display.toString(), this._tpl_dlg.templateTransparentBackground() ? null : display.defaultBackground(), "false")) {
            this.m_undo_stack.clear();
            this.update_undo();
            this.setSelectTool(true);
            this.do_view_zoom_1();
            this.update_gui();
            this.showStatusMessage(WPTemplates.tr((String)"Created!"), 3);
        }
    }

    private void do_file_open() {
        if (this.m_open_dlg == null) {
            this.m_open_dlg = new MyFileChooser(WP.getTemplateFilename((String)"."));
            this.m_open_dlg.setFileSelectionMode(0);
            this.m_open_dlg.addChoosableFileFilter(new OneFileFilter("zip"));
            this.m_open_dlg.setInsistOnExtension(true);
        }
        if (this.keepChanges()) {
            return;
        }
        if (this.m_open_dlg.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        if (!this.open_template(this.m_open_dlg.getSelectedFile())) {
            JOptionPane.showMessageDialog((Component)((Object)this), WPTemplates.tr((String)ERR_FILE_OPEN, (String[])new String[]{this.template.getLastError()}), WPTemplates.tr((String)"Error"), 0);
        }
    }

    public boolean open_template(File file) {
        if (!this.template.open(file.getAbsolutePath())) {
            return false;
        }
        this.m_undo_stack.clear();
        this.update_undo();
        this.setSelectTool(true);
        this.do_view_zoom_1();
        this.update_gui();
        this.showStatusMessage(WPTemplates.tr((String)"Opened!"), 3);
        return true;
    }

    public void do_file_save(boolean bl) {
        Object object = this.template.filename();
        if (bl || object == null) {
            MyFileChooser myFileChooser = new MyFileChooser(WP.getTemplateFilename((String)"."));
            myFileChooser.addChoosableFileFilter(new OneFileFilter("zip"));
            if (myFileChooser.showSaveDialog((Component)((Object)this)) != 0) {
                return;
            }
            object = myFileChooser.getSelectedFile().getAbsolutePath();
            if (!((String)object).endsWith(".zip")) {
                object = (String)object + ".zip";
            }
        }
        if (this.template.writeTo((String)object)) {
            this.update_gui();
            this.showStatusMessage(WPTemplates.tr((String)"Saved!"), 3);
            this.informSaveListeners(true);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), WPTemplates.tr((String)"err_xml_save", (String[])new String[]{this.template.getLastError()}), WPTemplates.tr((String)"Error"), 0);
            this.informSaveListeners(false);
        }
    }

    private void do_file_saveas_image() {
        if (this.m_export_dlg == null) {
            this.m_export_dlg = new MyFileChooser(".");
            this.m_export_dlg.setFileSelectionMode(0);
            this.m_export_dlg.setAcceptAllFileFilterUsed(false);
            this.m_export_dlg.setInsistOnExtension(true);
            for (String string : Template.getImageExtentions()) {
                this.m_export_dlg.addChoosableFileFilter(new OneFileFilter(string));
            }
        }
        if (this.m_export_dlg.showSaveDialog((Component)((Object)this)) != 0) {
            return;
        }
        if (!this.template.writeToImage(this.m_export_dlg.getSelectedFile().getAbsolutePath(), false)) {
            JOptionPane.showMessageDialog((Component)((Object)this), WPTemplates.tr((String)"err.image_export", (String[])new String[]{this.template.getLastError()}), WPTemplates.tr((String)"Error"), 0);
        }
    }

    private void do_file_info() {
        if (this._tpl_settings.open(this.template)) {
            this.updateTemplate(this._tpl_dlg.templateTitle(), this._tpl_dlg.templateDescription(), this._tpl_dlg.templateTransparentBackground(), this._tpl_dlg.templateDisplay());
        }
    }

    public void updateTemplate(String string, String string2, boolean bl, Display display) {
        this.template.setTitle(string);
        this.template.setDescription(string2);
        this.template.setTransparent(bl);
        this.template.setType(display);
        int n = this.m_zoom.getSelectedIndex();
        this._canvas.setScale(this.m_zoom_level[n]);
        this.update_gui();
        this.template.setModified(true);
    }

    private void do_view_preview() {
        if (this.m_preview_dlg == null) {
            this.m_preview_dlg = new TemplatePreviewDialog(this.frame(), this);
            this.m_preview_dlg.setSize(this.m_app_prefs.getInt("preview.width", 480), this.m_app_prefs.getInt("preview.height", 640));
        }
        this.m_preview_dlg.setImage(this.template.exportToImage(false));
        this.m_preview_dlg.setVisible(true);
    }

    public void do_view_zoom_1() {
        this.m_zoom_orig.doClick();
    }

    public void doZoomIn() {
        if (this.m_zoom.getSelectedIndex() < this.m_zoom_level.length - 1) {
            this.m_zoom.setSelectedIndex(this.m_zoom.getSelectedIndex() + 1);
        }
    }

    public void doZoomOut() {
        if (this.m_zoom.getSelectedIndex() > 0) {
            this.m_zoom.setSelectedIndex(this.m_zoom.getSelectedIndex() - 1);
        }
    }

    public void do_file_quit() {
        if (this.keepChanges()) {
            return;
        }
        this.m_app_prefs.putInt("app.x", this.frame().getX());
        this.m_app_prefs.putInt("app.y", this.frame().getY());
        this.m_app_prefs.putInt("app.width", this.frame().getWidth());
        this.m_app_prefs.putInt("app.height", this.frame().getHeight());
        this.m_app_prefs.putInt("main.hsplit.div", this.h_split.getDividerLocation());
        this.m_app_prefs.putInt("main.vsplit.div", this.v_split.getDividerLocation());
        this.m_app_prefs.putBoolean("editor.grid", this.m_view_grid.isSelected());
        this.m_app_prefs.putInt("editor.grid_size", this._canvas.canvas().gridSize());
        this.m_app_prefs.putBoolean("editor.grid_snap", this.m_view_snap_to_grid.isSelected());
        this.m_app_prefs.putBoolean("editor.rulers", this.m_view_rulers.isSelected());
        this.m_app_prefs.putBoolean("editor.placeholders", this.m_view_placeholders.isSelected());
        this.m_app_prefs.putBoolean("editor.helpers", this.m_view_helpers.isSelected());
        this.m_app_prefs.putBoolean("editor.layers", this.m_view_layers.isSelected());
        this.m_app_prefs.putBoolean("edit.crop-outside", this.m_view_crop_outside.isSelected());
        if (this.m_elem_props != null) {
            this.m_app_prefs.putInt("props.width", this.m_elem_props.getWidth());
            this.m_app_prefs.putInt("props.height", this.m_elem_props.getHeight());
        }
        if (this.m_preview_dlg != null) {
            this.m_app_prefs.putInt("preview.width", this.m_preview_dlg.getWidth());
            this.m_app_prefs.putInt("preview.height", this.m_preview_dlg.getHeight());
        }
        WP.savePreferences((WPApp)this, (Preferences)this.m_app_prefs);
        System.exit(0);
    }

    public boolean keepChanges() {
        if (this.template.isModified()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), WPTemplates.tr((String)"ask.keepchanges.msg"), WPTemplates.tr((String)"ask.keepchanges.title"), 1, 3);
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public JMenu createAlignmentMenu() {
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"edit.align"));
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.left"));
        jMenuItem.setActionCommand("edit.align.left");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-horizontal-left.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.hcenter"));
        jMenuItem.setActionCommand("edit.align.hcenter");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-horizontal-center.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.right"));
        jMenuItem.setActionCommand("edit.align.right");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-horizontal-right.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.top"));
        jMenuItem.setActionCommand("edit.align.top");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-vertical-top.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.vcenter"));
        jMenuItem.setActionCommand("edit.align.vcenter");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-vertical-center.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.align.bottom"));
        jMenuItem.setActionCommand("edit.align.bottom");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/align-vertical-bottom.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenu createLayerMenu() {
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"edit.layer"));
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.layer.top"));
        jMenuItem.setActionCommand("edit.layer.top");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/object-order-front.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.layer.up"));
        jMenuItem.setActionCommand("edit.layer.up");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/object-order-raise.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.layer.down"));
        jMenuItem.setActionCommand("edit.layer.down");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/object-order-lower.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(WPTemplates.tr((String)"edit.layer.bottom"));
        jMenuItem.setActionCommand("edit.layer.bottom");
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/object-order-back.png"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private void create_actions() {
        this.m_file_save = new MyAction("file.save", "document-save.png", 83);
        this.m_file_save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.m_file_save.setEnabled(false);
        this.m_view_layers = new MyToggleAction("view.layers");
        this.m_view_layers.setSelected(this.m_app_prefs.getBoolean("editor.layers", false));
        this.m_view_placeholders = new MyToggleAction("view.placeholders");
        this.m_view_placeholders.setSelected(this.m_app_prefs.getBoolean("editor.placeholders", false));
        this.m_view_helpers = new MyToggleAction("view.helpers");
        this.m_view_helpers.setSelected(this.m_app_prefs.getBoolean("editor.helpers", false));
        this.m_edit_undo = new MyAction("edit.undo", "edit-undo.png", 90);
        this.m_edit_undo.setEnabled(false);
        this.m_edit_undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.m_edit_redo = new MyAction("edit.redo", "edit-redo.png", 89);
        this.m_edit_redo.setEnabled(false);
        this.m_edit_redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.m_edit_cut = new MyAction("edit.cut", "edit-cut.png", 88);
        this.m_edit_cut.setEnabled(false);
        this.m_edit_cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.m_edit_copy = new MyAction("edit.copy", "edit-copy.png", 67);
        this.m_edit_copy.setEnabled(false);
        this.m_edit_copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.m_edit_paste = new MyAction("edit.paste", "edit-paste.png", 86);
        this.m_edit_paste.setEnabled(false);
        this.m_edit_paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.m_edit_copy_format = new MyToggleAction("edit.copy_format", "edit-copy-format.png");
        this.m_edit_copy_format.setEnabled(false);
        this.m_edit_delete = new MyAction("edit.delete", "edit-delete.png", 127);
        this.m_edit_delete.setEnabled(false);
        this.m_edit_delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.m_view_preview = new MyAction("view.preview", "document-preview.png", 80);
        this.m_view_grid = new MyToggleAction("view.grid", "grid.png");
        this.m_view_snap_to_grid = new MyToggleAction("view.snap-to-grid", "snap-to-grid.png");
        this.m_view_rulers = new MyToggleAction("view.rulers", "ruler.png");
        this.m_view_crop_outside = new MyToggleAction("view.crop-outside", "crop_outside.png");
        this.m_lock_all = new MyToggleAction("edit.lock-all", "small/document-encrypt.png");
    }

    private JMenuBar create_menubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.create_menu_file());
        jMenuBar.add(this.create_menu_edit());
        jMenuBar.add(this.create_menu_view());
        jMenuBar.add(this.create_menu_help());
        return jMenuBar;
    }

    private JMenu create_menu_file() {
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"file.new"), 78);
        jMenuItem.setActionCommand("file.new");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        JMenuItem jMenuItem2 = new JMenuItem(WPTemplates.tr((String)"file.open"), 79);
        jMenuItem2.setActionCommand("file.open");
        jMenuItem2.setIcon(WPTemplates.getIcon((String)"small/document-open.png"));
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem jMenuItem3 = new JMenuItem(WPTemplates.tr((String)"file.saveas"));
        jMenuItem3.setActionCommand("file.saveas");
        jMenuItem3.addActionListener(this);
        JMenuItem jMenuItem4 = new JMenuItem(WPTemplates.tr((String)"file.saveas_image"));
        jMenuItem4.setActionCommand("file.saveas_image");
        jMenuItem4.addActionListener(this);
        JMenuItem jMenuItem5 = new JMenuItem(WPTemplates.tr((String)"file.properties"), 73);
        jMenuItem5.setActionCommand("file.properties");
        jMenuItem5.setIcon(WPTemplates.getIcon((String)"small/document-properties.png"));
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        JMenuItem jMenuItem6 = new JMenuItem(WPTemplates.tr((String)"file.print"), 80);
        jMenuItem6.setActionCommand("file.print");
        jMenuItem6.setIcon(WPTemplates.getIcon((String)"small/document-print.png"));
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        JMenuItem jMenuItem7 = new JMenuItem(WPTemplates.tr((String)"file.quit"), 81);
        jMenuItem7.setActionCommand("file.quit");
        jMenuItem7.addActionListener(this);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"File"));
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        this.m_file_save.addTo(jMenu);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenu.addSeparator();
        jMenu.add(jMenuItem6);
        jMenu.addSeparator();
        jMenu.add(jMenuItem7);
        return jMenu;
    }

    private JMenu create_menu_edit() {
        this.m_alignment_menu = this.createAlignmentMenu();
        this.m_layer_menu = this.createLayerMenu();
        this.m_selectall_menu = new JMenuItem(WPTemplates.tr((String)"edit.select_all"), 65);
        this.m_selectall_menu.setActionCommand("edit.select_all");
        this.m_selectall_menu.addActionListener(this);
        this.m_selectall_menu.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"Edit"));
        this.m_edit_undo.addTo(jMenu);
        this.m_edit_redo.addTo(jMenu);
        jMenu.addSeparator();
        this.m_edit_cut.addTo(jMenu);
        this.m_edit_copy.addTo(jMenu);
        this.m_edit_paste.addTo(jMenu);
        this.m_edit_copy_format.addTo(jMenu);
        jMenu.addSeparator();
        jMenu.add(this.m_alignment_menu);
        jMenu.add(this.m_layer_menu);
        jMenu.addSeparator();
        this.m_lock_all.addTo(jMenu);
        jMenu.addSeparator();
        this.m_edit_delete.addTo(jMenu);
        jMenu.add(this.m_selectall_menu);
        return jMenu;
    }

    private JMenu create_menu_view() {
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"view.zoom"));
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"view.zoom.1"), 49);
        jMenuItem.setActionCommand("view.zoom.100");
        jMenuItem.addActionListener(this);
        jMenuItem.setIcon(WPTemplates.getIcon((String)"small/zoom-original.png"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_zoom_menu = new JRadioButton[this.m_zoom_level.length];
        for (int i = 0; i < this.m_zoom_level.length; ++i) {
            this.m_zoom_menu[i] = new JRadioButton(WPTemplates.tr((String)this.m_zoom_command[i]));
            this.m_zoom_menu[i].setActionCommand(this.m_zoom_command[i]);
            this.m_zoom_menu[i].addActionListener(this);
            jMenu.add(this.m_zoom_menu[i]);
            buttonGroup.add(this.m_zoom_menu[i]);
            if (!this.m_zoom_command[i].equals("view.zoom.100")) continue;
            this.m_zoom_menu[i].setSelected(true);
        }
        JMenu jMenu2 = new JMenu(WPTemplates.tr((String)"View"));
        this.m_view_preview.addTo(jMenu2);
        jMenu2.addSeparator();
        this.m_view_grid.addTo(jMenu2);
        this.m_view_snap_to_grid.addTo(jMenu2);
        this.m_view_rulers.addTo(jMenu2);
        this.m_view_crop_outside.addTo(jMenu2);
        jMenu2.addSeparator();
        jMenu2.add(jMenu);
        jMenu2.addSeparator();
        this.m_view_layers.addTo(jMenu2);
        this.m_view_placeholders.addTo(jMenu2);
        this.m_view_helpers.addTo(jMenu2);
        return jMenu2;
    }

    private JMenu create_menu_help() {
        JMenuItem jMenuItem = new JMenuItem(WPTemplates.tr((String)"help.about"), 112);
        jMenuItem.setActionCommand("help.about");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        JMenu jMenu = new JMenu(WPTemplates.tr((String)"Help"));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JToolBar create_toolbar() {
        JToolBar jToolBar = new JToolBar(WPTemplates.tr((String)"Toolbar"));
        jToolBar.setFloatable(false);
        MyToolButton myToolButton = null;
        myToolButton = new MyToolButton("file.new", "document-new.png");
        myToolButton.setVisible(!this.isEmbedded());
        jToolBar.add(myToolButton);
        myToolButton = new MyToolButton("file.open", "document-open.png");
        myToolButton.setVisible(!this.isEmbedded());
        jToolBar.add(myToolButton);
        this.m_file_save.addTo(jToolBar);
        jToolBar.addSeparator();
        this.m_edit_undo.addTo(jToolBar);
        this.m_edit_redo.addTo(jToolBar);
        jToolBar.addSeparator();
        this.m_edit_cut.addTo(jToolBar);
        this.m_edit_copy.addTo(jToolBar);
        this.m_edit_paste.addTo(jToolBar);
        this.m_edit_copy_format.addTo(jToolBar);
        jToolBar.addSeparator();
        this.m_edit_delete.addTo(jToolBar);
        jToolBar.addSeparator();
        this.m_view_preview.addTo(jToolBar);
        this.m_zoom_in = new MyToolButton("view.zoom.in", "zoom-in.png");
        jToolBar.add(this.m_zoom_in);
        this.m_zoom = new JComboBox();
        for (int i = 0; i < this.m_zoom_level.length; ++i) {
            this.m_zoom.addItem((int)(this.m_zoom_level[i] * 100.0f) + "%");
        }
        this.m_zoom.setSelectedItem("100%");
        this.m_zoom.addActionListener(this);
        this.m_zoom.setMaximumSize(new Dimension(100, Integer.MAX_VALUE));
        jToolBar.add(this.m_zoom);
        this.m_zoom_out = new MyToolButton("view.zoom.out", "zoom-out.png");
        jToolBar.add(this.m_zoom_out);
        this.m_zoom_orig = new MyToolButton("view.zoom.100", "zoom-original.png");
        jToolBar.add(this.m_zoom_orig);
        jToolBar.addSeparator();
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.m_app_prefs.getInt("editor.grid_size", 20), 5, 100, 1);
        this.m_grid_size = new JSpinner(spinnerNumberModel);
        this.m_grid_size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                WPTemplates.this._canvas.canvas().setGridSize(spinnerNumberModel.getNumber().intValue());
            }
        });
        this.m_grid_size.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        jToolBar.add(new JLabel(WPTemplates.tr((String)"view.grid") + ": "));
        jToolBar.add(this.m_grid_size);
        myToolButton = new MyToolButton("file.properties", "document-properties.png");
        jToolBar.add(myToolButton);
        jToolBar.add(Box.createHorizontalGlue());
        this.m_view_layers.addTo(jToolBar);
        this.m_view_placeholders.addTo(jToolBar);
        this.m_view_helpers.addTo(jToolBar);
        return jToolBar;
    }

    private JToolBar create_tools_toolbar() {
        MyToggleAction myToggleAction;
        JToolBar jToolBar = new JToolBar(WPTemplates.tr((String)"Tools"), 1);
        jToolBar.setFloatable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_tool_select = myToggleAction = new MyToggleAction("tool.select", "tool_select.png");
        this.m_tool_select.setSelected(true);
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.rect", "tool_rect.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.ellipse", "tool_ellipse.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.line", "tool_line.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.text", "tool_text.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.graphics", "tool_graphics.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.qr", "tool_qr.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        myToggleAction = new MyToggleAction("tool.timetable", "tool_timetable.png");
        myToggleAction.addTo(jToolBar);
        myToggleAction.addTo(buttonGroup);
        this._tools.add(myToggleAction);
        return jToolBar;
    }

    private JToolBar create_view_toolbar() {
        JToolBar jToolBar = new JToolBar(WPTemplates.tr((String)"View"), 1);
        jToolBar.setFloatable(false);
        this.m_view_grid.addTo(jToolBar);
        this.m_view_snap_to_grid.addTo(jToolBar);
        this.m_view_rulers.addTo(jToolBar);
        this.m_view_crop_outside.addTo(jToolBar);
        return jToolBar;
    }

    private Container create_content() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(true);
        this.m_properties = new PropertiesPanel(this);
        this._preview = new CanvasPreviewPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(WPTemplates.tr((String)"tab.preview"), this._preview);
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        jTabbedPane2.addTab(WPTemplates.tr((String)"tab.properties"), this.m_properties);
        this._canvas = new Canvas(this, this.template, this._preview);
        this._preview.setCanvas(this._canvas);
        this.v_split = new JSplitPane(0, jTabbedPane2, jTabbedPane);
        this.v_split.setOneTouchExpandable(true);
        this.v_split.setResizeWeight(1.0);
        this.v_split.setDividerLocation(this.m_app_prefs.getInt("main.vsplit.div", 100));
        this.h_split = new JSplitPane(1, this._canvas, this.v_split);
        this.h_split.setOneTouchExpandable(true);
        this.h_split.setResizeWeight(1.0);
        this.h_split.setDividerLocation(this.m_app_prefs.getInt("main.hsplit.div", 400));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(this.create_tools_toolbar());
        jPanel2.add(this.create_view_toolbar());
        jPanel.add((Component)this.create_toolbar(), "First");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.h_split, "Center");
        this.m_view_grid.setSelected(this.m_app_prefs.getBoolean("editor.grid", true));
        this._canvas.canvas().setGrid(this.m_view_grid.isSelected());
        this._canvas.canvas().setGridSize(((SpinnerNumberModel)this.m_grid_size.getModel()).getNumber().intValue());
        this.m_view_snap_to_grid.setSelected(this.m_app_prefs.getBoolean("editor.grid_snap", true));
        this.m_view_rulers.setSelected(this.m_app_prefs.getBoolean("editor.rulers", true));
        this._canvas.setRulers(this.m_view_rulers.isSelected());
        this._canvas.canvas().showLayers(this.m_view_layers.isSelected());
        this._canvas.canvas().showPlaceholders(this.m_view_placeholders.isSelected());
        this._canvas.canvas().showHelpers(this.m_view_helpers.isSelected());
        this.m_view_crop_outside.setSelected(this.m_app_prefs.getBoolean("edit.crop-outside", false));
        this._canvas.canvas().cropOutside(this.m_view_crop_outside.isSelected());
        this.template.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
        this.template.selectElement((TemplateElement)null);
        this.setSelectTool(true);
        this.update_gui();
        return jPanel;
    }

    public void showMousePos(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.m_status.setPosition(n + " x " + n2);
        } else {
            this.m_status.setPosition(null);
        }
        this._canvas.setTicks(n, n2);
    }

    public void showStatusMessage(String string, int n) {
        if (string == null) {
            this.m_status.setStatusMessage(WPTemplates.tr((String)"Ready"));
        } else {
            this.m_status.setStatusMessage(string);
            if (n >= 0) {
                Timer timer = new Timer(n * 1000, this);
                timer.setActionCommand("clear_status_message");
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    private void update_gui() {
        Object object = this.template.filename();
        if (object == null) {
            object = WPTemplates.tr((String)"[noname]");
        }
        if (this.template.isModified()) {
            object = "*" + (String)object;
        }
        this.setTitle((String)object + " [" + this.template.title() + "] [" + this.template.getWidth() + "x" + this.template.getHeight() + "] - WizePanel Template Editor");
    }

    private void update_zoom_buttons() {
        int n = this.m_zoom.getSelectedIndex();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (n == 0) {
            bl = true;
            bl2 = false;
            bl3 = true;
        } else if (n == this.m_zoom_level.length - 1) {
            bl = false;
            bl2 = true;
            bl3 = true;
        } else if (this.m_zoom_command[n].equals("view.zoom.100")) {
            bl = true;
            bl2 = true;
            bl3 = false;
        }
        this.m_zoom_in.setEnabled(bl);
        this.m_zoom_out.setEnabled(bl2);
        this.m_zoom_orig.setEnabled(bl3);
    }

    public void do_edit_props() {
        if (this.template.getSelectedElement() == null) {
            return;
        }
        System.err.println("WPTemplate.do_edit_props() disabled.");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length % 2 != 0) {
            System.err.println("Wrong number of parameters.");
            System.err.println("Try --template filename.zip.");
            System.exit(1);
        }
        File file = new File(".");
        try {
            System.out.println("CWD: " + file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("--template")) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--export")) {
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--save")) {
                string4 = stringArray[i + 1];
                continue;
            }
            System.err.println("Unknown parameter: \"" + stringArray[i] + "\"");
            System.exit(2);
        }
        final JFrame jFrame = new JFrame();
        WPTemplates wPTemplates = new WPTemplates(jFrame, false, WpSystemLocator.getLocator().getDefaultLanguage());
        jFrame.setContentPane((Container)((Object)wPTemplates));
        if (string2 == null) {
            string = null;
        } else {
            File file2 = new File(string2);
            string = !file2.isAbsolute() ? WP.getTemplateFilename((String)string2) : string2;
            if (!wPTemplates.open_template(new File(string))) {
                JOptionPane.showMessageDialog(null, WPTemplates.tr((String)ERR_FILE_OPEN, (String[])new String[]{wPTemplates.template.getLastError()}), WPTemplates.tr((String)"Error"), 0);
                System.exit(1);
            }
            if (string3 != null) {
                wPTemplates.template.writeToImage(string3, true);
            }
            if (string4 != null) {
                wPTemplates.template.writeTo(string4);
            }
        }
        if (string == null) {
            // empty if block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
    }

    public String chooseImage() throws Exception {
        if (this.m_img_dlg == null) {
            this.m_img_dlg = new MyFileChooser();
            this.m_img_dlg.setAcceptAllFileFilterUsed(false);
            this.m_img_dlg.addChoosableFileFilter(new AllImageFilter());
            this.m_img_dlg.setInsistOnExtension(true);
            this.m_img_dlg.setFileSelectionMode(0);
        }
        if (this.m_img_dlg.showOpenDialog(this.frame()) != 0) {
            return null;
        }
        return this.template.addImage(this.m_img_dlg.getSelectedFile().getAbsolutePath());
    }

    public void addToolListener(ToolListener toolListener) {
        this.m_tool_listeners.add(toolListener);
    }

    private void informToolListeners(String string) {
        for (ToolListener toolListener : this.m_tool_listeners) {
            toolListener.toolChanged(string);
        }
        if (this.m_tool_select.isSelected()) {
            this.m_properties.setElements(this.template.getSelectedElements());
        } else {
            this.m_properties.setElement(this._canvas.canvas().getNewElement());
        }
    }

    public void addSaveListener(ISaveListener iSaveListener) {
        this.m_save_listeners.add(iSaveListener);
    }

    private void informSaveListeners(boolean bl) {
        for (ISaveListener iSaveListener : this.m_save_listeners) {
            iSaveListener.saved(bl);
        }
    }

    public void addShouldSaveListener(ISaveListener iSaveListener) {
        this.should_save_listeners.add(iSaveListener);
    }

    private void informShouldSave(boolean bl) {
        for (ISaveListener iSaveListener : this.should_save_listeners) {
            iSaveListener.saved(bl);
        }
    }

    public void addOnExitListener(IQuitListener iQuitListener) {
        this.on_exit_listeners.add(iQuitListener);
    }

    private void informOnExitListener() {
        for (IQuitListener iQuitListener : this.on_exit_listeners) {
            iQuitListener.called();
        }
    }

    public void setSelectTool(boolean bl) {
        if (!bl) {
            for (MyToggleAction myToggleAction : this._tools) {
                if (!myToggleAction.isSelected()) continue;
                bl = !myToggleAction.isSnapped();
            }
        }
        if (bl) {
            this.informToolListeners("tool.select");
        }
    }

    @Override
    public void toolChanged(String string) {
        int n;
        if (string.equals("tool.select")) {
            this.m_tool_select.setSelected(true);
        }
        this.m_edit_copy_format.setEnabled((n = this.template.getSelectedElements().size()) == 1 && this.isSelectTool() && this.template.getSelectedElement().canCopyAttributes());
        if (!this.m_edit_copy_format.isEnabled()) {
            this.m_edit_copy_format.setSelected(false);
        }
    }

    public void addTemplateListener(TemplateListener templateListener) {
        this.template.addTemplateListener(templateListener);
    }

    public void removeTemplateListener(TemplateListener templateListener) {
        this.template.removeTemplateListener(templateListener);
    }

    public void elementMovedResized(TemplateElement templateElement, MouseHandle mouseHandle, int n, int n2, boolean bl) {
        this.m_undo_stack.push(new MoveResizeCommand(templateElement, mouseHandle, n, n2, false), bl);
        this.template.setModified(true);
    }

    public void elementsMoved(MoveResizeCommand moveResizeCommand, boolean bl) {
        this.m_undo_stack.push(moveResizeCommand, bl);
        this.template.setModified(true);
    }

    public void elementResized(TemplateElement templateElement, int n, int n2) {
        this.m_undo_stack.push(new ResizeCommand(templateElement, n, n2), false);
        this.template.setModified(true);
    }

    public void elementModified(TemplateElement templateElement, String string, String string2, boolean bl) {
        this.m_undo_stack.push(new ModifyCommand(templateElement, string, string2), bl);
        this.template.setModified(true);
    }

    public void elementsDeleted(List<TemplateElement> list) {
        DeleteCommand deleteCommand = new DeleteCommand(this.template, null);
        for (TemplateElement templateElement : list) {
            deleteCommand.addChild(new DeleteCommand(this.template, templateElement));
        }
        this.m_undo_stack.push(deleteCommand, false);
        this.template.setModified(true);
    }

    public void elementAdded(Template template, TemplateElement templateElement) {
        this.m_undo_stack.push(new AddCommand(template, templateElement), false);
        this.template.setModified(true);
    }

    public void elementsAdded(List<TemplateElement> list) {
        AddCommand addCommand = new AddCommand(this.template, null);
        for (TemplateElement templateElement : list) {
            addCommand.addChild(new AddCommand(this.template, templateElement));
        }
        this.m_undo_stack.push(addCommand, false);
        this.template.setModified(true);
    }

    public void elementsLayersChanged(HashMap<Integer, TemplateElement> hashMap) {
        if (!hashMap.equals(this.template.getLayers())) {
            this.m_undo_stack.push(new LayerCommand(this.template, hashMap), false);
            this.template.setModified(true);
        }
    }

    public void elementsAligned(MoveResizeCommand moveResizeCommand) {
        this.m_undo_stack.push(moveResizeCommand, false);
        this.template.setModified(true);
    }

    public void do_edit_undo() {
        if (this.m_undo_stack.canUndo()) {
            this.m_edit_copy_format.setSelected(false);
            this.m_undo_stack.undo();
            this.template.setModified(true);
        }
    }

    public void do_edit_redo() {
        if (this.m_undo_stack.canRedo()) {
            this.m_edit_copy_format.setSelected(false);
            this.m_undo_stack.redo();
            this.template.setModified(true);
        }
    }

    public void do_edit_cut() {
        this.do_edit_copy();
        this.do_edit_delete();
    }

    public void setUndoEnabled(boolean bl) {
        this.m_undo_stack.setEnabled(bl);
    }

    public void do_edit_copy() {
        LinkedList linkedList = this.template.getSelectedElements();
        if (linkedList.size() == 0) {
            return;
        }
        this.m_elements_clipboard.clear();
        for (TemplateElement templateElement : linkedList) {
            TemplateElement templateElement2 = this.template.cloneElement(templateElement);
            this.m_elements_clipboard.add(templateElement2);
        }
        this.m_edit_paste.setEnabled(true);
    }

    public void do_edit_copy_format() {
        TemplateElement templateElement = this.template.getSelectedElement();
        if (templateElement == null) {
            return;
        }
        this.copy_format_source = templateElement;
    }

    public void do_edit_paste(boolean bl) {
        if (this.m_elements_clipboard.isEmpty()) {
            return;
        }
        Point point = new Point(10, 10);
        if (bl) {
            TemplateElement templateElement = this.m_elements_clipboard.get(this.m_elements_clipboard.size() - 1);
            Point point2 = this._canvas.canvas().getMouseClickPosition();
            point.setLocation(point2.getX() - (double)templateElement.getX(), point2.getY() - (double)templateElement.getY());
        }
        this.template.addElements(this.m_elements_clipboard, point, true);
    }

    public void do_edit_layer(String string) {
        if (this.template.getSelectedElements().size() == 0) {
            return;
        }
        System.err.println("WPTemplates.do_edit_layer()");
        if (string.equals("edit.layer.top")) {
            this.template.layerTop();
        } else if (string.equals("edit.layer.up")) {
            this.template.layerUp();
        } else if (string.equals("edit.layer.down")) {
            this.template.layerDown();
        } else if (string.equals("edit.layer.bottom")) {
            this.template.layerBottom();
        }
    }

    public void do_edit_alignment(String string) {
        LinkedList linkedList = this.template.getSelectedElements();
        if (linkedList.size() < 2) {
            return;
        }
        MoveResizeCommand moveResizeCommand = new MoveResizeCommand();
        TemplateElement templateElement = (TemplateElement)linkedList.get(linkedList.size() - 1);
        for (int i = 0; i < linkedList.size() - 1; ++i) {
            TemplateElement templateElement2 = (TemplateElement)linkedList.get(i);
            MouseHandle mouseHandle = templateElement2.getAnchorHandle();
            int n = mouseHandle.getX();
            int n2 = mouseHandle.getY();
            int n3 = templateElement2.getX();
            int n4 = templateElement2.getY();
            if (string.equals("edit.align.left")) {
                n3 = templateElement.getX();
            } else if (string.equals("edit.align.top")) {
                n4 = templateElement.getY();
            } else if (string.equals("edit.align.right")) {
                n3 = templateElement.getX() + templateElement.getWidth() - templateElement2.getWidth();
            } else if (string.equals("edit.align.bottom")) {
                n4 = templateElement.getY() + templateElement.getHeight() - templateElement2.getHeight();
            } else if (string.equals("edit.align.hcenter")) {
                n3 = templateElement.getX() + templateElement.getWidth() / 2 - templateElement2.getWidth() / 2;
            } else if (string.equals("edit.align.vcenter")) {
                n4 = templateElement.getY() + templateElement.getHeight() / 2 - templateElement2.getHeight() / 2;
            }
            templateElement2.setPosition(n3, n4);
            moveResizeCommand.addChild(new MoveResizeCommand(templateElement2, templateElement2.getAnchorHandle(), n, n2, true));
        }
        this.elementsAligned(moveResizeCommand);
    }

    public void do_edit_delete() {
        LinkedList linkedList = this.template.getSelectedElements();
        if (linkedList.isEmpty()) {
            return;
        }
        this.template.removeElements(linkedList, true);
    }

    public void do_edit_select_all() {
        this.template.selectAll();
    }

    public void do_edit_lock() {
        LinkedList linkedList = this.template.getSelectedElements();
        if (linkedList.size() == 0) {
            return;
        }
        boolean bl = !((TemplateElement)linkedList.get(0)).isMoveable();
        for (TemplateElement templateElement : linkedList) {
            templateElement.setMoveable(bl);
        }
        this.template.setModified(true);
        this.template.informTemplateListeners(TemplateListener.TemplateEvent.MODIFIED);
        if (linkedList.size() == 1) {
            this.m_properties.setElement((TemplateElement)linkedList.get(0));
        } else {
            this.m_properties.setElements(linkedList);
        }
    }

    public boolean isSelectTool() {
        return this.m_tool_select.isSelected();
    }

    public boolean isCopyFormatTool() {
        return this.m_edit_copy_format.isSelected() || this.m_edit_copy_format.isSnapped();
    }

    public boolean snapToGrid() {
        return this.m_view_snap_to_grid.isSelected();
    }

    public boolean canPaste() {
        return this.m_edit_paste.isEnabled();
    }

    private void update_undo() {
        this.m_edit_undo.setEnabled(this.m_undo_stack.canUndo());
        this.m_edit_redo.setEnabled(this.m_undo_stack.canRedo());
        if (this.m_tool_select.isSelected()) {
            // empty if block
        }
        this.update_gui();
    }

    public void setTemplateSettingsDialog(ITemplateSettings iTemplateSettings) {
        this._tpl_settings = iTemplateSettings;
    }

    public void setFontList(String[] stringArray) {
        this.fonts = stringArray;
    }

    public String[] fonts() {
        return this.fonts;
    }

    public void setDefaultLayout() {
        this.h_split.setDividerLocation(0.8f);
        this.v_split.setDividerLocation(0.8f);
    }

    public void templateModified(Template template, TemplateListener.TemplateEvent templateEvent) {
        this.m_file_save.setEnabled(template.isModified());
        switch (templateEvent) {
            case NEW_SELECTED: {
                int n;
                TemplateElement templateElement = template.getSelectedElement();
                if (templateElement != null && this.isCopyFormatTool() && !this.copy_format_source.name().equals(templateElement.name())) {
                    n = 0;
                    for (String string : this.copy_format_source.attributesToCopy()) {
                        String string2;
                        String string3 = this.copy_format_source.getAttribute(string);
                        if (string3.equals(string2 = templateElement.getAttribute(string)) || !templateElement.setAttribute(string, string3)) continue;
                        this.m_undo_stack.push(new ModifyCommand(templateElement, string, string2), false);
                        n = 1;
                    }
                    if (n != 0) {
                        this.template.setModified(true);
                    }
                    if (!this.m_edit_copy_format.isSnapped()) {
                        this.m_edit_copy_format.setSelected(false);
                        this.informToolListeners("tool.select");
                    }
                }
            }
            case MODIFIED: {
                int n = template.getSelectedElements().size();
                this.m_edit_cut.setEnabled(n > 0);
                this.m_edit_copy.setEnabled(n > 0);
                this.m_edit_delete.setEnabled(n > 0);
                if (!this.m_edit_copy_format.isEnabled() || this.m_edit_copy_format.isEnabled() && !this.m_edit_copy_format.isSelected()) {
                    this.m_edit_copy_format.setEnabled(n == 1 && this.isSelectTool() && template.getSelectedElement().canCopyAttributes());
                }
                if (this.m_alignment_menu != null) {
                    this.m_alignment_menu.setEnabled(n > 1);
                    this.m_layer_menu.setEnabled(n > 0);
                }
                this.m_lock_all.setEnabled(n > 0);
                if (this.m_lock_all.isEnabled()) {
                    this.m_lock_all.setSelected(!this.template.getReferenceElement().isMoveable());
                }
                if (this.m_tool_select.isSelected()) {
                    this.m_properties.setElements(template.getSelectedElements());
                }
                this.update_undo();
                this.update_gui();
                this._preview.setImage(this.template.exportToImage(false));
                break;
            }
            case NEW_TEMPLATE: {
                this._preview.setImage(this.template.exportToImage(false));
                break;
            }
            case SAVED: {
                break;
            }
        }
    }

    private class MyAction
    implements ActionListener {
        private JMenuItem m_menu_item;
        private JButton m_tool_item;

        public MyAction(String string, String string2, int n) {
            this.m_menu_item = new JMenuItem(WPApp.tr((String)string), n);
            this.m_menu_item.setActionCommand(string);
            this.m_menu_item.addActionListener(this);
            this.m_menu_item.setIcon(WPApp.getFactoryIcon((String)("small/" + string2)));
            this.m_tool_item = new JButton();
            this.m_tool_item.setActionCommand(string);
            this.m_tool_item.addActionListener(this);
            this.m_tool_item.setToolTipText(WPApp.tr((String)string));
            this.m_tool_item.setIcon(WPApp.getFactoryIcon((String)("small/" + string2)));
            this.m_tool_item.setFocusable(false);
        }

        public void addTo(JMenu jMenu) {
            jMenu.add(this.m_menu_item);
        }

        public void addTo(JToolBar jToolBar) {
            jToolBar.add(this.m_tool_item);
        }

        public void setEnabled(boolean bl) {
            this.m_menu_item.setEnabled(bl);
            this.m_tool_item.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.m_menu_item.isEnabled();
        }

        public void setAccelerator(KeyStroke keyStroke) {
            this.m_menu_item.setAccelerator(keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.m_menu_item) {
                this.m_tool_item.setSelected(this.m_menu_item.isSelected());
            } else {
                this.m_menu_item.setSelected(this.m_tool_item.isSelected());
            }
            WPTemplates.this.actionPerformed(actionEvent);
        }

        public boolean equals(Object object) {
            return object == this.m_menu_item || object == this.m_tool_item;
        }
    }

    private class MyToolButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public MyToolButton(String string, String string2) {
            this.setActionCommand(string);
            this.setIcon(WPApp.getFactoryIcon((String)("small/" + string2)));
            this.setToolTipText(WPApp.tr((String)string));
            this.addActionListener(WPTemplates.this);
            this.setFocusable(false);
        }
    }

    private class MyToggleAction
    implements ActionListener {
        private JCheckBoxMenuItem m_menu_item;
        private JToggleButton m_tool_item;
        private boolean m_snapped = false;

        public MyToggleAction(String string, String string2) {
            this.do_create(string);
            this.m_tool_item.setIcon(WPApp.getIcon((String)string2));
        }

        public MyToggleAction(String string) {
            this.do_create(string);
            this.m_tool_item.setText(WPApp.tr((String)string));
        }

        public boolean isSnapped() {
            return this.m_snapped;
        }

        private void do_create(String string) {
            this.m_menu_item = new JCheckBoxMenuItem(WPApp.tr((String)string));
            this.m_menu_item.setActionCommand(string);
            this.m_menu_item.addActionListener(this);
            this.m_tool_item = new JToggleButton();
            this.m_tool_item.setActionCommand(string);
            this.m_tool_item.addActionListener(this);
            this.m_tool_item.setToolTipText(WPApp.tr((String)string));
            this.m_tool_item.setFocusable(false);
            this.m_tool_item.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    super.mouseClicked(mouseEvent);
                    boolean bl = MyToggleAction.this.m_snapped = mouseEvent.getClickCount() >= 2;
                    if (MyToggleAction.this.m_snapped) {
                        MyToggleAction.this.m_menu_item.setSelected(true);
                        MyToggleAction.this.m_tool_item.setSelected(true);
                    }
                }
            });
        }

        public void addTo(JMenu jMenu) {
            jMenu.add(this.m_menu_item);
        }

        public void addTo(JToolBar jToolBar) {
            jToolBar.add(this.m_tool_item);
        }

        public void addTo(ButtonGroup buttonGroup) {
            buttonGroup.add(this.m_tool_item);
        }

        public void setSelected(boolean bl) {
            if (!bl) {
                this.m_snapped = false;
            }
            this.m_menu_item.setSelected(bl);
            this.m_tool_item.setSelected(bl);
        }

        public boolean isSelected() {
            return this.m_tool_item.isSelected();
        }

        public void setEnabled(boolean bl) {
            this.m_menu_item.setEnabled(bl);
            this.m_tool_item.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.m_menu_item.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.m_menu_item) {
                this.m_tool_item.setSelected(this.m_menu_item.isSelected());
            } else {
                this.m_menu_item.setSelected(this.m_tool_item.isSelected());
            }
            WPTemplates.this.actionPerformed(actionEvent);
        }
    }
}

