/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.canvas;

import de.wilke.wizepanel.templateeditor.WPTemplates;
import de.wilke.wizepanel.templateeditor.canvas.CanvasPanel;
import de.wilke.wizepanel.templateeditor.canvas.CanvasPreviewPanel;
import de.wilke.wizepanel.templateeditor.canvas.CanvasRuler;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.TemplateListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class Canvas
extends JScrollPane
implements TemplateListener,
AdjustmentListener,
MouseWheelListener {
    private static final long serialVersionUID = 0L;
    private final WPTemplates app;
    private CanvasPreviewPanel m_preview;
    private CanvasPanel m_canvas;
    private CanvasRuler m_ver_ruler;
    private CanvasRuler m_hor_ruler;
    private boolean with_rulers = false;
    private float m_scale = 1.0f;
    private int m_x_max_pos = 0;
    private float m_x_rel_pos;
    private int m_y_max_pos = 0;
    private float m_y_rel_pos;
    private final MouseWheelListener m_orig_wheel_listener;

    public Canvas(WPTemplates wPTemplates, Template template, CanvasPreviewPanel canvasPreviewPanel) {
        this.app = wPTemplates;
        this.m_preview = canvasPreviewPanel;
        this.setMinimumSize(new Dimension(320, 240));
        template.addTemplateListener((TemplateListener)this);
        this.m_canvas = new CanvasPanel(wPTemplates, template);
        wPTemplates.addToolListener(this.m_canvas);
        this.m_ver_ruler = new CanvasRuler(CanvasRuler.Orientation.VERTICAL);
        this.m_hor_ruler = new CanvasRuler(CanvasRuler.Orientation.HORIZONTAL);
        this.setViewportView(this.m_canvas);
        this.setWheelScrollingEnabled(false);
        MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
        this.m_orig_wheel_listener = mouseWheelListenerArray != null && mouseWheelListenerArray.length == 1 ? mouseWheelListenerArray[0] : null;
        this.addMouseWheelListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
        this.getVerticalScrollBar().addAdjustmentListener(this);
        this.setScale(this.m_scale);
    }

    public void setTicks(int n, int n2) {
        this.m_hor_ruler.setTickPosition(n);
        this.m_ver_ruler.setTickPosition(n2);
    }

    public void setRulers(boolean bl) {
        if (this.with_rulers == bl) {
            return;
        }
        this.with_rulers = bl;
        if (bl) {
            this.setColumnHeaderView(this.m_hor_ruler);
            this.setRowHeaderView(this.m_ver_ruler);
        } else {
            this.setColumnHeaderView(null);
            this.setRowHeaderView(null);
        }
    }

    public void setScale(float f) {
        this.m_scale = f;
        JScrollBar jScrollBar = this.getHorizontalScrollBar();
        this.m_x_max_pos = jScrollBar.getMaximum();
        this.m_x_rel_pos = (float)jScrollBar.getValue() / (float)(this.m_x_max_pos - jScrollBar.getVisibleAmount());
        jScrollBar = this.getVerticalScrollBar();
        this.m_y_max_pos = jScrollBar.getMaximum();
        this.m_y_rel_pos = (float)jScrollBar.getValue() / (float)(this.m_y_max_pos - jScrollBar.getVisibleAmount());
        this.m_ver_ruler.setScale(f);
        this.m_hor_ruler.setScale(f);
        this.m_canvas.setScale(f);
        this.m_preview.setScale(f);
        int n = 1;
        if (f > 0.999f) {
            n = (int)(f * 10.0f);
        }
        this.getHorizontalScrollBar().setUnitIncrement(n);
        this.getVerticalScrollBar().setUnitIncrement(n);
        this.m_hor_ruler.setPreferredWidth(this.m_canvas.getWidth());
        this.m_ver_ruler.setPreferredHeight(this.m_canvas.getHeight());
    }

    public CanvasPanel canvas() {
        return this.m_canvas;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!adjustmentEvent.getValueIsAdjusting()) {
            JScrollBar jScrollBar = this.getHorizontalScrollBar();
            if (jScrollBar.getMaximum() != this.m_x_max_pos) {
                this.m_x_max_pos = jScrollBar.getMaximum();
                jScrollBar.setValue((int)(this.m_x_rel_pos * (float)(this.m_x_max_pos - jScrollBar.getVisibleAmount())));
                jScrollBar = this.getVerticalScrollBar();
                this.m_y_max_pos = jScrollBar.getMaximum();
                jScrollBar.setValue((int)(this.m_y_rel_pos * (float)(this.m_y_max_pos - jScrollBar.getVisibleAmount())));
            }
            this.update_preview();
        }
    }

    private void update_preview() {
        JScrollBar jScrollBar = this.getHorizontalScrollBar();
        JScrollBar jScrollBar2 = this.getVerticalScrollBar();
        Rectangle rectangle = this.getViewport().getVisibleRect();
        int n = (int)((float)jScrollBar.getValue() / this.m_scale - 100.0f);
        int n2 = (int)((float)jScrollBar2.getValue() / this.m_scale - 100.0f);
        int n3 = (int)((float)rectangle.width / this.m_scale);
        int n4 = (int)((float)rectangle.height / this.m_scale);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        this.m_preview.setSelectionRectangle(rectangle2);
    }

    public void setPreviewCenter(int n, int n2) {
        Point point = this.m_canvas.convertTemplate2Canvas(new Point(n, n2));
        Rectangle rectangle = this.getViewport().getBounds();
        point.x -= rectangle.width / 2;
        point.y -= rectangle.height / 2;
        rectangle.setLocation(point);
        this.m_canvas.scrollRectToVisible(new Rectangle(rectangle));
    }

    public Rectangle getCanvasRectangle() {
        int n = (int)((float)this.getHorizontalScrollBar().getValue() / this.m_scale);
        int n2 = (int)((float)this.getVerticalScrollBar().getValue() / this.m_scale);
        int n3 = (int)(this.getViewportBorderBounds().getWidth() / (double)this.m_scale + (double)n);
        int n4 = (int)(this.getViewportBorderBounds().getHeight() / (double)this.m_scale + (double)n2);
        n2 -= 100;
        n3 -= 100;
        n4 -= 100;
        if ((n -= 100) < 0) {
            n = 0;
        }
        if (n3 > this.app.template.getWidth()) {
            n3 = this.app.template.getWidth();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > this.app.template.getHeight()) {
            n4 = this.app.template.getHeight();
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public Point makePointVisible(Point point) {
        Rectangle rectangle = this.getCanvasRectangle();
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        return point;
    }

    public void templateModified(Template template, TemplateListener.TemplateEvent templateEvent) {
        switch (templateEvent) {
            case NEW_TEMPLATE: {
                this.setScale(this.m_scale);
                return;
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.isControlDown()) {
            if (mouseWheelEvent.getUnitsToScroll() < 0) {
                this.app.doZoomIn();
            } else {
                this.app.doZoomOut();
            }
            mouseWheelEvent.consume();
        } else if (this.m_orig_wheel_listener != null) {
            this.setWheelScrollingEnabled(true);
            this.m_orig_wheel_listener.mouseWheelMoved(mouseWheelEvent);
            this.setWheelScrollingEnabled(false);
        }
    }
}

