/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.undo;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.undo.UndoCommand;
import de.wilke.wizepanel.templates.elements.TemplateElement;

public class ModifyCommand
extends UndoCommand {
    private String m_attr_name;
    private String m_old_value;
    private String m_new_value;

    public ModifyCommand(TemplateElement templateElement, String string, String string2) {
        super(templateElement);
        this.m_attr_name = string;
        this.m_old_value = string2;
        this.m_new_value = templateElement.getAttribute(this.m_attr_name);
    }

    @Override
    protected void undoCommand() {
        this.m_elem.setAttribute(this.m_attr_name, this.m_old_value);
    }

    @Override
    protected void redoCommand() {
        this.m_elem.setAttribute(this.m_attr_name, this.m_new_value);
    }

    public String getAttributeName() {
        return this.m_attr_name;
    }

    public String getNewValue() {
        return this.m_new_value;
    }

    @Override
    protected String description() {
        return this.m_elem.name() + ": " + WPApp.tr((String)"undo.modify", (String[])new String[]{this.m_elem.type(), this.m_attr_name, this.m_old_value});
    }

    @Override
    protected boolean canSingleMerge(UndoCommand undoCommand) {
        ModifyCommand modifyCommand;
        if (this.m_elem != undoCommand.getElement()) {
            return false;
        }
        return undoCommand instanceof ModifyCommand && (modifyCommand = (ModifyCommand)undoCommand).getAttributeName().equals(this.m_attr_name);
    }

    @Override
    protected void doSingleMerge(UndoCommand undoCommand) {
        ModifyCommand modifyCommand = (ModifyCommand)undoCommand;
        this.m_new_value = modifyCommand.getNewValue();
    }
}

