/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.undo;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.undo.UndoCommand;
import de.wilke.wizepanel.templates.elements.TemplateElement;

public class ResizeCommand
extends UndoCommand {
    private int m_old_w;
    private int m_old_h;
    private int m_new_w;
    private int m_new_h;

    public ResizeCommand(TemplateElement templateElement, int n, int n2) {
        super(templateElement);
        this.m_old_w = n;
        this.m_old_h = n2;
        this.m_new_w = templateElement.getWidth();
        this.m_new_h = templateElement.getHeight();
    }

    @Override
    protected void undoCommand() {
        this.m_elem.setSize(this.m_old_w, this.m_old_h);
    }

    @Override
    protected void redoCommand() {
        this.m_elem.setSize(this.m_new_w, this.m_new_h);
    }

    @Override
    protected String description() {
        return WPApp.tr((String)"undo.resize", (String[])new String[]{this.m_elem.type(), Integer.toString(this.m_old_w), Integer.toString(this.m_old_h)});
    }

    @Override
    protected boolean canSingleMerge(UndoCommand undoCommand) {
        return false;
    }

    @Override
    protected void doSingleMerge(UndoCommand undoCommand) {
    }
}

