/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.undo;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.templateeditor.undo.MoveResizeCommand;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import java.util.Collection;
import java.util.HashMap;

public abstract class UndoCommand {
    protected TemplateElement m_elem;
    private HashMap<TemplateElement, UndoCommand> _children = null;

    public UndoCommand(TemplateElement templateElement) {
        this.m_elem = templateElement;
    }

    public TemplateElement getElement() {
        return this.m_elem;
    }

    public final boolean mergeWith(UndoCommand undoCommand) {
        if (this.canSingleMerge(undoCommand)) {
            this.doSingleMerge((MoveResizeCommand)undoCommand);
            return true;
        }
        if (this.canCompositeMerge(undoCommand.children())) {
            for (UndoCommand undoCommand2 : undoCommand.children()) {
                this._children.get(undoCommand2.getElement()).mergeWith(undoCommand2);
            }
            return true;
        }
        return false;
    }

    public final void undo() {
        if (this.m_elem != null) {
            this.undoCommand();
        }
        if (this._children != null) {
            for (UndoCommand undoCommand : this._children.values()) {
                undoCommand.undo();
            }
        }
    }

    public final void redo() {
        if (this.m_elem != null) {
            this.redoCommand();
        }
        if (this._children != null) {
            for (UndoCommand undoCommand : this._children.values()) {
                undoCommand.redo();
            }
        }
    }

    protected abstract void undoCommand();

    protected abstract void redoCommand();

    protected abstract String description();

    public String toString() {
        Object object = "";
        object = this.m_elem == null ? (String)object + "FIXME:COMPOSITE " : (String)object + WPApp.tr((String)this.m_elem.type()) + ":" + this.description();
        if (this._children != null) {
            boolean bl = true;
            object = (String)object + "[";
            for (UndoCommand undoCommand : this._children.values()) {
                if (!bl) {
                    object = (String)object + ",";
                }
                object = (String)object + undoCommand.description();
                bl = false;
            }
            object = (String)object + "]";
        }
        return object;
    }

    public void addChild(UndoCommand undoCommand) {
        if (this._children == null) {
            this._children = new HashMap();
        }
        this._children.put(undoCommand.getElement(), undoCommand);
    }

    public Collection<UndoCommand> children() {
        return this._children.values();
    }

    private final boolean canCompositeMerge(Collection<UndoCommand> collection) {
        if (this._children == null || collection == null || this._children.size() != collection.size()) {
            return false;
        }
        for (UndoCommand undoCommand : collection) {
            if (!this._children.containsKey(undoCommand.getElement())) {
                return false;
            }
            if (this._children.get(undoCommand.getElement()).canSingleMerge(undoCommand)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean canSingleMerge(UndoCommand var1);

    protected abstract void doSingleMerge(UndoCommand var1);
}

