/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templateeditor.undo;

import de.wilke.wizepanel.templateeditor.undo.UndoCommand;
import de.wilke.wizepanel.templates.Template;
import java.util.LinkedList;
import java.util.List;

public class UndoStack {
    private List<UndoCommand> m_stack = new LinkedList<UndoCommand>();
    private int m_head = 0;
    private final Template tpl;
    private boolean enabled = true;

    public UndoStack(Template template) {
        this.tpl = template;
    }

    public void clear() {
        this.m_head = 0;
        this.m_stack.clear();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void push(UndoCommand undoCommand, boolean bl) {
        UndoCommand undoCommand2;
        if (!this.enabled) {
            return;
        }
        if (this.m_head < this.m_stack.size()) {
            while (this.m_stack.size() != this.m_head) {
                this.m_stack.remove(this.m_head);
            }
        }
        if (bl && this.m_stack.size() != 0 && (undoCommand2 = this.m_stack.get(this.m_head - 1)).mergeWith(undoCommand)) {
            return;
        }
        this.m_stack.add(undoCommand);
        this.m_head = this.m_stack.size();
    }

    public boolean canUndo() {
        return this.m_head != 0;
    }

    public void undo() {
        if (this.m_head != 0) {
            --this.m_head;
            UndoCommand undoCommand = this.m_stack.get(this.m_head);
            undoCommand.undo();
            this.tpl.selectElement(undoCommand.getElement());
        }
    }

    public boolean canRedo() {
        return this.m_head < this.m_stack.size();
    }

    public void redo() {
        if (this.m_head < this.m_stack.size()) {
            UndoCommand undoCommand = this.m_stack.get(this.m_head);
            undoCommand.redo();
            this.tpl.selectElement(undoCommand.getElement());
            ++this.m_head;
        }
    }

    public void print_undo_stack() {
        System.out.println("UNDO STACK [head:" + this.m_head + "]");
        System.out.println("=====================");
        for (int i = 0; i < this.m_stack.size(); ++i) {
            if (i == this.m_head) {
                System.out.println(" -> ");
            }
            System.out.println("   + " + this.m_stack.get(i).toString());
        }
        if (this.m_head == this.m_stack.size()) {
            System.out.println(" -> ");
        }
        System.out.println("=====================");
    }
}

