/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.basic;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WizePanelFatalException;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.basic.CommProgress;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmDispDummy;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommProtocol {
    private static final boolean WP_TCP_WINDOW_CORRECTION_SUPPORT = true;
    private static final int COMM_PROTOCOL_SEND_BYTES_SLEEP_TIME_MS = 1000;
    public static final int PACKET_PAUSE = Integer.parseInt(System.getProperty("PACKET_PAUSE", "100"));
    private boolean sendAsUrgentData = false;
    private final boolean fast_mode;
    private final int packet_pause;
    private static final Logger m_logger = LogManager.getLogger(CommProtocol.class);
    private boolean abort = false;
    private CommProgress progress = null;

    public CommProtocol(boolean bl) {
        this.fast_mode = bl;
        this.packet_pause = bl ? 10 : PACKET_PAUSE;
    }

    public CommProtocol(CommProgress commProgress, boolean bl) {
        this(bl);
        this.progress = commProgress;
    }

    private boolean sendCommandComposite(String string, int n, CommSocketsOperations commSocketsOperations, ACommCommand aCommCommand) throws WizePanelExceptions {
        List<CommPacket> list = aCommCommand.buildPackets(this.fast_mode);
        int n2 = list.size() * aCommCommand.repeatPacket();
        if (this.progress != null) {
            this.progress.start(list.size());
        }
        for (int i = 0; i < list.size() && !this.abort; ++i) {
            if (this.progress != null) {
                this.progress.update(i + 1);
            }
            if (--n2 < 0) {
                throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_TOO_MANY_ERRORS, "Very bad connection. Maximum number of transmissions reached.");
            }
            if (this.packet_pause > 0) {
                try {
                    Thread.sleep(this.packet_pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n3 = 0;
            CommPacket commPacket = list.get(i);
            WizePanelExceptions wizePanelExceptions = null;
            if (aCommCommand.out != null) {
                aCommCommand.out.println(i + 1 + "/" + list.size());
            }
            CommHeader commHeader = commPacket.commandHeader();
            m_logger.info("SENDING cmd:{}({}) [{}/{}] to {}", (Object)commHeader.getCommandId(), (Object)aCommCommand.getCommandName(), (Object)(i + 1), (Object)list.size(), (Object)commHeader.getDestAddr());
            while (n3 < aCommCommand.repeatPacket() && !this.abort) {
                if (n3 != 0) {
                    m_logger.debug("Repeating packet #" + (i + 1));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (commSocketsOperations == null) {
                        this.sendPacket(commPacket, string, n, aCommCommand);
                    } else {
                        this.sendPacket(commPacket, commSocketsOperations, aCommCommand);
                    }
                    if (list.size() == i + 1) {
                        if (this.progress != null) {
                            this.progress.finished();
                        }
                        m_logger.info("Success");
                        return true;
                    }
                    wizePanelExceptions = null;
                    break;
                }
                catch (WizePanelFatalException wizePanelFatalException) {
                    m_logger.debug("SEND:ExceptionFatal", (Throwable)wizePanelFatalException);
                    throw wizePanelFatalException;
                }
                catch (WizePanelExceptions wizePanelExceptions2) {
                    m_logger.debug("SEND:Exception: " + commHeader.getDestAddr() + "(#" + (n3 + 1) + ")");
                    if (wizePanelExceptions2.getErrorCode() == WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_WRONG_PACKET_NUMBER) {
                        int n4 = aCommCommand.getResponseHeader().getExpectedSeqNumber();
                        m_logger.debug("SEND:Resend:" + n4);
                        if (n4 < aCommCommand.getFirstSequenceNumber()) {
                            throw new WizePanelFatalException(wizePanelExceptions2.getErrorCode(), wizePanelExceptions2.getErrorParams());
                        }
                        if (i != n4 - 1) {
                            i = n4 - 1;
                            wizePanelExceptions = null;
                            break;
                        }
                    }
                    ++n3;
                    wizePanelExceptions = wizePanelExceptions2;
                }
            }
            if (wizePanelExceptions == null) continue;
            m_logger.debug("SEND:Error: " + commHeader.getDestAddr());
            throw wizePanelExceptions;
        }
        return false;
    }

    public boolean sendCommand(String string, int n, ACommCommand aCommCommand) throws WizePanelExceptions {
        return this.sendCommandComposite(string, n, null, aCommCommand);
    }

    public boolean sendCommand(CommSocketsOperations commSocketsOperations, ACommCommand aCommCommand) throws WizePanelExceptions {
        return this.sendCommandComposite(null, 0, commSocketsOperations, aCommCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(CommPacket commPacket, String string, int n, ACommCommand aCommCommand) throws WizePanelExceptions {
        CommSocketsOperations commSocketsOperations = new CommSocketsOperations();
        try {
            if (commSocketsOperations.connectSocket(string, n)) {
                if (aCommCommand.mustForceTcpWindowCorrection()) {
                    this.sendDummyCommand(commSocketsOperations);
                }
                this.sendPacket(commPacket, commSocketsOperations, aCommCommand);
            }
        }
        finally {
            commSocketsOperations.disconnectSocket();
        }
    }

    private void sendPacket(CommPacket commPacket, CommSocketsOperations commSocketsOperations, ACommCommand aCommCommand) throws WizePanelExceptions {
        commSocketsOperations.sendMSG(commPacket);
        CommPacket commPacket2 = commSocketsOperations.receiveMSG(aCommCommand);
        this.parseResponse(commPacket2, aCommCommand);
    }

    private boolean parseResponse(CommPacket commPacket, ACommCommand aCommCommand) throws WizePanelExceptions {
        if (!aCommCommand.hasResponse()) {
            return true;
        }
        if (commPacket == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_NO_RESPONSE);
        }
        m_logger.debug("parseResponse: (" + commPacket.toHex() + ")");
        aCommCommand.parseResponse(commPacket.commandHeader(), commPacket.commandPayload());
        if (commPacket.commandHeader().getErrorCode() != 0) {
            m_logger.debug("RESPONSE: error: " + commPacket.commandHeader().getErrorCode() + " seq.nr: " + aCommCommand.getResponseHeader().getSeqNum());
            WizePanelExceptions.ErrorCodes errorCodes = WizePanelExceptions.getHardwareErrorCodesNameByNum((int)commPacket.commandHeader().getErrorCode());
            if (errorCodes.isFatal()) {
                throw new WizePanelFatalException(errorCodes, "");
            }
            throw new WizePanelExceptions(errorCodes, (String)(errorCodes == WizePanelExceptions.ErrorCodes.WP_COMM_UNKNOWN_ERROR_CODE ? "" + commPacket.commandHeader().getErrorCode() : ""));
        }
        return true;
    }

    public boolean isSendAsUrgentData() {
        return this.sendAsUrgentData;
    }

    public void setSendAsUrgentData(boolean bl) {
        this.sendAsUrgentData = bl;
    }

    public void sendDummyCommand(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        CommCmDispDummy commCmDispDummy = new CommCmDispDummy();
        List<CommPacket> list = commCmDispDummy.buildPackets(this.fast_mode);
        CommPacket commPacket = list.get(0);
        for (int i = 0; i < 3; ++i) {
            m_logger.debug("sending-dummy");
            this.pause(1000L);
            commSocketsOperations.sendMSG(commPacket);
            for (int j = 0; j < 2; ++j) {
                CommPacket commPacket2 = commSocketsOperations.receiveMSG(commCmDispDummy);
                if (this.parseResponse(commPacket2, commCmDispDummy)) {
                    m_logger.debug("dummy OK(" + j + ")");
                    return;
                }
                this.pause(1000L);
            }
        }
        throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, "dummy");
    }

    private void pause(long l) throws WizePanelExceptions {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, interruptedException.getMessage());
        }
    }

    public void abort() {
        this.abort = true;
    }
}

