/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.basic;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommSocketsOperations {
    private static final Logger m_logger = LogManager.getLogger(CommSocketsOperations.class);
    private static final int COMM_SOCKETS_DEFAULT_MAX_SEND_BUFFER_SIZE = 64;
    private static final int COMM_SOCKETS_DEFAULT_MAX_RECV_BUFFER_SIZE = 64;
    private int soTimeoutValue = 10000;
    private Socket socket = null;

    public CommSocketsOperations() {
        this.socket = null;
    }

    public CommSocketsOperations(Socket socket) {
        this.socket = socket;
    }

    public boolean connectSocket(String string, int n) throws WizePanelExceptions {
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(false);
            this.socket.setReuseAddress(true);
            this.socket.setKeepAlive(false);
            this.socket.setSoLinger(false, 0);
            this.socket.setSendBufferSize(64);
            this.socket.connect(new InetSocketAddress(string, n), this.soTimeoutValue);
        }
        catch (UnknownHostException unknownHostException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_UNKNOWN_HOST_EXCEPTION, unknownHostException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_ILLEGAL_ARGUMENT_EXCEPTION, illegalArgumentException.getMessage());
        }
        catch (SocketException socketException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_SOCKET_EXCEPTION, socketException.getMessage());
        }
        catch (IOException iOException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
        }
        return true;
    }

    public boolean disconnectSocket() throws WizePanelExceptions {
        try {
            if (this.socket != null && this.socket.isConnected()) {
                if (!this.socket.isInputShutdown()) {
                    this.socket.shutdownInput();
                }
                if (!this.socket.isOutputShutdown()) {
                    this.socket.shutdownOutput();
                }
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = null;
            }
            return true;
        }
        catch (IOException iOException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
        }
    }

    public void sendMSG(CommPacket commPacket) throws WizePanelExceptions {
        if (this.socket == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_SEND_TO_CLOSED_SOCKET);
        }
        if (commPacket.length() > 1024) {
            this.soTimeoutValue = commPacket.length() * 2;
        }
        try {
            this.socket.getOutputStream().write(commPacket.raw());
        }
        catch (IOException iOException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
        }
    }

    public void sendUrgentMSG(byte[] byArray) throws WizePanelExceptions {
        if (this.socket == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_SEND_TO_CLOSED_SOCKET);
        }
        for (int i = 0; i < byArray.length; ++i) {
            try {
                this.socket.sendUrgentData(byArray[i]);
                continue;
            }
            catch (IOException iOException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
            }
        }
    }

    public CommPacket receiveMSG(ACommCommand aCommCommand) throws WizePanelExceptions {
        if (this.socket == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_SEND_TO_CLOSED_SOCKET);
        }
        byte[] byArray = new byte[65535];
        byte[] byArray2 = new byte[220];
        int n = 220;
        int n2 = 0;
        CommPacket commPacket = new CommPacket();
        while (n2 < byArray.length) {
            try {
                this.socket.setSoTimeout(aCommCommand == null ? this.soTimeoutValue : aCommCommand.readTimeout());
                n = this.socket.getInputStream().read(byArray2);
                if (n == -1) break;
                for (int i = 0; i < n; ++i) {
                    byArray[n2 + i] = byArray2[i];
                }
                n2 += n;
                while (n2 != 0 && commPacket.parse(byArray, n2)) {
                    if (aCommCommand == null || commPacket.commandHeader().getCommandId() == aCommCommand.getId()) {
                        return commPacket;
                    }
                    m_logger.debug("UNEXPECTED COMMAND ID (expected: " + aCommCommand.getId() + " received: " + commPacket.commandHeader().getCommandId() + ")" + commPacket.toHex());
                    System.arraycopy(byArray, commPacket.length(), byArray, 0, n2 -= commPacket.length());
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_TIMEOUT_OCCURRED_KILLING_CONNECTION, interruptedIOException.getMessage());
            }
            catch (IOException iOException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
            }
        }
        return null;
    }

    public List<DatagramPacket> receiveUdpDatagrams(int n, int n2) throws SocketException {
        LinkedList<DatagramPacket> linkedList = new LinkedList<DatagramPacket>();
        try (DatagramSocket datagramSocket = new DatagramSocket(n);){
            long l = System.currentTimeMillis();
            while (l + (long)n2 >= System.currentTimeMillis()) {
                try {
                    DatagramPacket datagramPacket = new DatagramPacket(new byte[64], 64);
                    datagramSocket.setSoTimeout(1000);
                    datagramSocket.receive(datagramPacket);
                    linkedList.add(datagramPacket);
                }
                catch (Exception exception) {}
            }
        }
        return linkedList;
    }
}

