/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.basic;

import de.wilke.wizepanel.core.WizePanelExceptions;

public class CommValidator {
    public static byte[] parseIP(String string) throws WizePanelExceptions {
        byte[] byArray = new byte[4];
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_INCORRECT_IP_FORM);
        }
        for (int i = 0; i <= 3; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            if (n < 0 || n > 255) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_INCORRECT_IP_FORM);
            }
            byArray[3 - i] = (byte)n;
        }
        return byArray;
    }

    public static int parsePort(String string) throws WizePanelExceptions {
        int n = Integer.parseInt(string);
        if (n < 1 || n > 65535) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_INVALID_PORT_NUMBER);
        }
        return n;
    }

    public static long parseMac(String string) {
        long l = 0L;
        String[] stringArray = string.split("[^\\dabcdefABCDEF]");
        if (stringArray.length == 6) {
            for (int i = 0; i < stringArray.length; ++i) {
                l |= Long.parseLong(stringArray[i], 16) << i * 8;
            }
        }
        return l;
    }
}

