/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.WpNumberUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.LinkedList;
import java.util.List;

public class CommCmCancelTransactions
extends ACommCommand {
    private static final int COMMAND_ID = 56;
    private static final String COMMAND_NAME = "trans-cancel";
    private static final String COMMAND_DESC = "Cancel running commands - version 2.0+";
    private static final String COMMAND_HELP = "--command trans-cancel --ip 192.168.1.209 --port 8000 [--trans 0x12345678]\n            Cancel all (or transaction 0x12345678 only) command(s).";
    private static final String PARAM_TRANS_ID = "trans";
    private final List<Long> request_trans_ids = new LinkedList<Long>();
    private final List<Long> response_trans_ids = new LinkedList<Long>();

    public CommCmCancelTransactions() {
        super(56, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_TRANS_ID, CommCommandParams.Types.STRING, PARAM_TRANS_ID, "List of transaction ID (comma separated)", false);
    }

    @Override
    public CommCmCancelTransactions initializeCommandParams() {
        String[] stringArray;
        this.request_trans_ids.clear();
        this.response_trans_ids.clear();
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_TRANS_ID);
        if (commCommandParamValue != null && !commCommandParamValue.getStringParam().isEmpty() && (stringArray = commCommandParamValue.getStringParam().split(",")) != null && stringArray.length != 0) {
            for (String string : stringArray) {
                try {
                    this.request_trans_ids.add(WpNumberUtils.str2long(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(56).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public int getCommandParamsSize() {
        return this.request_trans_ids.size() * 4;
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        if (this.getCommandParamsSize() != 0) {
            OutputByteStream outputByteStream = new OutputByteStream(this.getCommandParamsSize());
            for (long l : this.request_trans_ids) {
                outputByteStream.put32bit(l);
            }
            for (int i = 0; i < outputByteStream.length(); ++i) {
                byArray[n + i] = outputByteStream.getData()[i];
            }
        }
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        if (byArray.length % 4 != 0) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        for (int i = 0; i < byArray.length / 4; ++i) {
            this.response_trans_ids.add(inputByteStream.get32bit());
        }
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.response_trans_ids.size() == 0) {
            stringBuilder.append("All transactions cancelled.");
        } else {
            stringBuilder.append("\nWARNING: Following transactions not found: ").append("\n");
            for (long l : this.response_trans_ids) {
                stringBuilder.append("   ").append(String.format("0x%08x", l)).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public void addTransaction(long l) {
        this.request_trans_ids.add(l);
    }

    @Override
    public String getCommandConfiguration() {
        return this.request_trans_ids.size() == 0 ? "ALL" : WpUtils.implode((String)" ", this.request_trans_ids);
    }

    @Override
    protected void importPayload(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || byArray.length % 4 != 0) {
            return;
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        while (inputByteStream.bytesAvailable() > 0) {
            this.request_trans_ids.add(inputByteStream.get32bit());
        }
    }

    public List<Long> getRequestTransactionIDs() {
        return this.request_trans_ids;
    }

    public int getTransactionsCancelled() {
        return this.request_trans_ids.size() - this.response_trans_ids.size();
    }
}

