/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.LinkedHashMap;

public class CommCmDispDebug
extends ACommCommand {
    private static final int COMMAND_ID = 255;
    private static final String COMMAND_NAME = "dispdebug";
    private static final String COMMAND_DESC = "Get dispatcher debug information";
    private static final String COMMAND_HELP = "--command dispdebug --ip 192.168.1.209 --port 8000 --code 0";
    private static final String PARAM_CODE = "code";
    private int ack = 0;
    private byte[] response = null;

    public CommCmDispDebug() {
        super(255, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_CODE, CommCommandParams.Types.INTEGER, PARAM_CODE, "Code", true);
        this.setAdminCommand(true);
    }

    @Override
    public CommCmDispDebug initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_CODE);
        if (commCommandParamValue != null) {
            this.ack = commCommandParamValue.getIntParam();
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(255).setDestAddr(0).setPackLen(this.getCommandParamsSize()).setActionCode(this.ack);
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        this.response = byArray;
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder.append("Data (length: ").append(this.response.length).append(")\n\nHEX:");
        for (int i = 0; i < this.response.length; ++i) {
            stringBuilder.append(" ").append(String.format("%02x", this.response[i]));
            if (this.response[i] >= 32 && this.response[i] <= 126) {
                stringBuilder3.append(" ").append((char)this.response[i]).append(" ");
                if (i != stringBuilder2.length()) continue;
                stringBuilder2.append((char)this.response[i]);
                continue;
            }
            stringBuilder3.append("   ");
        }
        stringBuilder.append("\n");
        stringBuilder.append("CHR:").append((CharSequence)stringBuilder3).append("\n");
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("STR: ").append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(PARAM_CODE, this.ack);
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

