/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.LinkedHashMap;

public class CommCmDispGetCommandResponse
extends ACommCommand {
    private static final int COMMAND_ID = 60;
    private static final String COMMAND_NAME = "trans-response";
    private static final String COMMAND_DESC = "Get command response";
    private static final String COMMAND_HELP = "--command trans-response --ip 192.168.1.209 --port 8000 --trans 0x00001100";
    private static final String PARAM_TRANS_ID = "trans";
    private static final String PARAM_DELETE = "delete";
    private long trans_id = -1L;
    private static final int ACK_DELETE = 255;
    private int ack = 0;
    private byte[] response = null;

    public CommCmDispGetCommandResponse() {
        super(60, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_TRANS_ID, CommCommandParams.Types.STRING, PARAM_TRANS_ID, "Transaction ID").addParam(PARAM_DELETE, CommCommandParams.Types.BOOLEAN, PARAM_DELETE, "Delete data", false);
    }

    @Override
    public CommCmDispGetCommandResponse initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_TRANS_ID);
        if (commCommandParamValue != null) {
            this.trans_id = Long.parseLong(commCommandParamValue.getStringParam().substring(2), 16);
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_DELETE)) != null) {
            this.ack = 255;
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(60).setDestAddr(0).setPackLen(this.getCommandParamsSize()).setActionCode(this.ack).setTransactionID(this.trans_id);
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        this.response = byArray;
    }

    @Override
    public String getResults() {
        if (this.ack == 255) {
            return "Deleted";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder.append("Data (length: ").append(this.response.length).append(")\n\nHEX:");
        for (int i = 0; i < this.response.length; ++i) {
            stringBuilder.append(" ").append(String.format("%02x", this.response[i]));
            if (this.response[i] >= 32 && this.response[i] <= 126) {
                stringBuilder3.append(" ").append((char)this.response[i]).append(" ");
                if (i != stringBuilder2.length()) continue;
                stringBuilder2.append((char)this.response[i]);
                continue;
            }
            stringBuilder3.append("   ");
        }
        stringBuilder.append("\n");
        stringBuilder.append("CHR:").append((CharSequence)stringBuilder3).append("\n");
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("STR: ").append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Number> linkedHashMap = new LinkedHashMap<String, Number>();
        linkedHashMap.put(PARAM_TRANS_ID, this.trans_id);
        if (this.ack == 255) {
            linkedHashMap.put(PARAM_DELETE, this.ack);
        }
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

