/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.lang.invoke.CallSite;
import java.util.LinkedList;

public class CommCmDispRestart
extends ACommCommand {
    private static final int COMMAND_ID = 44;
    private static final String COMMAND_NAME = "disp-restart";
    private static final String COMMAND_DESC = "Restarts the dispatcher";
    private static final String COMMAND_HELP = "--command disp-restart --ip 192.168.1.209 --port 8000\n            Restart Dispatcher\n              identified by the IP 192.168.1.209 and the port 8000.";
    private static final byte DISP_RESTART_PARAMS_SIZE = 0;
    private static final String PARAM_MODE = "mode";
    private Mode mode = Mode.ALL;

    public CommCmDispRestart() {
        super(44, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (Mode mode : Mode.values()) {
            linkedList.add((CallSite)((Object)(mode.ack + ": " + mode.name())));
        }
        this.commandDescr.addParam(PARAM_MODE, CommCommandParams.Types.INTEGER, PARAM_MODE, WpUtils.implode((String)", ", linkedList), false);
        this.setUDPAllowed(true);
    }

    @Override
    public ACommCommand initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_MODE);
        if (commCommandParamValue != null) {
            for (Mode mode : Mode.values()) {
                if (mode.ack != commCommandParamValue.getIntParam()) continue;
                this.mode = mode;
                break;
            }
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(44).setActionCode(this.mode.ack).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
    }

    @Override
    public String getResults() {
        Object object = "";
        object = (String)object + "Restart Command is sent to Dispatcher\n";
        return object;
    }

    @Override
    public String getCommandConfiguration() {
        return "mode=" + this.mode.name();
    }

    private static enum Mode {
        ALL(0),
        ETHERNET(1),
        RADIO(2);

        public final int ack;

        private Mode(int n2) {
            this.ack = n2;
        }
    }
}

