/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.lang.invoke.CallSite;
import java.util.LinkedList;

public class CommCmDispSetAudioVisualIdentify
extends ACommCommand {
    private static final int COMMAND_ID = 2;
    private static final String COMMAND_NAME = "disp-ident";
    private static final String COMMAND_DESC = "Set Audio/Visual Identifying of Dispatcher";
    private static final String COMMAND_HELP = "--command setdispident --ip 192.168.1.209 --port 8000 --mode 1\n            Sets Identifying Mode of the Dispatcher with the IP 192.168.1.209 and the port 8000 to Audio";
    private static final byte PARAMS_SIZE = 0;
    private static final String PARAM_NAME_MODE = "mode";
    private Mode mode = Mode.OFF;

    public CommCmDispSetAudioVisualIdentify() {
        super(2, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (Mode mode : Mode.values()) {
            linkedList.add((CallSite)((Object)(mode.ack + ": " + mode.name())));
        }
        this.commandDescr.addParam(PARAM_NAME_MODE, CommCommandParams.Types.INTEGER, PARAM_NAME_MODE, WpUtils.implode((String)" ", linkedList));
    }

    public CommCmDispSetAudioVisualIdentify(int n) {
        this();
        this.setCommandIdentifyMode(n);
    }

    @Override
    public CommCmDispSetAudioVisualIdentify initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_NAME_MODE);
        if (commCommandParamValue != null) {
            this.setCommandIdentifyMode(commCommandParamValue.getIntParam());
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(2).setActionCode(this.mode.ack).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
    }

    @Override
    public String getResults() {
        Object object = "";
        object = (String)object + "New Identify Mode is set\n";
        return object;
    }

    public int getCommandIdentifyMode() {
        return this.mode.ack;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setCommandIdentifyMode(int n) {
        for (Mode mode : Mode.values()) {
            if (mode.ack != n) continue;
            this.mode = mode;
            break;
        }
    }

    public static boolean isValidMode(int n) {
        for (Mode mode : Mode.values()) {
            if (mode.ack != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCommandConfiguration() {
        return this.mode.name();
    }

    public static enum Mode {
        OFF(0),
        AUDIO(1),
        VISUAL(2),
        AUDIOVISUAL(3);

        public final int ack;

        private Mode(int n2) {
            this.ack = n2;
        }
    }
}

