/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommValidator;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.LinkedHashMap;

public class CommCmDispSetIpSettings
extends ACommCommand {
    private static final int COMMAND_ID = 40;
    private static final String COMMAND_NAME = "disp-ip";
    private static final String COMMAND_DESC = "Set dispatcher IP and port";
    private static final String COMMAND_HELP = "--command disp-ip --ip 192.168.1.209 --port 8000 --newip 192.168.1.210 --newport 8001 --newsubnet 255.255.255.0 --newgateway 192.168.1.253\n            Sets IP Parameters of the Dispatcher with the IP 192.168.1.209 and the port 8000 to \n              New IP 192.168.1.210, New Port 8001, New Subnet 255.255.255.0, New Gateway 192.168.1.253";
    private static final byte DISP_SET_IP_SETTINGS_PARAMS_SIZE = 14;
    private static final String PARAM_NAME_NEW_IP = "newip";
    private static final String PARAM_NAME_NEW_PORT = "newport";
    private static final String PARAM_NAME_NEW_SUBNET = "newsubnet";
    private static final String PARAM_NAME_NEW_GATEWAY = "newgateway";
    private String newTargetIP;
    private int newTargetPort;
    private String newTargetSubnetMask;
    private String newTargetGateway;
    private String mac = null;

    public CommCmDispSetIpSettings() {
        super(40, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_NAME_NEW_IP, CommCommandParams.Types.STRING, PARAM_NAME_NEW_IP, "New IP of the Dispatcher.").addParam(PARAM_NAME_NEW_PORT, CommCommandParams.Types.INTEGER, PARAM_NAME_NEW_PORT, "New Port of the Dispatcher.").addParam(PARAM_NAME_NEW_SUBNET, CommCommandParams.Types.STRING, PARAM_NAME_NEW_SUBNET, "New Subnet Mask of the Dispatcher.").addParam(PARAM_NAME_NEW_GATEWAY, CommCommandParams.Types.STRING, PARAM_NAME_NEW_GATEWAY, "New Gateway of the Dispatcher.").addParam("mac", CommCommandParams.Types.STRING, "mac", "MAC of the Dispatcher.", false);
    }

    public CommCmDispSetIpSettings(String string, int n, String string2, String string3) {
        this();
        this.newTargetIP = string;
        this.newTargetPort = n;
        this.newTargetSubnetMask = string2;
        this.newTargetGateway = string3;
    }

    @Override
    public CommCmDispSetIpSettings initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_NAME_NEW_IP);
        if (commCommandParamValue != null) {
            this.newTargetIP = commCommandParamValue.getStringParam();
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_NEW_PORT)) != null) {
            this.newTargetPort = commCommandParamValue.getIntParam();
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_NEW_SUBNET)) != null) {
            this.newTargetSubnetMask = commCommandParamValue.getStringParam();
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_NEW_GATEWAY)) != null) {
            this.newTargetGateway = commCommandParamValue.getStringParam();
        }
        if ((commCommandParamValue = this.getNamedParamValue("mac")) != null) {
            this.mac = commCommandParamValue.getStringParam();
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 14;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(40).setDestAddr(0).setPackLen(this.getCommandParamsSize());
        if (this.mac != null && !this.mac.isEmpty()) {
            commHeader.setTransactionID(CommValidator.parseMac(this.mac));
        }
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        byte[] byArray2 = CommValidator.parseIP(this.newTargetIP);
        byte[] byArray3 = CommValidator.parseIP(this.newTargetSubnetMask);
        byte[] byArray4 = CommValidator.parseIP(this.newTargetGateway);
        System.arraycopy(byArray2, 0, byArray, n, 4);
        byArray[n + 4] = (byte)(this.newTargetPort & 0xFF);
        byArray[n + 5] = (byte)(this.newTargetPort >> 8 & 0xFF);
        System.arraycopy(byArray3, 0, byArray, n + 6, 4);
        System.arraycopy(byArray4, 0, byArray, n + 10, 4);
    }

    @Override
    public String getResults() {
        return "Ip Settings are updated";
    }

    public String getNewTargetIP() {
        return this.newTargetIP;
    }

    public CommCmDispSetIpSettings setNewTargetIP(String string) {
        this.newTargetIP = string;
        return this;
    }

    public int getNewTargetPort() {
        return this.newTargetPort;
    }

    public CommCmDispSetIpSettings setNewTargetPort(int n) {
        this.newTargetPort = n;
        return this;
    }

    public String getNewTargetSubnetMask() {
        return this.newTargetSubnetMask;
    }

    public CommCmDispSetIpSettings setNewTargetSubnetMask(String string) {
        this.newTargetSubnetMask = string;
        return this;
    }

    public String getNewTargetGateway() {
        return this.newTargetGateway;
    }

    public CommCmDispSetIpSettings setNewTargetGateway(String string) {
        this.newTargetGateway = string;
        return this;
    }

    @Override
    public boolean isUDPAllowed() {
        return true;
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("ip", this.newTargetIP);
        linkedHashMap.put("port", this.newTargetPort);
        linkedHashMap.put("subnet", this.newTargetSubnetMask);
        linkedHashMap.put("gateway", this.newTargetGateway);
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

