/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;

public class CommCmDispSetMaxWp
extends ACommCommand {
    private static final int COMMAND_ID = 63;
    private static final String COMMAND_NAME = "disp-maxwp";
    private static final String COMMAND_DESC = "Sets maximum number of WizePanels";
    private static final String COMMAND_HELP = "--command setmaxwp --ip 192.168.1.209 --port 8000 --wp 10\n\n\n--wp [0..255]";
    private static final String PARAM_WP = "wp";
    private int max_wp = 0;

    public CommCmDispSetMaxWp() {
        super(63, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_WP, CommCommandParams.Types.INTEGER, PARAM_WP, "[0..255]");
        this.setAdminCommand(true);
    }

    public CommCmDispSetMaxWp(int n) {
        this();
        this.max_wp = n;
    }

    @Override
    public CommCmDispSetMaxWp initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_WP);
        if (commCommandParamValue != null) {
            this.max_wp = commCommandParamValue.getIntParam();
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 2;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(63).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        OutputByteStream outputByteStream = new OutputByteStream(2);
        outputByteStream.put16bit(this.max_wp);
        for (int i = 0; i < outputByteStream.length(); ++i) {
            byArray[n + i] = outputByteStream.getData()[i];
        }
    }

    @Override
    public String getResults() {
        Object object = "";
        object = (String)object + "Settings are updated\n";
        return object;
    }
}

