/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;

public class CommCmDispUDPInfoSettings
extends ACommCommand {
    private static final int COMMAND_ID = 50;
    private static final String COMMAND_NAME = "disp-udp-info";
    private static final String COMMAND_DESC = "Enables/disables UDP info command - version 2.0+";
    private static final String COMMAND_HELP = "--command disp-udp-info --ip 192.168.1.209 --port 8000\n";
    private static final String PARAM_ON = "on";
    private static final String PARAM_OFF = "off";
    private static final int ACTION_CODE_OFF = 0;
    private static final int ACTION_CODE_ON = 1;
    private int action_code = -1;

    public CommCmDispUDPInfoSettings() {
        super(50, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_ON, CommCommandParams.Types.BOOLEAN, PARAM_ON, "Enable", false);
        this.commandDescr.addParam(PARAM_OFF, CommCommandParams.Types.BOOLEAN, PARAM_OFF, "Disable", false);
        this.setUDPAllowed(true);
    }

    @Override
    public ACommCommand initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_ON);
        if (commCommandParamValue != null && commCommandParamValue.getBooleanParam()) {
            this.action_code = 1;
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_OFF)) != null && commCommandParamValue.getBooleanParam()) {
            this.action_code = 0;
        }
        return this;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(50).setActionCode(this.action_code).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public int getCommandParamsSize() {
        return 0;
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        if (this.action_code == -1) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_NO_ARGS, "Need at least --on or --off");
        }
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
    }

    @Override
    public String getResults() {
        return "Transmitted to dispatcher";
    }

    @Override
    public String getCommandConfiguration() {
        return this.action_code == 1 ? PARAM_ON : PARAM_OFF;
    }
}

