/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.types.UDPInfo;
import de.wilke.wizepanel.prot.data.DispatcherItemType;

public class CommCmSysGetDispatchers
extends ACommCommand {
    private static final int COMMAND_ID = 0;
    private static final String COMMAND_NAME = "getdispatchers";
    private static final String COMMAND_DESC = "Get list of available dispatchers";
    private static final String COMMAND_HELP = "--command getdispatchers --port 8000\n            Get List of available Dispatchers\n              found by UDP listening on the port 8000.";
    private DispatcherItemType dispatcher = null;
    private UDPInfo info = null;

    public CommCmSysGetDispatchers() {
        super(0, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.setAdminCommand(true);
    }

    public CommCmSysGetDispatchers(UDPInfo uDPInfo) {
        this();
        this.info = uDPInfo;
    }

    @Override
    public CommCmSysGetDispatchers initializeCommandParams() {
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        if (this.info == null) {
            return 0;
        }
        return this.info.length();
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(0).setDestAddr(0).setPackLen(this.getCommandParamsSize());
        if (this.info != null) {
            commHeader.setHostIP(this.info.ip());
            commHeader.setHostPort(this.info.port());
        }
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        System.arraycopy(this.info.rawBytes(), 0, byArray, n, this.info.length());
    }

    @Override
    protected void parseResponse(byte[] byArray) throws WizePanelExceptions {
        this.dispatcher = this.parseResponseData(this.getResponseHeader().getHostIP(), this.getResponseHeader().getHostPort(), byArray);
        if (this.dispatcher != null) {
            return;
        }
        throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
    }

    @Override
    public String getResults() {
        if (this.dispatcher != null) {
            return this.dispatcher.toStringCR();
        }
        return "";
    }

    private DispatcherItemType parseResponseData(int n, int n2, byte[] byArray) {
        UDPInfo uDPInfo = new UDPInfo(n, n2, byArray);
        return new DispatcherItemType(uDPInfo.ipAsString(), n2, uDPInfo.subnet(), uDPInfo.gateway(), uDPInfo.mac(), uDPInfo.id(), uDPInfo.version(), -1);
    }

    public DispatcherItemType getDispatcher() {
        return this.dispatcher;
    }
}

