/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommProtocol;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcherBase;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcherInitialPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CommCmUpdateDispatcher
extends CommCmUpdateDispatcherBase {
    private byte[] file_data = null;

    public CommCmUpdateDispatcher() {
        this.out = System.out;
    }

    public CommCmUpdateDispatcher(byte[] byArray) {
        this.file_data = byArray;
    }

    @Override
    public ACommCommand initializeCommandParams() throws WizePanelExceptions {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue("file");
        if (commCommandParamValue != null) {
            File file = new File(commCommandParamValue.getStringParam());
            this.file_data = new byte[(int)file.length()];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fileInputStream.read(this.file_data);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_FILE_NOT_FOUND_EXCEPTION, file.getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
            }
        }
        return this;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(75).setDestAddr(0).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public int getCommandParamsSize() {
        return this.file_data.length;
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        if (this.file_data == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        for (int i = 0; i < this.file_data.length; ++i) {
            byArray[n + i] = this.file_data[i];
        }
    }

    @Override
    public boolean beforeExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return this.beforeExecuteComposite(null, 0, commSocketsOperations);
    }

    @Override
    public boolean beforeExecute(String string, int n) throws WizePanelExceptions {
        return this.beforeExecuteComposite(string, n, null);
    }

    public boolean beforeExecuteComposite(String string, int n, CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        if (this.out != null) {
            this.out.println("Now uploading new firmware, this may take several minutes...");
        }
        if (null == commSocketsOperations) {
            return this.send_init(string, n);
        }
        return this.send_init(commSocketsOperations);
    }

    public boolean send_init(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        CommCmUpdateDispatcherInitialPacket commCmUpdateDispatcherInitialPacket = new CommCmUpdateDispatcherInitialPacket(this.file_data.length, this.preferredPayloadPacketSize(false));
        if (new CommProtocol(false).sendCommand(commSocketsOperations, commCmUpdateDispatcherInitialPacket)) {
            return true;
        }
        return false;
    }

    public boolean send_init(String string, int n) throws WizePanelExceptions {
        CommCmUpdateDispatcherInitialPacket commCmUpdateDispatcherInitialPacket = new CommCmUpdateDispatcherInitialPacket(this.file_data.length, this.preferredPayloadPacketSize(false));
        return new CommProtocol(false).sendCommand(string, n, commCmUpdateDispatcherInitialPacket);
    }

    @Override
    public boolean afterExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return this.after_execute();
    }

    @Override
    public boolean afterExecute(String string, int n) throws WizePanelExceptions {
        return this.after_execute();
    }

    private boolean after_execute() {
        if (this.out != null) {
            this.out.println("Upload successful. Dispatcher is now updating and rebooting.");
        }
        return true;
    }

    @Override
    public String getResults() {
        return "";
    }

    @Override
    public int preferredPayloadPacketSize(boolean bl) {
        if (bl) {
            return 60000;
        }
        return (int)Math.ceil((double)this.file_data.length / 250.0 / 5000.0) * 5000;
    }
}

