/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommSocketsOperations;
import de.wilke.wizepanel.prot.basic.ICommDispVerRetriever;
import de.wilke.wizepanel.prot.basic.WpOsValidator;
import de.wilke.wizepanel.prot.basic.WpVersionUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.types.SendDataHeader;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class CommCmWizePanelSendData
extends ACommCommand {
    private static final int COMMAND_ID = 10;
    public static final boolean WP_RETRIEVE_VER_BEFORE_SEND = true;
    public static final int WP_RETRIEVE_VER_BEFORE_SEND_PAUSE = 5000;
    private static final String WP_FIRST_LINUX_FIX_VERSION = "1.08";
    private static final String WP_LAST_LINUX_FIX_VERSION = "1.09";
    private static final String COMMAND_NAME = "wp-data";
    private static final String COMMAND_DESC = "Send Data to WizePanel";
    private static final String COMMAND_HELP = "--command wp-data --ip 192.168.1.209 --port 8000 --wpid 23020 --image 320x240_sw.bmp\n            Send the Image 320x240_sw.bmp to the WizePanel with the ID 23020\n              via the Dispatcher identified by the IP 192.168.1.209 and the port 8000.";
    private static final String PARAM_NAME_WPID = "wpid";
    private static final String PARAM_NAME_FILE = "file";
    private static final String PARAM_NAME_TYPE = "type";
    private static final String PARAM_NAME_COMPRESSION = "compression";
    private boolean forceTcpWindowCorrection = false;
    private int wizePanelID;
    private final SendDataHeader dheader = new SendDataHeader();

    public CommCmWizePanelSendData() {
        super(10, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (SendDataHeader.Type type : SendDataHeader.Type.values()) {
            linkedList.add((CallSite)((Object)(type.value + ": " + type.name())));
        }
        LinkedList linkedList2 = new LinkedList();
        for (SendDataHeader.Compression compression : SendDataHeader.Compression.values()) {
            linkedList2.add(compression.value + ": " + compression.name());
        }
        this.commandDescr.addParam(PARAM_NAME_WPID, CommCommandParams.Types.STRING, PARAM_NAME_WPID, "ID (serial number) of WizePanel.");
        this.commandDescr.addFileParam(PARAM_NAME_FILE, CommCommandParams.Types.STRING, PARAM_NAME_FILE, "Name of the file to send to WizePanel.", true);
        this.commandDescr.addParam(PARAM_NAME_TYPE, CommCommandParams.Types.INTEGER, PARAM_NAME_TYPE, WpUtils.implode((String)", ", linkedList));
        this.commandDescr.addParam(PARAM_NAME_COMPRESSION, CommCommandParams.Types.INTEGER, PARAM_NAME_COMPRESSION, WpUtils.implode((String)", ", (Collection)linkedList2));
    }

    public CommCmWizePanelSendData(int n, String string) throws WizePanelExceptions {
        this();
        this.wizePanelID = n;
        this.dheader.setPayload(string);
    }

    public CommCmWizePanelSendData(int n, byte[] byArray) {
        this();
        this.wizePanelID = n;
        this.dheader.setPayload(byArray);
    }

    @Override
    public CommCmWizePanelSendData initializeCommandParams() throws WizePanelExceptions {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_NAME_WPID);
        if (commCommandParamValue != null) {
            this.wizePanelID = Integer.parseInt(commCommandParamValue.getStringParam());
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_TYPE)) != null) {
            this.dheader.setType(commCommandParamValue.getIntParam());
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_COMPRESSION)) != null) {
            this.dheader.setCompression(commCommandParamValue.getIntParam());
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_FILE)) != null) {
            this.dheader.setPayload(commCommandParamValue.getStringParam());
        }
        return this;
    }

    public boolean beforeExecuteComposite(String string, int n, CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        ICommDispVerRetriever iCommDispVerRetriever;
        if (!WpOsValidator.isWindows() && null != (iCommDispVerRetriever = this.getDispVersionRetriever())) {
            if (null == commSocketsOperations) {
                iCommDispVerRetriever.retrieve(string, n);
            } else {
                iCommDispVerRetriever.retrieve(commSocketsOperations);
            }
            this.checkLinuxFixVersion(iCommDispVerRetriever.getVersion());
        }
        return true;
    }

    @Override
    public boolean beforeExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return this.beforeExecuteComposite(null, 0, commSocketsOperations);
    }

    @Override
    public boolean beforeExecute(String string, int n) throws WizePanelExceptions {
        return this.beforeExecuteComposite(string, n, null);
    }

    @Override
    public boolean afterExecute(CommSocketsOperations commSocketsOperations) throws WizePanelExceptions {
        return true;
    }

    @Override
    public boolean afterExecute(String string, int n) throws WizePanelExceptions {
        return true;
    }

    @Override
    public boolean mustForceTcpWindowCorrection() {
        return this.forceTcpWindowCorrection;
    }

    @Override
    public int getCommandParamsSize() {
        return this.dheader.length() + this.dheader.payload_length();
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(10).setDestAddr(this.wizePanelID).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) throws WizePanelExceptions {
        n = this.dheader.create(byArray, n);
        System.arraycopy(this.dheader.payload(), 0, byArray, n, this.dheader.payload_length());
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Data is sent to Dispatcher\n");
        stringBuilder.append(this.getResponseHeader().getFormattedTransactionId());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public int getWizePanelID() {
        return this.wizePanelID;
    }

    public CommCmWizePanelSendData setWizePanelID(int n) {
        this.wizePanelID = n;
        return this;
    }

    public void checkLinuxFixVersion(String string) throws WizePanelExceptions {
        if (WpVersionUtils.compare(string, WP_FIRST_LINUX_FIX_VERSION) >= 0 && WpVersionUtils.compare(string, WP_LAST_LINUX_FIX_VERSION) <= 0) {
            this.forceTcpWindowCorrection = true;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, interruptedException.getMessage());
            }
        }
    }

    @Override
    public void importPayload(byte[] byArray) {
        this.dheader.parse(byArray);
        byte[] byArray2 = new byte[byArray.length - this.dheader.length()];
        System.arraycopy(byArray, this.dheader.length(), byArray2, 0, byArray2.length);
        this.dheader.setPayload(byArray2);
    }

    public SendDataHeader getDataHeader() {
        return this.dheader;
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(PARAM_NAME_WPID, this.wizePanelID);
        linkedHashMap.put("len", this.getCommandParamsSize());
        return PrettyPrinter.condensed(linkedHashMap);
    }

    public SendDataHeader header() {
        return this.dheader;
    }

    @Override
    public int preferredPayloadPacketSize(boolean bl) {
        if (this.dheader.payload_length() != 0) {
            if (bl) {
                return 60000;
            }
            return (int)Math.ceil((double)this.dheader.payload_length() / 250.0 / 5000.0) * 5000;
        }
        return super.preferredPayloadPacketSize(bl);
    }
}

