/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import java.util.LinkedHashMap;

public class CommCmWizePanelSetWakeUpInterval
extends ACommCommand {
    private static final int COMMAND_ID = 7;
    private static final String COMMAND_NAME = "wp-wakeup";
    private static final String COMMAND_DESC = "Set New Wakeup Time of WizePanel";
    private static final String COMMAND_HELP = "--command wp-wakeup --ip 192.168.1.209 --port 8000 --wpid 23020 --wakeup 2\n            Set the Wakeup Time to 2 minutes for the WizePanel with the ID 23020\n              via the Dispatcher identified by the IP 192.168.1.209 and the port 8000.";
    private static final byte PARAMS_SIZE = 2;
    private static final String PARAM_NAME_WPID = "wpid";
    private static final String PARAM_NAME_WAKE_UP = "wakeup";
    private int wizePanelID;
    private int newWakeUpIntervalMins;

    public CommCmWizePanelSetWakeUpInterval() {
        super(7, COMMAND_NAME, COMMAND_DESC, COMMAND_HELP);
        this.commandDescr.addParam(PARAM_NAME_WPID, CommCommandParams.Types.STRING, PARAM_NAME_WPID, "ID (serial number) of WizePanel.").addParam(PARAM_NAME_WAKE_UP, CommCommandParams.Types.INTEGER, PARAM_NAME_WAKE_UP, "WakeUp Time (in minutes) of the WizePanel.");
    }

    public CommCmWizePanelSetWakeUpInterval(int n, int n2) {
        this();
        this.wizePanelID = n;
        this.newWakeUpIntervalMins = n2;
    }

    @Override
    public CommCmWizePanelSetWakeUpInterval initializeCommandParams() {
        CommCommandParams.CommCommandParamValue commCommandParamValue = this.getNamedParamValue(PARAM_NAME_WPID);
        if (commCommandParamValue != null) {
            this.wizePanelID = Integer.parseInt(commCommandParamValue.getStringParam());
        }
        if ((commCommandParamValue = this.getNamedParamValue(PARAM_NAME_WAKE_UP)) != null) {
            this.newWakeUpIntervalMins = commCommandParamValue.getIntParam();
        }
        return this;
    }

    @Override
    public int getCommandParamsSize() {
        return 2;
    }

    @Override
    public void prepareCommandHeader(CommHeader commHeader) {
        commHeader.setSeqNum(1).setPackCount(1).setCommandId(7).setDestAddr(this.wizePanelID).setPackLen(this.getCommandParamsSize());
    }

    @Override
    public void prepareCommandParams(byte[] byArray, int n) {
        byArray[n] = (byte)(this.newWakeUpIntervalMins & 0xFF);
        byArray[n + 1] = (byte)(this.newWakeUpIntervalMins >> 8 & 0xFF);
    }

    @Override
    public String getResults() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("New Wake-Up Interval Setting is transferred\n");
        stringBuilder.append(this.getResponseHeader().getFormattedTransactionId()).append("\n");
        return stringBuilder.toString();
    }

    @Override
    public String getCommandConfiguration() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(PARAM_NAME_WPID, this.wizePanelID);
        linkedHashMap.put(PARAM_NAME_WAKE_UP, this.newWakeUpIntervalMins);
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

