/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm.types;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SendDataHeader {
    private String PathToBmpFile;
    private byte[] FileBuf = null;
    public Type data_type = Type.IMAGE;
    private Compression compression = Compression.PNG;
    private String filename = "";
    private long file_length = 0L;

    public int create(byte[] byArray, int n) {
        String string = this.filename();
        OutputByteStream outputByteStream = new OutputByteStream(byArray, n);
        outputByteStream.put8bit((short)this.data_type.value);
        outputByteStream.put8bit((short)this.compression.value);
        outputByteStream.put8bit((short)string.length());
        outputByteStream.putString(string);
        outputByteStream.put32bit(this.calc_data_crc(0, this.FileBuf, this.FileBuf.length));
        outputByteStream.put32bit((long)this.FileBuf.length);
        return this.length();
    }

    public int length() {
        return 3 + this.filename().getBytes().length + 4 + 4;
    }

    public boolean parse(byte[] byArray) {
        InputByteStream inputByteStream = new InputByteStream(byArray);
        this.setType(inputByteStream.get8bit());
        this.setCompression(inputByteStream.get8bit());
        short s = inputByteStream.get8bit();
        this.filename = inputByteStream.getString((int)s);
        inputByteStream.get32bit();
        this.file_length = inputByteStream.get32bit();
        return false;
    }

    public String filename() {
        if (this.PathToBmpFile == null) {
            return this.filename;
        }
        String string = new File(this.PathToBmpFile).getName();
        if (string.length() > 64) {
            return string.substring(string.length() - 64);
        }
        return string;
    }

    public int payload_length() {
        if (this.data_type == Type.DISPLAY_UPDATE) {
            return 1;
        }
        if (this.FileBuf != null) {
            return this.FileBuf.length;
        }
        return (int)this.file_length;
    }

    private long calc_data_crc(int n, byte[] byArray, int n2) {
        long l = 133L;
        long l2 = 6L;
        long l3 = 0L;
        for (int i = n; i < n2 + n; ++i) {
            int n3 = byArray[i] & 0xFF;
            l3 += (long)n3 * l & 0xFFFFFFFFL;
            l = l + l2 & 0xFFFFL;
        }
        return l3 & 0xFFFFFFFFL;
    }

    public void setType(int n) {
        for (Type type : Type.values()) {
            if (type.value != n) continue;
            this.data_type = type;
            return;
        }
    }

    public Type type() {
        return this.data_type;
    }

    public void setCompression(int n) {
        for (Compression compression : Compression.values()) {
            if (compression.value != n) continue;
            this.compression = compression;
            return;
        }
    }

    public byte[] payload() throws WizePanelExceptions {
        if (this.FileBuf == null) {
            if (this.data_type == Type.DISPLAY_UPDATE) {
                try {
                    this.FileBuf = new byte[this.payload_length()];
                    this.FileBuf[0] = (byte)Integer.parseInt(this.PathToBmpFile);
                }
                catch (NumberFormatException numberFormatException) {
                    this.FileBuf[0] = 0;
                }
            } else {
                File file = new File(this.PathToBmpFile);
                try (FileInputStream fileInputStream = new FileInputStream(this.PathToBmpFile);){
                    this.FileBuf = new byte[(int)file.length()];
                    fileInputStream.read(this.FileBuf);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_FILE_NOT_FOUND_EXCEPTION, this.PathToBmpFile);
                }
                catch (IOException iOException) {
                    throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
                }
            }
        }
        return this.FileBuf;
    }

    public void setPayload(String string) throws WizePanelExceptions {
        this.PathToBmpFile = string;
        this.FileBuf = null;
        this.payload();
    }

    public void setPayload(byte[] byArray) {
        this.FileBuf = byArray;
    }

    public static enum Type {
        UNKNOWN(0),
        IMAGE(1),
        PLACEHOLDERS(2),
        TEMPLATE(3),
        FONT(4),
        FIRMWARE_CORTEX(5),
        FIRMWARE_MSP(6),
        DISPLAY_UPDATE(7);

        public final int value;

        private Type(int n2) {
            this.value = n2;
        }

        public static Type fromInt(int n) {
            for (Type type : Type.values()) {
                if (type.value != n) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum Compression {
        NONE(0),
        ZIP(1),
        PNG(2);

        public final int value;

        private Compression(int n2) {
            this.value = n2;
        }
    }
}

