/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm.types;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpIpUtils;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class SettingsType {
    private static final int MIN_PACKET_LEN = 28;
    public int Ip = 0;
    public int Port = 0;
    public int Subnet = 0;
    public int Gateway = 0;
    public boolean DhcpIsOn = true;
    public boolean UdpBroadcastIsOn = true;
    public long Timeout_Running_Command = 0L;
    public long Timeout_Dead_Panel = 0L;
    public int Maximum_Number_Registered_Panels = 0;
    public int Current_Number_Registered_Panels = 0;
    public final List<Long> registered_wps = new LinkedList<Long>();

    public void from(byte[] byArray) throws WizePanelExceptions {
        if (byArray.length < 28) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET);
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        this.Ip = (int)inputByteStream.get32bit();
        this.Port = inputByteStream.get16bit();
        this.Subnet = (int)inputByteStream.get32bit();
        this.Gateway = (int)inputByteStream.get32bit();
        this.DhcpIsOn = inputByteStream.get8bit() == 1;
        this.UdpBroadcastIsOn = inputByteStream.get8bit() == 1;
        this.Timeout_Running_Command = inputByteStream.get32bit();
        this.Timeout_Dead_Panel = inputByteStream.get32bit();
        this.Maximum_Number_Registered_Panels = inputByteStream.get16bit();
        this.Current_Number_Registered_Panels = inputByteStream.get16bit();
        if (inputByteStream.bytesAvailable() != 4 * this.Current_Number_Registered_Panels) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_DATA_ERROR_ID_CORRUPTED_PACKET, "packet_list");
        }
        for (int i = 0; i < this.Current_Number_Registered_Panels; ++i) {
            this.registered_wps.add(inputByteStream.get32bit());
        }
    }

    public byte[] getBytes() {
        OutputByteStream outputByteStream = new OutputByteStream(28 + 4 * this.registered_wps.size());
        outputByteStream.put32bit((long)this.Ip);
        outputByteStream.put16bit(this.Port);
        outputByteStream.put32bit((long)this.Subnet);
        outputByteStream.put32bit((long)this.Gateway);
        outputByteStream.put8bit((short)(this.DhcpIsOn ? 1 : 0));
        outputByteStream.put8bit((short)(this.UdpBroadcastIsOn ? 1 : 0));
        outputByteStream.put32bit(this.Timeout_Running_Command);
        outputByteStream.put32bit(this.Timeout_Dead_Panel);
        outputByteStream.put16bit(this.Maximum_Number_Registered_Panels);
        outputByteStream.put16bit(this.Current_Number_Registered_Panels);
        for (int i = 0; i < this.registered_wps.size(); ++i) {
            outputByteStream.put32bit(this.registered_wps.get(i).longValue());
        }
        return outputByteStream.getData();
    }

    public String toString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Collections.sort(this.registered_wps);
        linkedHashMap.put("IP", WpIpUtils.ip2str((int)this.Ip));
        linkedHashMap.put("Port", this.Port);
        linkedHashMap.put("Subnet Mask", WpIpUtils.ip2str((int)this.Subnet));
        linkedHashMap.put("Gateway", WpIpUtils.ip2str((int)this.Gateway));
        linkedHashMap.put("DHCP", this.DhcpIsOn ? "On" : "Off");
        linkedHashMap.put("UDP Broadcast", this.UdpBroadcastIsOn ? "On" : "Off");
        linkedHashMap.put("Timeout (secs) of running commands", this.Timeout_Running_Command);
        linkedHashMap.put("Timeout (secs) of \"dead\" panels", this.Timeout_Dead_Panel);
        linkedHashMap.put("Maximum number of registered panels", this.Maximum_Number_Registered_Panels);
        linkedHashMap.put("Current number of registered panels", this.Current_Number_Registered_Panels + " " + this.registered_wps.toString());
        return PrettyPrinter.block(linkedHashMap);
    }

    public String toCondensedString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("ip", WpIpUtils.ip2str((int)this.Ip));
        linkedHashMap.put("port", this.Port);
        linkedHashMap.put("subnet", WpIpUtils.ip2str((int)this.Subnet));
        linkedHashMap.put("gateway", WpIpUtils.ip2str((int)this.Gateway));
        linkedHashMap.put("dhcp", this.DhcpIsOn ? "On" : "Off");
        linkedHashMap.put("udp-broadcast", this.UdpBroadcastIsOn ? "On" : "Off");
        linkedHashMap.put("timeout-running-commands-secs", this.Timeout_Running_Command);
        linkedHashMap.put("timeout-dead-panels-secs", this.Timeout_Dead_Panel);
        linkedHashMap.put("max-num-reg-panels", this.Maximum_Number_Registered_Panels);
        linkedHashMap.put("now-num-reg-panels", this.Current_Number_Registered_Panels + " " + this.registered_wps.toString());
        return PrettyPrinter.condensed(linkedHashMap);
    }
}

