/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm.types;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.launch.WizePanelTools;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class TransactionStatus {
    public static final int LEN = 17;
    public static final int STATUS_FINISHED = 255;
    private static final int STATUS_REPLY_RECEIVED = 5;
    private long id = 0L;
    private int command_id = 0;
    private int action_code = 0;
    private long wpid = 0L;
    private int error_code = 0;
    private int status = 0;
    private int retransmissions = 0;
    private long lifetime = 0L;

    public TransactionStatus(long l, int n, long l2, int n2) {
        this.id = l;
        this.command_id = n;
        this.wpid = l2;
        this.status = n2;
    }

    public TransactionStatus(byte[] byArray) {
        if (byArray.length != 17) {
            return;
        }
        InputByteStream inputByteStream = new InputByteStream(byArray);
        this.id = inputByteStream.get32bit();
        this.command_id = inputByteStream.get8bit();
        this.action_code = inputByteStream.get8bit();
        this.wpid = inputByteStream.get32bit();
        this.error_code = inputByteStream.get8bit();
        this.status = inputByteStream.get8bit();
        this.retransmissions = inputByteStream.get8bit();
        this.lifetime = inputByteStream.get32bit();
    }

    public byte[] getBytes() {
        OutputByteStream outputByteStream = new OutputByteStream(17);
        outputByteStream.put32bit(this.id);
        outputByteStream.put8bit((short)this.command_id);
        outputByteStream.put8bit((short)this.action_code);
        outputByteStream.put32bit(this.wpid);
        outputByteStream.put8bit((short)this.error_code);
        outputByteStream.put8bit((short)this.status);
        outputByteStream.put8bit((short)this.retransmissions);
        outputByteStream.put32bit(this.lifetime);
        return outputByteStream.getData();
    }

    public String toStringPretty() {
        Object object = "";
        if (this.error_code != 0) {
            object = " (" + WizePanelExceptions.getHardwareErrorCodesNameByNum((int)this.error_code) + ")";
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("Transaction ID", String.format("0x%08x", this.id));
        linkedHashMap.put("WizePanel ID", this.wpid);
        linkedHashMap.put("Command ID", this.command_id + " (" + this.command_id2string(this.command_id) + ")");
        linkedHashMap.put("Action Code", this.action_code);
        linkedHashMap.put("ErrorCode", this.error_code + (String)object);
        linkedHashMap.put("Finished", (this.isFinished() ? "Yes" : "No") + " (" + (Serializable)(this.status == 5 ? "reply-data-available" : Integer.valueOf(this.status)) + ")");
        linkedHashMap.put("Retransmissions", this.retransmissions);
        linkedHashMap.put("Lifetime (secs)", this.lifetime);
        return PrettyPrinter.block(linkedHashMap);
    }

    private String command_id2string(int n) {
        ACommCommand aCommCommand = WizePanelTools.getCommandById(n);
        if (aCommCommand != null) {
            return aCommCommand.getName();
        }
        return "--unknown";
    }

    public long getId() {
        return this.id;
    }

    public long wpid() {
        return this.wpid;
    }

    public String command() {
        return this.command_id + " (" + this.command_id2string(this.command_id) + ")";
    }

    public boolean isFinished() {
        return this.status == 255;
    }

    public long lifetime() {
        return this.lifetime;
    }

    public void setLifetime(long l) {
        this.lifetime = l;
    }

    public int status() {
        return this.status;
    }

    public int retransmissions() {
        return this.retransmissions;
    }

    public int errorCode() {
        return this.error_code;
    }

    public int actionCode() {
        return this.action_code;
    }

    public String toString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("id", String.format("0x%08x", this.id));
        linkedHashMap.put("wpid", this.wpid);
        linkedHashMap.put("cmd", this.command_id + " (" + this.command_id2string(this.command_id) + ")");
        linkedHashMap.put("status", (this.isFinished() ? "Yes" : "No") + " (" + this.status + ")");
        linkedHashMap.put("action", this.action_code);
        linkedHashMap.put("err", this.error_code);
        linkedHashMap.put("retrans", this.retransmissions);
        linkedHashMap.put("lifetime", this.lifetime + "s");
        return PrettyPrinter.condensed(linkedHashMap);
    }

    static enum Command {

    }
}

