/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.comm.types;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WpIpUtils;
import de.wilke.wizepanel.core.misc.InputByteStream;
import de.wilke.wizepanel.core.misc.OutputByteStream;
import java.util.LinkedHashMap;

public class UDPInfo {
    private String ip;
    private int port = 0;
    private String subnet = "";
    private String gateway = "";
    private String mac = "";
    private String id = "";
    private String version = "";

    public UDPInfo(int n, int n2, byte[] byArray) {
        int n3;
        InputByteStream inputByteStream = new InputByteStream(byArray);
        this.ip = WpIpUtils.ip2str((int)n);
        for (n3 = 0; n3 < 4; ++n3) {
            this.subnet = inputByteStream.get8bit() + "." + this.subnet;
        }
        this.subnet = this.subnet.substring(0, this.subnet.length() - 1);
        for (n3 = 0; n3 < 4; ++n3) {
            this.gateway = inputByteStream.get8bit() + "." + this.gateway;
        }
        this.gateway = this.gateway.substring(0, this.gateway.length() - 1);
        for (n3 = 0; n3 < 6; ++n3) {
            this.mac = this.mac + String.format("%02x", inputByteStream.get8bit()) + ":";
        }
        this.mac = this.mac.substring(0, this.mac.length() - 1);
        if (inputByteStream.bytesAvailable() >= 12) {
            for (n3 = 0; n3 < 12; ++n3) {
                Object object = "";
                object = Integer.toHexString(inputByteStream.get8bit()) + ":";
                if (((String)object).length() == 2) {
                    object = "0" + (String)object;
                }
                this.id = this.id + (String)object;
            }
            this.id = this.id.substring(0, this.id.length() - 1);
        }
        if (inputByteStream.bytesAvailable() > 0) {
            this.version = inputByteStream.getString(inputByteStream.bytesAvailable());
        }
    }

    public UDPInfo(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        this.ip = string;
        this.port = n;
        this.subnet = string2;
        this.gateway = string3;
        this.mac = string4;
        this.id = string5;
        this.version = string6;
    }

    public byte[] rawBytes() {
        int n;
        OutputByteStream outputByteStream = new OutputByteStream(this.length());
        String[] stringArray = this.subnet.split("\\.");
        if (stringArray.length != 4) {
            return outputByteStream.getData();
        }
        for (n = 0; n < 4; ++n) {
            outputByteStream.put8bit(Short.parseShort(stringArray[3 - n]));
        }
        stringArray = this.gateway.split("\\.");
        if (stringArray.length != 4) {
            return outputByteStream.getData();
        }
        for (n = 0; n < 4; ++n) {
            outputByteStream.put8bit(Short.parseShort(stringArray[3 - n]));
        }
        stringArray = this.mac.split(":");
        if (stringArray.length != 6) {
            return outputByteStream.getData();
        }
        for (n = 0; n < 6; ++n) {
            outputByteStream.put8bit(Short.parseShort(stringArray[n], 16));
        }
        stringArray = this.id.split(":");
        if (stringArray.length != 12) {
            return outputByteStream.getData();
        }
        for (n = 0; n < 12; ++n) {
            outputByteStream.put8bit(Short.parseShort(stringArray[n], 16));
        }
        outputByteStream.putString(this.version);
        return outputByteStream.getData();
    }

    public int length() {
        return 26 + this.version.length();
    }

    public int ip() {
        return WpIpUtils.str2ip((String)this.ip);
    }

    public String ipAsString() {
        return this.ip;
    }

    public int port() {
        return this.port;
    }

    public String subnet() {
        return this.subnet;
    }

    public String gateway() {
        return this.gateway;
    }

    public String mac() {
        return this.mac;
    }

    public String id() {
        return this.id;
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("Address", this.ip);
        linkedHashMap.put("Port", this.port);
        linkedHashMap.put("Netmask", this.subnet);
        linkedHashMap.put("MAC", this.mac);
        linkedHashMap.put("Gateway", this.gateway);
        linkedHashMap.put("Dispatcher ID", this.id);
        linkedHashMap.put("Dispatcher Version", this.version);
        return PrettyPrinter.block(linkedHashMap);
    }
}

