/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.data;

import de.wilke.wizepanel.upi.routing.UpiRoutingNaming;
import de.wilke.wizepanel.upi.types.RouterParameters;
import org.json.JSONException;
import org.json.JSONObject;

public class DispatcherItemType
implements Comparable<DispatcherItemType> {
    private String id;
    private long last_update = 0L;
    private boolean last_update_success = false;
    private RouterParameters params = new RouterParameters();

    public DispatcherItemType(String string) {
        this.id = string;
    }

    public DispatcherItemType(DispatcherItemType dispatcherItemType) {
        this.copyFrom(dispatcherItemType, true);
    }

    public DispatcherItemType(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        this.id = string5;
        this.params.setIp(string);
        this.params.setSubnet(string2);
        this.params.setPort(n);
        this.params.setGateway(string3);
        this.params.setMac(string4);
        this.params.setVersion(string6);
        this.params.setMaxWP(n2);
    }

    public void copyFrom(DispatcherItemType dispatcherItemType, boolean bl) {
        this.id = dispatcherItemType.getId();
        this.params.importFrom(dispatcherItemType.params);
        if (bl) {
            this.last_update = dispatcherItemType.getLastUpdate();
            this.last_update_success = dispatcherItemType.isLastUpdateSuccessful();
        }
    }

    public String toJSON() {
        JSONObject jSONObject = this.params.toJSON();
        try {
            jSONObject.put(UpiRoutingNaming.UpiRoutingRouterParams.ID.toString(), (Object)this.id);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    public String toString() {
        return this.toJSON();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public int compareTo(DispatcherItemType dispatcherItemType) {
        return this.params.getIp().compareTo(dispatcherItemType.params.getIp());
    }

    public long getLastUpdate() {
        return this.last_update;
    }

    public void setLastUpdate(long l) {
        this.last_update = l;
    }

    public boolean isLastUpdateSuccessful() {
        return this.last_update_success;
    }

    public void setLastUpdateSuccessful(boolean bl) {
        this.last_update_success = bl;
    }

    public String getPrettyId() {
        return this.params.getIp() + ":" + this.params.getPort();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + (int)(this.last_update ^ this.last_update >>> 32);
        n = 31 * n + (this.last_update_success ? 1231 : 1237);
        n = 31 * n + (this.params == null ? 0 : this.params.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DispatcherItemType dispatcherItemType = (DispatcherItemType)object;
        if (this.id == null ? dispatcherItemType.id != null : !this.id.equals(dispatcherItemType.id)) {
            return false;
        }
        if (this.last_update != dispatcherItemType.last_update) {
            return false;
        }
        if (this.last_update_success != dispatcherItemType.last_update_success) {
            return false;
        }
        return !(this.params == null ? dispatcherItemType.params != null : !this.params.equals((Object)dispatcherItemType.params));
    }

    public RouterParameters params() {
        return this.params;
    }

    public void setParams(RouterParameters routerParameters) {
        this.params = routerParameters;
    }

    public String toStringCR() {
        return "Status: dispatcher is online\nAddress: " + this.params.getIp() + "\nPort: " + this.params.getPort() + "\nSubnetmask: " + this.params.getSubnet() + "\nGateway: " + this.params.getGateway() + "\nMacAddress: " + this.params.getMac() + "\nDispatcherID: " + this.id + "\nFirmwareVersion: " + this.params.getVersion() + ", MaxWP: " + this.params.getMaxWP() + "\n";
    }
}

