/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.data;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.upi.types.TargetParameters;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class WizePanelItemType
implements Comparable<WizePanelItemType> {
    public static final String WP_DESCR_TAGS_SEP = "\n";
    public static final String WP_DESCR_TAG_VALUE_SEP = ":";
    private Display display;
    protected int serialNo;
    private TargetParameters params;
    protected int dispatcher_field_strength;
    protected String currentResourceId;
    protected String defaultResourceId;
    protected Date _last_update_time;

    public WizePanelItemType() {
        this.display = new Display(Display.Type.TYPE_057.id);
        this.params = new TargetParameters();
        this._last_update_time = null;
    }

    public WizePanelItemType(WizePanelItemType wizePanelItemType) {
        this();
        this.InitItemByCopy(wizePanelItemType);
    }

    public WizePanelItemType(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this();
        this.serialNo = n;
        this.params.setField(n2);
        this.params.setGoodTransmissions(n3);
        this.params.setBadTransmissions(n4);
        this.params.setLastSeen(n5);
        this.params.setWakeup(n6);
        this.params.setBatteryPassive(n7);
        this.params.setBatteryActive(n8);
    }

    public void InitItemByCopy(Object object) {
        WizePanelItemType wizePanelItemType = (WizePanelItemType)object;
        this.serialNo = wizePanelItemType.getSerialNo();
        this.params = wizePanelItemType.params;
        this.currentResourceId = wizePanelItemType.getCurrentResourceId();
        this.defaultResourceId = wizePanelItemType.getDefaultResourceId();
        this._last_update_time = wizePanelItemType.getLastUpdate();
        this.setType(wizePanelItemType.getType());
    }

    private Map<WizePanelDescrTags, String> toMap(WizePanelDescrPrint wizePanelDescrPrint, String string, String string2) {
        LinkedHashMap<WizePanelDescrTags, String> linkedHashMap = new LinkedHashMap<WizePanelDescrTags, String>();
        for (WizePanelDescrTags wizePanelDescrTags : WizePanelDescrTags.values()) {
            linkedHashMap.put(wizePanelDescrTags, this.buildTag(wizePanelDescrTags, wizePanelDescrPrint, string, string2));
        }
        return linkedHashMap;
    }

    private String buildTag(WizePanelDescrTags wizePanelDescrTags, WizePanelDescrPrint wizePanelDescrPrint, String string, String string2) {
        Object object = "";
        String string3 = this.getValueByType(wizePanelDescrTags);
        if (string3 != null && !string3.isEmpty()) {
            Object object2;
            Object object3 = object2 = wizePanelDescrPrint == WizePanelDescrPrint.PRINT_COMPACT ? wizePanelDescrTags.tagName : wizePanelDescrTags.tagDescr;
            while (((String)object2).length() < 38) {
                object2 = (String)object2 + ".";
            }
            object = (String)object + (String)object2;
            object = (String)object + string + " " + string3;
            object = (String)object + (wizePanelDescrPrint == WizePanelDescrPrint.PRINT_FULL && !wizePanelDescrTags.tagUnit.isEmpty() ? wizePanelDescrTags.tagUnit : "");
            object = (String)object + string2;
        }
        return object;
    }

    private String getValueByType(WizePanelDescrTags wizePanelDescrTags) {
        int n = 0;
        switch (wizePanelDescrTags) {
            case WPF_SERIAL_NO: {
                n = this.getSerialNo();
                break;
            }
            case WPF_TYPE: {
                n = this.getType();
                break;
            }
            case WPF_FIELD_STRENGTH: {
                n = this.params.getField();
                break;
            }
            case WPF_DISPATCHER_FIELD_STRENGTH: {
                n = this.getDispatcherFieldStrength();
                break;
            }
            case WPF_COMPLETED_TRANSACTIONS: {
                n = this.params.getGoodTransmissions();
                break;
            }
            case WPF_FAILED_TRANSACTIONS: {
                n = this.params.getBadTransmissions();
                break;
            }
            case WPF_BATTERY_NO_UPDATE: {
                n = this.params.getBatteryPassive();
                break;
            }
            case WPF_BATTERY_WITH_UPDATE: {
                n = this.params.getBatteryActive();
                break;
            }
            case WPF_LAST_SEEN: {
                n = this.getLastSeen();
                break;
            }
            case WPF_WAKEUP_TIME: {
                n = this.params.getWakeup();
            }
        }
        return Integer.toString(n);
    }

    public String toString() {
        return WizePanelDescrTags.WPF_SERIAL_NO.tagName + this.serialNo;
    }

    public String info() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(WizePanelDescrTags.WPF_SERIAL_NO.tagName, this.serialNo);
        hashMap.put(WizePanelDescrTags.WPF_TYPE.tagName, this.getType());
        return PrettyPrinter.condensed(hashMap);
    }

    public String toStringTrasportable() {
        return WpUtils.implode((String)"", this.toMap(WizePanelDescrPrint.PRINT_COMPACT, WP_DESCR_TAG_VALUE_SEP, WP_DESCR_TAGS_SEP).values());
    }

    public Map<WizePanelDescrTags, String> toMap() {
        return this.toMap(WizePanelDescrPrint.PRINT_FULL, WP_DESCR_TAG_VALUE_SEP, WP_DESCR_TAGS_SEP);
    }

    @Override
    public int compareTo(WizePanelItemType wizePanelItemType) {
        return this.serialNo - wizePanelItemType.serialNo;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._last_update_time == null ? 0 : this._last_update_time.hashCode());
        n = 31 * n + (this.currentResourceId == null ? 0 : this.currentResourceId.hashCode());
        n = 31 * n + (this.defaultResourceId == null ? 0 : this.defaultResourceId.hashCode());
        n = 31 * n + this.dispatcher_field_strength;
        n = 31 * n + (this.display == null ? 0 : this.display.hashCode());
        n = 31 * n + (this.params == null ? 0 : this.params.hashCode());
        n = 31 * n + this.serialNo;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WizePanelItemType wizePanelItemType = (WizePanelItemType)object;
        if (this._last_update_time == null ? wizePanelItemType._last_update_time != null : !this._last_update_time.equals(wizePanelItemType._last_update_time)) {
            return false;
        }
        if (this.currentResourceId == null ? wizePanelItemType.currentResourceId != null : !this.currentResourceId.equals(wizePanelItemType.currentResourceId)) {
            return false;
        }
        if (this.defaultResourceId == null ? wizePanelItemType.defaultResourceId != null : !this.defaultResourceId.equals(wizePanelItemType.defaultResourceId)) {
            return false;
        }
        if (this.dispatcher_field_strength != wizePanelItemType.dispatcher_field_strength) {
            return false;
        }
        if (this.display == null ? wizePanelItemType.display != null : !this.display.equals((Object)wizePanelItemType.display)) {
            return false;
        }
        if (this.params == null ? wizePanelItemType.params != null : !this.params.equals((Object)wizePanelItemType.params)) {
            return false;
        }
        return this.serialNo == wizePanelItemType.serialNo;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(int n) {
        this.serialNo = n;
    }

    public int getType() {
        return this.display.getType().id;
    }

    public void setType(int n) {
        if (this.display.getType().id != n) {
            this.display = new Display(n);
        }
        this.params.setType(this.getType());
    }

    public int getDispatcherFieldStrength() {
        return this.dispatcher_field_strength;
    }

    public void setDispatcherFieldStrength(int n) {
        this.dispatcher_field_strength = n;
    }

    public int getLastSeen() {
        if (this._last_update_time == null) {
            return -1;
        }
        long l = (new Date().getTime() - this._last_update_time.getTime()) / 1000L + (long)this.params.getLastSeen();
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public String getCurrentResourceId() {
        return this.currentResourceId;
    }

    public void setCurrentResourceId(String string) {
        this.currentResourceId = string;
    }

    public String getDefaultResourceId() {
        return this.defaultResourceId;
    }

    public void setDefaultResourceId(String string) {
        this.defaultResourceId = string;
    }

    public void setLastUpdate(Date date) {
        this._last_update_time = date;
    }

    public Date getLastUpdate() {
        return this._last_update_time;
    }

    public boolean isEPaper() {
        return this.display.getType().hasDataCommand() || this.serialNo >= 135024325 && this.serialNo <= 135024329 || this.serialNo >= 135024325 && this.serialNo <= 135024424;
    }

    public Display getDisplay() {
        return this.display;
    }

    public int batteryPercent() {
        int n = 2000;
        int n2 = 2600;
        int n3 = this.params.getBatteryActive();
        if (n3 == 0) {
            n = 1800;
            n2 = 2500;
            n3 = this.params.getBatteryPassive();
        }
        if (n3 < n) {
            return 0;
        }
        if (n3 > n2) {
            return 100;
        }
        return (n3 - n) * 100 / (n2 - n);
    }

    public TargetParameters params() {
        return this.params;
    }

    public static enum WizePanelDescrTags {
        WPF_SERIAL_NO("id", "", "Serial number"),
        WPF_TYPE("type", "", "Type"),
        WPF_FIELD_STRENGTH("field_strength", " dBm", "Field strength"),
        WPF_DISPATCHER_FIELD_STRENGTH("dispatcher_field_strength", " dBm", "Dispatcher field strength"),
        WPF_COMPLETED_TRANSACTIONS("completed_ta", "", "Completed transactions"),
        WPF_FAILED_TRANSACTIONS("failed_ta", "", "Failed transactions"),
        WPF_BATTERY_NO_UPDATE("battery_power_no_update", " mV", "Battery level on last wakeup"),
        WPF_BATTERY_WITH_UPDATE("battery_power_with_update", " mV", "Battery level on last display update"),
        WPF_LAST_SEEN("last_seen", " sec", "Last seen"),
        WPF_WAKEUP_TIME("wakeup_time", " sec", "WakeUp Time");

        private final String tagName;
        private final String tagUnit;
        private final String tagDescr;

        private WizePanelDescrTags(String string2, String string3, String string4) {
            this.tagName = string2;
            this.tagUnit = string3;
            this.tagDescr = string4;
        }

        public String toString() {
            return this.tagName;
        }
    }

    public static enum WizePanelDescrPrint {
        PRINT_FULL,
        PRINT_COMPACT;

    }
}

