/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.prot.launch;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.prot.basic.CommCommandParams;
import de.wilke.wizepanel.prot.basic.CommHeader;
import de.wilke.wizepanel.prot.basic.CommInvoker;
import de.wilke.wizepanel.prot.basic.CommPacket;
import de.wilke.wizepanel.prot.basic.CommProtocol;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmCancelTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispDebug;
import de.wilke.wizepanel.prot.comm.CommCmDispGetCommandResponse;
import de.wilke.wizepanel.prot.comm.CommCmDispGetErrors;
import de.wilke.wizepanel.prot.comm.CommCmDispGetFirmwareVer;
import de.wilke.wizepanel.prot.comm.CommCmDispGetSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispGetStats;
import de.wilke.wizepanel.prot.comm.CommCmDispGetTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsAll;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsSubscribed;
import de.wilke.wizepanel.prot.comm.CommCmDispRestart;
import de.wilke.wizepanel.prot.comm.CommCmDispSetAudioVisualIdentify;
import de.wilke.wizepanel.prot.comm.CommCmDispSetIpSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispSetMaxWp;
import de.wilke.wizepanel.prot.comm.CommCmDispSubscribeList;
import de.wilke.wizepanel.prot.comm.CommCmDispSubscribeWp;
import de.wilke.wizepanel.prot.comm.CommCmDispUDPInfoSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispUnSubscribeWp;
import de.wilke.wizepanel.prot.comm.CommCmSysGetVersion;
import de.wilke.wizepanel.prot.comm.CommCmUpdateDispatcher;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelElectricErase;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelGetVersion;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendBmp;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendData;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSetWakeUpInterval;
import de.wilke.wizepanel.prot.comm.WpCmdDHCP;
import de.wilke.wizepanel.prot.launch.WizePanelTools;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WizePanelToolsCommandLine {
    private static final String OUTPUT_PREFIX = "=> ";
    private static final String DEFAULT_DISPATCHER_OPTION_IP = "ip";
    private static final String DEFAULT_DISPATCHER_OPTION_PORT = "port";
    private static final String PARAM_COMMAND = "command";
    private static final String PARAM_ADMIN_MODE = "admin";
    private static final String PARAM_USE_UDP = "udp";
    private static final String PARAM_HELP = "help";
    public static final String PARAM_MAC = "mac";
    private static JSAP jsap = new JSAP();
    private static final List<ACommCommand> commands = new LinkedList<ACommCommand>();
    private static boolean initialized = false;
    private static boolean admin_mode = false;
    private static String currentCommandName = "";

    public static void main(String[] stringArray) {
        int n;
        block13: {
            n = 0;
            try {
                try {
                    try {
                        WizePanelTools.init();
                    }
                    catch (Exception exception) {
                        n = 1;
                        throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_PROT_ERROR_ID_INIT_FAILED);
                    }
                    ACommCommand aCommCommand = WizePanelToolsCommandLine.execute(stringArray);
                    if (aCommCommand != null) {
                        System.out.println(aCommCommand.getResults() + "\n");
                        break block13;
                    }
                    n = 2;
                }
                catch (WizePanelExceptions wizePanelExceptions) {
                    n = 3;
                    if (wizePanelExceptions.getErrorCode() != null) {
                        switch (wizePanelExceptions.getErrorCode()) {
                            case WP_ARGS_ERROR_ID_NOT_INITIALIZED: {
                                WizePanelToolsCommandLine.printErrorMessage(wizePanelExceptions.getErrorDescription());
                                break;
                            }
                            case WP_ARGS_ERROR_ID_NO_ARGS: {
                                break;
                            }
                            case WP_ARGS_ERROR_ID_INVALID_COMMAND: {
                                WizePanelToolsCommandLine.printUsage(wizePanelExceptions.getErrorParams());
                                break;
                            }
                            default: {
                                WizePanelToolsCommandLine.printErrorMessage(wizePanelExceptions.getErrorDescription() + " " + wizePanelExceptions.getErrorParams());
                                wizePanelExceptions.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        System.exit(n);
    }

    public static void init() throws Exception {
        WizePanelToolsCommandLine.initCommandList();
        WizePanelToolsCommandLine.initJsapParams();
        initialized = true;
    }

    private static ACommCommand execute(String[] stringArray) throws WizePanelExceptions {
        JSAPResult jSAPResult = null;
        if (!initialized) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_NOT_INITIALIZED);
        }
        if (stringArray.length > 0) {
            jSAPResult = jsap.parse(stringArray);
        }
        if (jSAPResult == null || !jSAPResult.success()) {
            if (jSAPResult == null) {
                WizePanelToolsCommandLine.printUsage(null);
            } else {
                System.err.println("Command parameters could not be parsed.");
                Iterator iterator = jSAPResult.getErrorMessageIterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    System.err.println(e.toString());
                }
            }
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_NO_ARGS);
        }
        currentCommandName = jSAPResult.getString(PARAM_COMMAND);
        if (jSAPResult.contains(PARAM_ADMIN_MODE)) {
            admin_mode = jSAPResult.getBoolean(PARAM_ADMIN_MODE);
        }
        ACommCommand aCommCommand = null;
        for (ACommCommand aCommCommand2 : commands) {
            if (!aCommCommand2.getName().equals(currentCommandName)) continue;
            aCommCommand = aCommCommand2;
            break;
        }
        if (jSAPResult.contains(PARAM_HELP) && jSAPResult.getBoolean(PARAM_HELP)) {
            if (aCommCommand == null) {
                WizePanelToolsCommandLine.printUsage(null);
            } else {
                WizePanelToolsCommandLine.printUsageCommand(aCommCommand);
            }
            return null;
        }
        if (aCommCommand == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_INVALID_COMMAND, currentCommandName);
        }
        if (!(!aCommCommand.requireIpAndPort() || jSAPResult.contains(DEFAULT_DISPATCHER_OPTION_IP) && jSAPResult.contains(DEFAULT_DISPATCHER_OPTION_PORT))) {
            System.err.println("Port and IP are required.");
            return null;
        }
        Object object = jSAPResult.getString(DEFAULT_DISPATCHER_OPTION_IP);
        int n = jSAPResult.getInt(DEFAULT_DISPATCHER_OPTION_PORT);
        for (CommCommandParams commCommandParams : aCommCommand.getParamList()) {
            if (commCommandParams.isRequired() && !jSAPResult.contains(commCommandParams.getName())) {
                System.err.println("Required parameter not found: " + commCommandParams.getName());
                System.err.println();
                WizePanelToolsCommandLine.printUsageCommand(aCommCommand);
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_NO_ARGS, commCommandParams.getName());
            }
            if (!jSAPResult.contains(commCommandParams.getName())) continue;
            switch (commCommandParams.getParamType()) {
                case INTEGER: {
                    commCommandParams.setValue(jSAPResult.getInt(commCommandParams.getName()));
                    break;
                }
                case STRING: {
                    commCommandParams.setValue(jSAPResult.getString(commCommandParams.getName()));
                    break;
                }
                case BOOLEAN: {
                    if (!jSAPResult.getBoolean(commCommandParams.getName())) break;
                    commCommandParams.setValue(true);
                }
            }
        }
        aCommCommand.initializeCommandParams();
        if (jSAPResult.contains(PARAM_USE_UDP) && jSAPResult.getBoolean(PARAM_USE_UDP)) {
            object = "255.255.255.255";
            n = 8001;
            System.out.println(OUTPUT_PREFIX + (String)object + ":" + n);
            System.out.println(OUTPUT_PREFIX + aCommCommand.getCommandName() + " (" + aCommCommand.getCommandConfiguration() + ")");
            System.out.println("=> UDP");
            if (!aCommCommand.isUDPAllowed()) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_ARGS_ERROR_ID_NO_ARGS, "UDP not allowed for this command.");
            }
            if (!jSAPResult.contains(PARAM_MAC)) {
                System.err.println("MAC address is required.");
                return null;
            }
            System.out.println("=> MAC: " + jSAPResult.getString(PARAM_MAC));
            System.out.println();
            WizePanelToolsCommandLine.send_using_udp((String)object, n, aCommCommand);
            return aCommCommand;
        }
        if (aCommCommand.requireIpAndPort()) {
            System.out.println(OUTPUT_PREFIX + (String)object + ":" + n);
            System.out.flush();
        }
        System.out.println(OUTPUT_PREFIX + aCommCommand.getCommandName() + " (" + aCommCommand.getCommandConfiguration() + ")");
        System.out.println();
        if (new CommInvoker().ExecuteCommand((String)object, n, aCommCommand)) {
            return aCommCommand;
        }
        return null;
    }

    private static synchronized void initCommandList() {
        initialized = true;
        commands.add(new CommCmSysGetVersion());
        commands.add(new CommCmWizePanelSendBmp());
        commands.add(new CommCmWizePanelSendData());
        commands.add(new CommCmWizePanelSetWakeUpInterval());
        commands.add(new CommCmWizePanelElectricErase());
        commands.add(new CommCmWizePanelGetVersion());
        commands.add(new CommCmDispSetIpSettings());
        commands.add(new CommCmDispSetAudioVisualIdentify());
        commands.add(new CommCmDispGetFirmwareVer());
        commands.add(new CommCmDispRestart());
        commands.add(new CommCmDispGetWizepanelsAll());
        commands.add(new CommCmDispGetWizepanelsSubscribed());
        commands.add(new CommCmDispGetStats());
        commands.add(new CommCmDispGetSettings());
        commands.add(new CommCmDispSetMaxWp());
        commands.add(new CommCmDispGetErrors());
        commands.add(new CommCmDispDebug());
        commands.add(new CommCmDispUDPInfoSettings());
        commands.add(new CommCmUpdateDispatcher());
        commands.add(new WpCmdDHCP());
        commands.add(new CommCmDispSubscribeWp());
        commands.add(new CommCmDispSubscribeList());
        commands.add(new CommCmDispUnSubscribeWp());
        commands.add(new CommCmDispGetTransactions());
        commands.add(new CommCmCancelTransactions());
        commands.add(new CommCmDispGetCommandResponse());
    }

    public static ACommCommand getCommandById(int n) {
        if (!initialized) {
            WizePanelToolsCommandLine.initCommandList();
        }
        for (ACommCommand aCommCommand : commands) {
            if (aCommCommand.getId() != n) continue;
            return aCommCommand;
        }
        return null;
    }

    public static ACommCommand createCommandById(int n) {
        ACommCommand aCommCommand = WizePanelToolsCommandLine.getCommandById(n);
        if (aCommCommand == null) {
            return null;
        }
        try {
            Class<?> clazz = aCommCommand.getClass();
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (ACommCommand)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List<ACommCommand> getCommands() {
        if (!initialized) {
            WizePanelToolsCommandLine.initCommandList();
        }
        return commands;
    }

    private static void initJsapParams() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        FlaggedOption flaggedOption = new FlaggedOption(PARAM_COMMAND).setStringParser((StringParser)JSAP.STRING_PARSER).setShortFlag('C').setLongFlag(PARAM_COMMAND);
        flaggedOption.setHelp("A command of WizePanel communication protocol.");
        jsap.registerParameter((Parameter)flaggedOption);
        FlaggedOption flaggedOption2 = new FlaggedOption(DEFAULT_DISPATCHER_OPTION_IP).setStringParser((StringParser)JSAP.STRING_PARSER).setDefault("192.168.1.209").setRequired(false).setShortFlag('I').setLongFlag(DEFAULT_DISPATCHER_OPTION_IP);
        flaggedOption2.setHelp("IP of Dispatcher.");
        jsap.registerParameter((Parameter)flaggedOption2);
        FlaggedOption flaggedOption3 = new FlaggedOption(DEFAULT_DISPATCHER_OPTION_PORT).setStringParser((StringParser)JSAP.INTEGER_PARSER).setDefault("8000").setRequired(false).setShortFlag('P').setLongFlag(DEFAULT_DISPATCHER_OPTION_PORT);
        flaggedOption3.setHelp("Port of Dispatcher.");
        jsap.registerParameter((Parameter)flaggedOption3);
        Switch switch_ = new Switch(PARAM_ADMIN_MODE).setLongFlag(PARAM_ADMIN_MODE);
        jsap.registerParameter((Parameter)switch_);
        Switch switch_2 = new Switch(PARAM_USE_UDP).setLongFlag(PARAM_USE_UDP);
        jsap.registerParameter((Parameter)switch_2);
        Switch switch_3 = new Switch(PARAM_HELP).setLongFlag(PARAM_HELP);
        jsap.registerParameter((Parameter)switch_3);
        for (ACommCommand aCommCommand : commands) {
            List<CommCommandParams> list = aCommCommand.getParamList();
            for (CommCommandParams commCommandParams : list) {
                if (arrayList.contains(commCommandParams.getName())) continue;
                arrayList.add(commCommandParams.getName());
                Object object = commCommandParams.getParamType() == CommCommandParams.Types.BOOLEAN ? new Switch(commCommandParams.getName()).setLongFlag(commCommandParams.getFlag()) : new FlaggedOption(commCommandParams.getName()).setStringParser(WizePanelToolsCommandLine.mapParamTypeNameToJsapTypeName(commCommandParams.getParamType())).setDefault(JSAP.NO_DEFAULT).setRequired(false).setShortFlag('\u0000').setLongFlag(commCommandParams.getFlag());
                object.setHelp(commCommandParams.getDescr());
                jsap.registerParameter((Parameter)object);
            }
        }
    }

    private static void printErrorMessage(String string) {
        System.err.println("Error:" + string);
        System.err.println();
    }

    private static void printUsageShort() {
        System.err.println("Usage: java -jar wp_tools.jar --command <COMMAND>\n");
    }

    private static void printUsage(String string) {
        WizePanelToolsCommandLine.printUsageShort();
        if (string != null) {
            System.err.println("Unknown command: " + string);
        }
        System.err.println("Commands:");
        for (ACommCommand aCommCommand : commands) {
            if (!admin_mode && aCommCommand.isAdminCommand()) continue;
            System.err.println("   " + aCommCommand.getCommandName());
            System.err.println("      " + aCommCommand.getDescription());
            if (!aCommCommand.isAdminCommand()) continue;
            System.err.println("      [admin]");
        }
        if (admin_mode) {
            System.err.println();
            System.err.println("Parameters: (Usage: java -DPARAMETER=VALUE -jar ...)");
            System.err.println("   PACKET_PAYLOAD_SIZE");
            System.err.println("      Size of the packet payload. Default: " + ACommCommand.PACKET_PAYLOAD_SIZE);
            System.err.println("   PACKET_PAUSE");
            System.err.println("      Time to wait between packets. Default: " + CommProtocol.PACKET_PAUSE);
        }
    }

    private static void printUsageCommand(ACommCommand aCommCommand) {
        WizePanelToolsCommandLine.printUsageShort();
        System.err.println("Command: " + aCommCommand.getCommandName());
        System.err.println();
        System.err.println("Parameters:");
        for (CommCommandParams commCommandParams : aCommCommand.getParamList()) {
            System.err.println("   " + commCommandParams.getName());
            System.err.println("      " + commCommandParams.getDescr());
        }
    }

    private static StringParser mapParamTypeNameToJsapTypeName(CommCommandParams.Types types) {
        switch (types) {
            case INTEGER: {
                return JSAP.INTEGER_PARSER;
            }
            case STRING: {
                return JSAP.STRING_PARSER;
            }
            case BOOLEAN: {
                return JSAP.BOOLEAN_PARSER;
            }
        }
        return JSAP.STRING_PARSER;
    }

    private static void send_using_udp(String string, int n, ACommCommand aCommCommand) throws WizePanelExceptions {
        try {
            CommHeader commHeader = new CommHeader();
            aCommCommand.prepareCommandHeader(commHeader);
            byte[] byArray = new byte[CommHeader.getHeaderSize() + aCommCommand.getCommandParamsSize()];
            commHeader.buildHeader(byArray);
            aCommCommand.prepareCommandParams(byArray, CommHeader.getHeaderSize());
            CommPacket commPacket = new CommPacket(byArray);
            DatagramSocket datagramSocket = new DatagramSocket();
            DatagramPacket datagramPacket = new DatagramPacket(commPacket.raw(), commPacket.length(), new InetSocketAddress(string, n));
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (SocketException socketException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_SOCKET_EXCEPTION, socketException.getMessage());
        }
        catch (IOException iOException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_FWD_IO_ERROR_ID_IO_EXCEPTION, iOException.getMessage());
        }
    }
}

