/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.SchadchenChangeListener;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Schadchen {
    public static final String SEP = "#";
    private static final String JSOURCES = "sources";
    private final Set<SchadchenChangeListener> change_listeners = new HashSet<SchadchenChangeListener>();
    private final Map<String, List<AdapterPart>> config = new ConcurrentHashMap<String, List<AdapterPart>>();

    public int size() {
        return this.config.size();
    }

    public void reconfigure(List<AbstractAdapterConfiguration> list) {
        this.config.clear();
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : list) {
            List<String> list2 = abstractAdapterConfiguration.targets();
            if (list2 == null) continue;
            for (String string : list2) {
                if (!this.config.containsKey(string)) {
                    this.config.put(string, new LinkedList());
                }
                this.config.get(string).add(new AdapterPart(abstractAdapterConfiguration.getName(), string, abstractAdapterConfiguration.isEnabled(), abstractAdapterConfiguration.requiredLicense().license_id));
            }
        }
    }

    public boolean load(String string, List<AbstractAdapterConfiguration> list) {
        String string2 = WpFileUtils.readTextFile(new File(string));
        return this.fromString(string2, list);
    }

    public void save(String string) {
        WpFileUtils.writeTextToFile(new File(string), this.toString());
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string : this.config.keySet()) {
                JSONArray jSONArray = new JSONArray();
                for (AdapterPart adapterPart : this.config.get(string)) {
                    jSONArray.put((Object)adapterPart.toJson());
                }
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(JSOURCES, (Object)jSONArray);
                jSONObject.put(string, (Object)jSONObject2);
            }
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return jSONObject.toString();
        }
    }

    public List<String> getSources(String string) {
        if (this.config.containsKey(string)) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (AdapterPart adapterPart : this.config.get(string)) {
                linkedList.add(adapterPart.adapter_name + SEP + adapterPart.entry);
            }
            return linkedList;
        }
        return null;
    }

    public List<AdapterPart> getConfig(String string) {
        return this.config.get(string);
    }

    public Map<String, List<AdapterPart>> getAllConfigs() {
        ConcurrentHashMap<String, List<AdapterPart>> concurrentHashMap = new ConcurrentHashMap<String, List<AdapterPart>>();
        for (Map.Entry<String, List<AdapterPart>> entry : this.config.entrySet()) {
            concurrentHashMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return concurrentHashMap;
    }

    public void setConfig(String string, List<AdapterPart> list) {
        this.config.put(string, list);
    }

    public boolean fromString(String string, List<AbstractAdapterConfiguration> list) {
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.length() == 0) {
                this.config.clear();
                this.inform_change_listeners();
                return false;
            }
            HashMap<String, AbstractAdapterConfiguration> hashMap = new HashMap<String, AbstractAdapterConfiguration>();
            for (AbstractAdapterConfiguration stringArray : list) {
                hashMap.put(stringArray.getName(), stringArray);
            }
            HashMap hashMap2 = new HashMap();
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
                JSONArray jSONArray;
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                if (!jSONObject2.has(JSOURCES) || (jSONArray = jSONObject2.getJSONArray(JSOURCES)).length() == 0) continue;
                LinkedList<AdapterPart> linkedList = new LinkedList<AdapterPart>();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                    if (jSONArray2.length() < 2) continue;
                    String string3 = jSONArray2.getString(0);
                    String string4 = jSONArray2.getString(1);
                    if (!hashMap.containsKey(string3) || ((AbstractAdapterConfiguration)hashMap.get(string3)).targets() == null || !((AbstractAdapterConfiguration)hashMap.get(string3)).targets().contains(string4)) continue;
                    linkedList.add(new AdapterPart(string3, string4, ((AbstractAdapterConfiguration)hashMap.get(string3)).isEnabled(), ((AbstractAdapterConfiguration)hashMap.get((Object)string3)).requiredLicense().license_id));
                }
                hashMap2.put(string2, linkedList);
            }
            this.config.clear();
            this.config.putAll(hashMap2);
            this.inform_change_listeners();
            return true;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
    }

    public boolean renameTarget(String string, String string2) {
        List<AdapterPart> list = this.config.remove(string);
        if (list != null) {
            this.config.put(string2, list);
            this.inform_change_listeners();
            return true;
        }
        return false;
    }

    public boolean renameAdapter(String string, String string2) {
        boolean bl = false;
        for (List<AdapterPart> list : this.config.values()) {
            for (AdapterPart adapterPart : list) {
                if (!adapterPart.adapter_name.equals(string)) continue;
                adapterPart.adapter_name = string2;
                bl = true;
            }
        }
        if (bl) {
            this.inform_change_listeners();
        }
        return bl;
    }

    public boolean renameSource(String string, String string2, String string3) {
        boolean bl = false;
        for (List<AdapterPart> list : this.config.values()) {
            for (AdapterPart adapterPart : list) {
                if (!adapterPart.adapter_name.equals(string) || !adapterPart.entry.equals(string2)) continue;
                adapterPart.entry = string3;
                bl = true;
            }
        }
        if (bl) {
            this.inform_change_listeners();
        }
        return bl;
    }

    public boolean cleanup(List<String> list) {
        int n = this.config.size();
        Iterator<Map.Entry<String, List<AdapterPart>>> iterator = this.config.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<AdapterPart>> entry = iterator.next();
            if (list.contains(entry.getKey())) continue;
            iterator.remove();
        }
        return n != this.config.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(SchadchenChangeListener schadchenChangeListener) {
        Set<SchadchenChangeListener> set = this.change_listeners;
        synchronized (set) {
            this.change_listeners.add(schadchenChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(SchadchenChangeListener schadchenChangeListener) {
        Set<SchadchenChangeListener> set = this.change_listeners;
        synchronized (set) {
            this.change_listeners.remove(schadchenChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inform_change_listeners() {
        Set<SchadchenChangeListener> set = this.change_listeners;
        synchronized (set) {
            for (SchadchenChangeListener schadchenChangeListener : this.change_listeners) {
                schadchenChangeListener.schadchenModified();
            }
        }
    }

    public Map<AbstractAdapterConfiguration, List<String>> getUnusedSources(List<AbstractAdapterConfiguration> list) {
        HashSet<CallSite> hashSet = new HashSet<CallSite>();
        for (String object : this.config.keySet()) {
            List<AdapterPart> list2 = this.config.get(object);
            if (list2 == null || list2.size() == 0) continue;
            for (Object object2 : list2) {
                hashSet.add((CallSite)((Object)(((AdapterPart)object2).adapter_name + SEP + ((AdapterPart)object2).entry)));
            }
        }
        HashMap hashMap = new HashMap();
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : list) {
            List<String> list3 = abstractAdapterConfiguration.targets();
            if (list3 == null || list3.size() == 0) continue;
            for (String string : list3) {
                String string2 = abstractAdapterConfiguration.getName() + SEP + string;
                if (hashSet.contains(string2)) continue;
                if (!hashMap.containsKey(abstractAdapterConfiguration)) {
                    hashMap.put(abstractAdapterConfiguration, new LinkedList());
                }
                ((List)hashMap.get(abstractAdapterConfiguration)).add(string);
            }
        }
        return hashMap;
    }

    public class AdapterPart {
        public String adapter_name;
        public String entry;
        public final String type;
        public final boolean enabled;

        JSONArray toJson() {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put((Object)this.adapter_name);
            jSONArray.put((Object)this.entry);
            return jSONArray;
        }

        public AdapterPart(String string, String string2, boolean bl, String string3) {
            this.adapter_name = string;
            this.entry = string2;
            this.enabled = bl;
            this.type = string3;
        }
    }
}

